/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.task;

import baguchan.frostrealm.entity.YetiEntity;
import baguchan.frostrealm.entity.task.AvoidWeatherTask;
import baguchan.frostrealm.entity.task.FinishedFoodHuntTask;
import baguchan.frostrealm.register.FrostEntityTypes;
import baguchan.frostrealm.register.FrostItems;
import baguchan.frostrealm.register.FrostMemoryModules;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.AttackTargetTask;
import net.minecraft.entity.ai.brain.task.DummyTask;
import net.minecraft.entity.ai.brain.task.EndAttackTask;
import net.minecraft.entity.ai.brain.task.FindInteractionAndLookTargetTask;
import net.minecraft.entity.ai.brain.task.FindNewAttackTargetTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.ForgetAttackTargetTask;
import net.minecraft.entity.ai.brain.task.GetAngryTask;
import net.minecraft.entity.ai.brain.task.InteractWithEntityTask;
import net.minecraft.entity.ai.brain.task.LookAtEntityTask;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.entity.ai.brain.task.MoveToTargetTask;
import net.minecraft.entity.ai.brain.task.PiglinIdleActivityTask;
import net.minecraft.entity.ai.brain.task.RunAwayTask;
import net.minecraft.entity.ai.brain.task.SwimTask;
import net.minecraft.entity.ai.brain.task.WalkRandomlyTask;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsLookTargetTask;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;

public class YetiTask {
    private static final RangedInteger TIME_BETWEEN_HUNTS = TickRangeConverter.func_233037_a_((int)320, (int)640);
    private static final RangedInteger BABY_AVOID_NEMESIS_DURATION = TickRangeConverter.func_233037_a_((int)5, (int)7);
    private static final Set<Item> FOOD_ITEMS = ImmutableSet.of((Object)FrostItems.FROZEN_FRUIT.get(), (Object)FrostItems.MELTED_FRUIT.get());

    public static Brain<?> makeBrain(YetiEntity yetiEntity, Brain<YetiEntity> brain) {
        YetiTask.initCoreActivity(brain);
        YetiTask.initIdleActivity(brain);
        YetiTask.initFightActivity(yetiEntity, brain);
        brain.func_218199_a((Set)ImmutableSet.of((Object)Activity.field_221365_a));
        brain.func_218200_b(Activity.field_221366_b);
        brain.func_233714_e_();
        return brain;
    }

    public static void initMemories(YetiEntity yeti) {
        int i = TIME_BETWEEN_HUNTS.func_233018_a_(yeti.field_70170_p.field_73012_v);
        yeti.func_213375_cj().func_233696_a_(MemoryModuleType.field_234082_P_, (Object)true, (long)i);
    }

    private static void initCoreActivity(Brain<YetiEntity> p_234464_0_) {
        p_234464_0_.func_233698_a_(Activity.field_221365_a, 0, ImmutableList.of((Object)new SwimTask(0.8f), (Object)new LookTask(45, 90), (Object)new WalkToTargetTask(), (Object)((Object)new AvoidWeatherTask(1.2f)), YetiTask.babyAvoidNemesis(), (Object)new EndAttackTask(300, (yeti, entity) -> false), (Object)new GetAngryTask()));
    }

    private static void initIdleActivity(Brain<YetiEntity> p_234485_0_) {
        p_234485_0_.func_233698_a_(Activity.field_221366_b, 10, ImmutableList.of((Object)new ForgetAttackTargetTask(YetiTask::findNearestValidAttackTarget), YetiTask.avoidRepellent(), YetiTask.createIdleLookBehaviors(), YetiTask.createIdleMovementBehaviors(), (Object)new FindInteractionAndLookTargetTask(EntityType.field_200729_aH, 4)));
    }

    private static void initFightActivity(YetiEntity p_234488_0_, Brain<YetiEntity> p_234488_1_) {
        p_234488_1_.func_233699_a_(Activity.field_234621_k_, 10, ImmutableList.of((Object)new FindNewAttackTargetTask(p_234523_1_ -> !YetiTask.isNearestValidAttackTarget(p_234488_0_, p_234523_1_)), (Object)new MoveToTargetTask(1.0f), (Object)new AttackTargetTask(50), new FinishedFoodHuntTask()), MemoryModuleType.field_234103_o_);
    }

    private static FirstShuffledTask<YetiEntity> createIdleLookBehaviors() {
        return new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_200729_aH, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(FrostEntityTypes.YETI_TYPE, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(8.0f), (Object)1), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)1)));
    }

    private static FirstShuffledTask<YetiEntity> createIdleMovementBehaviors() {
        return new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new WalkRandomlyTask(0.65f), (Object)2), (Object)Pair.of((Object)InteractWithEntityTask.func_220445_a(FrostEntityTypes.YETI_TYPE, (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)new WalkTowardsLookTargetTask(0.6f, 3), (Object)2), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)1)));
    }

    private static RunAwayTask<BlockPos> avoidRepellent() {
        return RunAwayTask.func_233963_a_((MemoryModuleType)MemoryModuleType.field_234098_af_, (float)1.0f, (int)8, (boolean)false);
    }

    private static PiglinIdleActivityTask<YetiEntity, LivingEntity> babyAvoidNemesis() {
        return new PiglinIdleActivityTask(YetiEntity::func_70631_g_, MemoryModuleType.field_234077_K_, MemoryModuleType.field_234106_z_, BABY_AVOID_NEMESIS_DURATION);
    }

    private static boolean isNearestValidAttackTarget(YetiEntity p_234504_0_, LivingEntity p_234504_1_) {
        return YetiTask.findNearestValidAttackTarget(p_234504_0_).filter(p_234483_1_ -> p_234483_1_ == p_234504_1_).isPresent();
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(YetiEntity p_234526_0_) {
        Optional optional1;
        Brain<YetiEntity> brain = p_234526_0_.func_213375_cj();
        Optional optional = BrainUtil.func_233864_a_((LivingEntity)p_234526_0_, (MemoryModuleType)MemoryModuleType.field_234078_L_);
        if (optional.isPresent() && YetiTask.isAttackAllowed((LivingEntity)optional.get())) {
            return optional;
        }
        if (brain.func_218191_a(MemoryModuleType.field_234079_M_) && (optional1 = brain.func_218207_c(MemoryModuleType.field_234102_l_)).isPresent()) {
            return optional1;
        }
        Optional optional3 = brain.func_218207_c(MemoryModuleType.field_234077_K_);
        if (optional3.isPresent()) {
            return optional3;
        }
        return Optional.empty();
    }

    private static boolean isAttackAllowed(LivingEntity p_234506_0_) {
        return EntityPredicates.field_233583_f_.test(p_234506_0_);
    }

    protected static void dontKillAnyMoreFoodSourceForAWhile(YetiEntity p_234518_0_) {
        p_234518_0_.func_213375_cj().func_233696_a_(MemoryModuleType.field_234082_P_, (Object)true, (long)TIME_BETWEEN_HUNTS.func_233018_a_(p_234518_0_.field_70170_p.field_73012_v));
    }

    protected static void pickUpItem(YetiEntity p_234470_0_, ItemEntity p_234470_1_) {
        ItemStack itemstack = YetiTask.removeOneItemFromItemEntity(p_234470_1_);
        p_234470_0_.func_71001_a((Entity)p_234470_1_, 1);
        if (YetiTask.isFood(itemstack.func_77973_b()) && !YetiTask.hasEatenRecently(p_234470_0_)) {
            YetiTask.eat(p_234470_0_);
        }
    }

    private static boolean isFood(Item p_234499_0_) {
        return FOOD_ITEMS.contains(p_234499_0_);
    }

    private static ItemStack removeOneItemFromItemEntity(ItemEntity p_234465_0_) {
        ItemStack itemstack = p_234465_0_.func_92059_d();
        ItemStack itemstack1 = itemstack.func_77979_a(1);
        if (itemstack.func_190926_b()) {
            p_234465_0_.func_70106_y();
        } else {
            p_234465_0_.func_92058_a(itemstack);
        }
        return itemstack1;
    }

    private static void eat(YetiEntity p_234536_0_) {
        p_234536_0_.func_213375_cj().func_233696_a_(MemoryModuleType.field_234097_ae_, (Object)true, 200L);
    }

    private static boolean hasEatenRecently(YetiEntity p_234538_0_) {
        return p_234538_0_.func_213375_cj().func_218191_a(MemoryModuleType.field_234097_ae_);
    }

    public static void updateActivity(YetiEntity yetiEntity) {
        Brain<YetiEntity> brain = yetiEntity.func_213375_cj();
        Activity activity = brain.func_233716_f_().orElse(null);
        brain.func_233706_a_((List)ImmutableList.of((Object)Activity.field_234621_k_, (Object)Activity.field_221366_b));
        Activity activity1 = brain.func_233716_f_().orElse(null);
        yetiEntity.func_213395_q(brain.func_218191_a(MemoryModuleType.field_234103_o_));
    }

    public static void wasHurtBy(YetiEntity p_234468_0_, LivingEntity p_234468_1_) {
        if (!(p_234468_1_ instanceof YetiEntity)) {
            Brain<YetiEntity> brain = p_234468_0_.func_213375_cj();
            if (p_234468_0_.func_70631_g_()) {
                brain.func_233696_a_(MemoryModuleType.field_234106_z_, (Object)p_234468_1_, 100L);
                if (YetiTask.isAttackAllowed(p_234468_1_)) {
                    YetiTask.setAngerTargetIfCloserThanCurrent(p_234468_0_, p_234468_1_);
                }
            } else {
                YetiTask.maybeRetaliate(p_234468_0_, p_234468_1_);
            }
        }
    }

    private static void setAngerTargetIfCloserThanCurrent(YetiEntity p_234513_0_, LivingEntity p_234513_1_) {
        Optional<LivingEntity> optional = YetiTask.getAngerTarget(p_234513_0_);
        LivingEntity livingentity = BrainUtil.func_233867_a_((LivingEntity)p_234513_0_, optional, (LivingEntity)p_234513_1_);
        if (!optional.isPresent() || optional.get() != livingentity) {
            YetiTask.setAngerTarget(p_234513_0_, livingentity);
        }
    }

    protected static void setAngerTarget(YetiEntity p_234497_0_, LivingEntity p_234497_1_) {
        if (YetiTask.isAttackAllowed(p_234497_1_)) {
            p_234497_0_.func_213375_cj().func_218189_b(MemoryModuleType.field_223021_x);
            p_234497_0_.func_213375_cj().func_233696_a_(MemoryModuleType.field_234078_L_, (Object)p_234497_1_.func_110124_au(), 600L);
            if (YetiTask.isFoodSource(p_234497_1_)) {
                YetiTask.dontKillAnyMoreFoodSourceForAWhile(p_234497_0_);
            }
            if (p_234497_1_.func_200600_R() == EntityType.field_200729_aH && p_234497_0_.field_70170_p.func_82736_K().func_223586_b(GameRules.field_234896_G_)) {
                p_234497_0_.func_213375_cj().func_233696_a_(MemoryModuleType.field_234079_M_, (Object)true, 600L);
            }
        }
    }

    public static boolean isFoodSource(LivingEntity p_234497_1_) {
        return p_234497_1_ instanceof AbstractFishEntity;
    }

    private static Optional<LivingEntity> getAngerTarget(YetiEntity p_234532_0_) {
        return BrainUtil.func_233864_a_((LivingEntity)p_234532_0_, (MemoryModuleType)MemoryModuleType.field_234078_L_);
    }

    protected static void maybeRetaliate(YetiEntity p_234509_0_, LivingEntity p_234509_1_) {
        if (!p_234509_0_.func_213375_cj().func_218214_c(Activity.field_234624_n_) && YetiTask.isAttackAllowed(p_234509_1_) && !BrainUtil.func_233861_a_((LivingEntity)p_234509_0_, (LivingEntity)p_234509_1_, (double)4.0)) {
            if (p_234509_1_.func_200600_R() == EntityType.field_200729_aH && p_234509_0_.field_70170_p.func_82736_K().func_223586_b(GameRules.field_234896_G_)) {
                YetiTask.setAngerTargetToNearestTargetablePlayerIfFound(p_234509_0_, p_234509_1_);
                YetiTask.broadcastUniversalAnger(p_234509_0_);
            } else {
                YetiTask.setAngerTarget(p_234509_0_, p_234509_1_);
                YetiTask.broadcastAngerTarget(p_234509_0_, p_234509_1_);
            }
        }
    }

    private static void stopWalking(PiglinEntity p_234531_0_) {
        p_234531_0_.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
        p_234531_0_.func_70661_as().func_75499_g();
    }

    protected static void broadcastUniversalAnger(YetiEntity p_241430_0_) {
        YetiTask.getAdultYetis(p_241430_0_).forEach(p_241419_0_ -> YetiTask.getNearestVisibleTargetablePlayer(p_241419_0_).ifPresent(p_241421_1_ -> YetiTask.setAngerTarget(p_241419_0_, (LivingEntity)p_241421_1_)));
    }

    protected static void broadcastAngerTarget(YetiEntity p_234487_0_, LivingEntity p_234487_1_) {
        YetiTask.getAdultYetis(p_234487_0_).forEach(p_234484_1_ -> YetiTask.setAngerTargetIfCloserThanCurrent(p_234484_1_, p_234487_1_));
    }

    private static List<YetiEntity> getAdultYetis(YetiEntity p_234530_0_) {
        return (List)p_234530_0_.func_213375_cj().func_218207_c((MemoryModuleType)FrostMemoryModules.NEARBY_ADULT_YETI.get()).orElse(ImmutableList.of());
    }

    private static void setAngerTargetToNearestTargetablePlayerIfFound(YetiEntity p_241431_0_, LivingEntity p_241431_1_) {
        Optional<PlayerEntity> optional = YetiTask.getNearestVisibleTargetablePlayer(p_241431_0_);
        if (optional.isPresent()) {
            YetiTask.setAngerTarget(p_241431_0_, (LivingEntity)optional.get());
        } else {
            YetiTask.setAngerTarget(p_241431_0_, p_241431_1_);
        }
    }

    public static Optional<PlayerEntity> getNearestVisibleTargetablePlayer(YetiEntity p_241432_0_) {
        return p_241432_0_.func_213375_cj().func_218191_a(MemoryModuleType.field_234102_l_) ? p_241432_0_.func_213375_cj().func_218207_c(MemoryModuleType.field_234102_l_) : Optional.empty();
    }
}

