/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.event;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.capability.ColdCapability;
import baguchan.frostrealm.network.ChangedColdPacket;
import baguchan.frostrealm.network.NetworkHandler;
import baguchan.frostrealm.register.FrostBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="frostrealm")
public class CommonEventHandler {
    @SubscribeEvent
    public static void onHoeEvent(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        BlockState state = event.getWorld().func_180495_p(event.getHitVec().func_216350_a());
        BlockState stateUp = event.getWorld().func_180495_p(event.getHitVec().func_216350_a().func_177984_a());
        if (stack.func_77973_b() instanceof HoeItem && (state.func_177230_c() == FrostBlocks.FROZEN_DIRT.get() || state.func_177230_c() == FrostBlocks.FROZEN_GRASS_BLOCK.get()) && stateUp.func_196958_f()) {
            event.getWorld().func_180501_a(event.getHitVec().func_216350_a(), ((Block)FrostBlocks.FROZEN_FARMLAND.get()).func_176223_P(), 2);
            event.getPlayer().func_184609_a(event.getHand());
            stack.func_222118_a(1, (LivingEntity)event.getPlayer(), playerEntity -> playerEntity.func_213334_d(event.getHand()));
            event.getWorld().func_184133_a(event.getPlayer(), event.getHitVec().func_216350_a(), SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("frostrealm", "cold"), (ICapabilityProvider)new ColdCapability());
        }
    }

    @SubscribeEvent
    public static void onEntitySpawn(LivingSpawnEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!livingEntity.field_70170_p.field_72995_K) {
            livingEntity.getCapability(FrostRealm.COLD_CAP).ifPresent(cap -> {
                ChangedColdPacket message = new ChangedColdPacket((Entity)livingEntity, cap.getTemperatureLevel(), cap.getSaturationLevel());
                NetworkHandler.SIMPLE_CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> livingEntity), (Object)message);
            });
        }
    }

    @SubscribeEvent
    public static void onUpdateCapability(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!livingEntity.field_70170_p.field_72995_K) {
            livingEntity.getCapability(FrostRealm.COLD_CAP).ifPresent(cap -> cap.tick(livingEntity));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            player.getCapability(FrostRealm.COLD_CAP).ifPresent(cap -> NetworkHandler.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new ChangedColdPacket((Entity)player, cap.getTemperatureLevel(), cap.getSaturationLevel())));
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerEntity playerEntity = event.getPlayer();
        playerEntity.getCapability(FrostRealm.COLD_CAP).ifPresent(cap -> NetworkHandler.SIMPLE_CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> playerEntity), (Object)new ChangedColdPacket((Entity)playerEntity, cap.getTemperatureLevel(), cap.getSaturationLevel())));
    }
}

