/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.event;

import baguchan.frostrealm.api.Weather;
import baguchan.frostrealm.register.FrostDimensions;
import baguchan.frostrealm.register.FrostWeatherSystem;
import baguchan.frostrealm.utils.WeatherUtil;
import baguchan.frostrealm.world.data.FrostWeatherData;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WeatherHandler {
    public static final WeatherHandler INSTANCE = new WeatherHandler();
    public float oWeatherStrength;
    public float weatherStrength;
    private long lastUpdateTime;
    public Weather playingWeather;
    private boolean isWeak;

    public float getWeatherStrength(float p_72867_1_) {
        return MathHelper.func_219799_g((float)p_72867_1_, (float)this.oWeatherStrength, (float)this.weatherStrength);
    }

    public boolean isBlizzard() {
        return this.playingWeather.getID() == FrostWeatherSystem.BLIZZARD;
    }

    public boolean isNoWeather() {
        return this.playingWeather.getID() == FrostWeatherSystem.CLEAR;
    }

    public boolean isFog() {
        return this.playingWeather.getID() == FrostWeatherSystem.FOG;
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            FrostWeatherData data = FrostWeatherData.get((IWorld)event.world);
            this.oWeatherStrength = this.weatherStrength;
            if (this.playingWeather != null) {
                if (data.getEvent().getID() == FrostWeatherSystem.BLIZZARD) {
                    this.isWeak = false;
                    this.weatherStrength = (float)((double)this.weatherStrength + 0.01);
                } else {
                    this.isWeak = true;
                    this.weatherStrength = (float)((double)this.weatherStrength - 0.01);
                }
            }
            this.weatherStrength = MathHelper.func_76131_a((float)this.weatherStrength, (float)0.0f, (float)1.0f);
            if (this.playingWeather == null) {
                this.playingWeather = data.getEvent();
            } else if (this.playingWeather.getID() != data.getEvent().getID() && !this.isWeak) {
                this.playingWeather = data.getEvent();
            } else if (this.playingWeather.getID() != data.getEvent().getID() && this.isWeak && this.weatherStrength <= 0.0f) {
                this.playingWeather = data.getEvent();
            }
            if (event.side.isServer()) {
                World world = event.world;
                ServerWorld serverWorld = (ServerWorld)event.world;
                if (serverWorld.func_201672_e().func_234923_W_() == FrostDimensions.frostrealm) {
                    int tickSpeed = world.func_82736_K().func_223592_c(GameRules.field_223610_m);
                    long worldTime = world.func_72912_H().func_82573_f();
                    WeatherUtil.doWeatherAndRollWeatherEventChance(FrostWeatherData.get((IWorld)serverWorld), serverWorld);
                    if (worldTime % 10L == 0L) {
                        FrostWeatherSystem.updateWeatherEventPacket(serverWorld, serverWorld.func_217490_a(LivingEntity::func_70089_S), false);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void renderTickEvent(TickEvent.RenderTickEvent event) {
    }

    @SubscribeEvent
    public void worldLoadEvent(WorldEvent.Load event) {
    }

    @SubscribeEvent
    public void playerTickEvent(TickEvent.PlayerTickEvent event) {
    }

    @SubscribeEvent
    public void entityTickEvent(LivingEvent.LivingUpdateEvent event) {
        FrostWeatherData.currentWeather.livingEntityUpdate(event.getEntity());
    }

    @SubscribeEvent
    public void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        FrostWeatherSystem.updateWeatherEventPacket(((ServerPlayerEntity)event.getPlayer()).func_71121_q(), Collections.singletonList((ServerPlayerEntity)event.getPlayer()), true);
    }

    @SubscribeEvent
    public void clientTickEvent(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START && minecraft.field_71441_e != null && minecraft.field_71439_g != null && minecraft.field_71441_e.func_234923_W_() == FrostDimensions.frostrealm) {
            int n = minecraft.field_71441_e.func_82736_K().func_223592_c(GameRules.field_223610_m);
        }
    }
}

