/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.network;

import baguchan.frostrealm.network.ChangedColdPacket;
import baguchan.frostrealm.network.WeatherPacket;
import baguchan.frostrealm.network.WeatherStrengthPacket;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel SIMPLE_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("frostrealm", "network"), () -> "1", "1"::equals, "1"::equals);

    public static void init() {
        SIMPLE_CHANNEL.registerMessage(0, WeatherPacket.class, WeatherPacket::writeToPacket, WeatherPacket::readFromPacket, WeatherPacket::handle);
        SIMPLE_CHANNEL.registerMessage(1, WeatherStrengthPacket.class, WeatherStrengthPacket::writeToPacket, WeatherStrengthPacket::readFromPacket, WeatherStrengthPacket::handle);
        SIMPLE_CHANNEL.registerMessage(2, ChangedColdPacket.class, ChangedColdPacket::writeToPacket, ChangedColdPacket::readFromPacket, ChangedColdPacket::handle);
    }

    public static void sendToClient(ServerPlayerEntity playerEntity, Object objectToSend) {
        SIMPLE_CHANNEL.sendTo(objectToSend, playerEntity.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToDimension(Object packet, ServerWorld serverWorld, RegistryKey<World> dimension) {
        PlayerList playerList = serverWorld.func_73046_m().func_184103_al();
        for (int i = 0; i < playerList.func_72394_k(); ++i) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)playerList.func_181057_v().get(i);
            if (serverPlayer.field_70170_p.func_234923_W_() != dimension) continue;
            NetworkHandler.sendToClient(serverPlayer, packet);
        }
    }

    public static void sendToServer(Object objectToSend) {
        SIMPLE_CHANNEL.sendToServer(objectToSend);
    }
}

