/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.register;

import baguchan.frostrealm.register.FrostBlocks;
import baguchan.frostrealm.register.FrostTags;
import baguchan.frostrealm.world.feature.FRTreeFeature;
import baguchan.frostrealm.world.feature.IceAndThickSnowFeature;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BasaltDeltasFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.FeatureSpreadConfig;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.LiquidsConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.foliageplacer.BushFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FancyFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.FancyTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class FrostFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"frostrealm");
    public static final RegistryObject<Feature<BaseTreeFeatureConfig>> FROSTREALM_TREE = FEATURES.register("frostrealm_tree", () -> new FRTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> ICE_THICK_SNOW = FEATURES.register("ice_and_thick_snow", () -> new IceAndThickSnowFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static void registerConfiguredFeatures() {
        FrostFeatures.register("spring", (ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.SPRING.func_227228_a_(Placement.field_242908_m.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(8, 8, 256))).func_242728_a()).func_242731_b(50));
        FrostFeatures.register("hot_spring_pond", ConfiguredFeatures.HOT_SPRING_PONDS.func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(40))));
        FrostFeatures.register("frost_crystal_ore", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.FROST_CRYSTAL_ORE.func_242733_d(256)).func_242728_a()).func_242731_b(30));
        FrostFeatures.register("glimmerrock_ore", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.GLIMMERROCK_ORE.func_242733_d(128)).func_242728_a()).func_242731_b(10));
        FrostFeatures.register("frostbulb_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.FROSTBULB_MUSHROOM_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(2));
        FrostFeatures.register("frostbulb_forest_patch", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.FROSTBULB_MUSHROOM_PATCH.func_242733_d(256)).func_242728_a()).func_242731_b(4));
        FrostFeatures.register("frostroot_plain_vegitation", ConfiguredFeatures.FROSTROOT_PLAIN_VEGETATION);
        FrostFeatures.register("frostroot_forest_vegitation", ConfiguredFeatures.FROSTROOT_FOREST_VEGETATION);
        FrostFeatures.register("ice_thick_snow", ConfiguredFeatures.ICE_THICK_SNOW);
    }

    private static <FC extends IFeatureConfig> void register(String name, ConfiguredFeature<FC, ?> feature) {
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("frostrealm", name), feature);
    }

    public static final class ConfiguredFeatures {
        static final RuleTest FRIGID_STONE_FILLER = new TagMatchRuleTest(FrostTags.Blocks.BASE_STONE_FROSTREALM);
        public static final ConfiguredFeature<?, ?> SPRING = Feature.field_202295_ao.func_225566_b_((IFeatureConfig)new LiquidsConfig(Fluids.field_204546_a.func_207188_f(), false, 4, 1, (Set)ImmutableSet.of((Object)FrostBlocks.FRIGID_STONE.get(), (Object)FrostBlocks.FROZEN_GRASS_BLOCK.get(), (Object)FrostBlocks.FROZEN_DIRT.get())));
        public static final ConfiguredFeature<?, ?> HOT_SPRING_PONDS = Feature.field_236286_Q_.func_225566_b_((IFeatureConfig)new BasaltDeltasFeature(((FlowingFluidBlock)FrostBlocks.HOT_SPRING.get()).func_176223_P(), ((Block)FrostBlocks.FRIGID_STONE.get()).func_176223_P(), FeatureSpread.func_242253_a((int)6, (int)8), FeatureSpread.func_242253_a((int)0, (int)4)));
        public static final ConfiguredFeature<?, ?> FROST_CRYSTAL_ORE = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(FRIGID_STONE_FILLER, ((Block)FrostBlocks.FROST_CRYSTAL_ORE.get()).func_176223_P(), 17));
        public static final ConfiguredFeature<?, ?> GLIMMERROCK_ORE = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(FRIGID_STONE_FILLER, ((Block)FrostBlocks.GLIMMERROCK_ORE.get()).func_176223_P(), 9));
        public static final ConfiguredFeature<?, ?> FROSTBULB_MUSHROOM_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)FrostBlocks.FROSTBULB_MUSHROOM.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_());
        public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> FROSTROOT_TREE = ((Feature)FROSTREALM_TREE.get()).func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((RotatedPillarBlock)FrostBlocks.FROSTROOT_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((LeavesBlock)FrostBlocks.FROSTROOT_LEAVES.get()).func_176223_P()), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)3), 3), (AbstractTrunkPlacer)new FancyTrunkPlacer(3, 4, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
        public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> SMALL_FROSTROOT_TREE = ((Feature)FROSTREALM_TREE.get()).func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((RotatedPillarBlock)FrostBlocks.FROSTROOT_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((LeavesBlock)FrostBlocks.FROSTROOT_LEAVES.get()).func_176223_P()), (FoliagePlacer)new BushFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)1), 2), (AbstractTrunkPlacer)new StraightTrunkPlacer(3, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
        public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> FANCY_FROSTROOT_TREE = ((Feature)FROSTREALM_TREE.get()).func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((RotatedPillarBlock)FrostBlocks.FROSTROOT_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((LeavesBlock)FrostBlocks.FROSTROOT_LEAVES.get()).func_176223_P()), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)4), 4), (AbstractTrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_());
        public static final ConfiguredFeature<?, ?> FROSTROOT_PLAIN_VEGETATION = Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)SMALL_FROSTROOT_TREE.func_227227_a_(0.33333334f)), FROSTROOT_TREE)).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.05f, 1)));
        public static final ConfiguredFeature<?, ?> FROSTROOT_FOREST_VEGETATION = Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)FANCY_FROSTROOT_TREE.func_227227_a_(0.33333334f)), FROSTROOT_TREE)).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(4, 0.05f, 1)));
        public static final ConfiguredFeature<?, ?> ICE_THICK_SNOW = ((Feature)ICE_THICK_SNOW.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
    }
}

