/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.world.data;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.api.Weather;
import baguchan.frostrealm.register.FrostDimensions;
import baguchan.frostrealm.register.FrostWeatherSystem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class FrostWeatherData
extends WorldSavedData {
    public static String DATA_NAME = "frostrealm:weather_data";
    private static final FrostWeatherData CLIENT_CACHE = new FrostWeatherData();
    private ResourceLocation event = FrostWeatherSystem.CLEAR;
    private boolean isWeatherForced;
    private boolean modified;
    private int rainTime;
    private int clearWeatherTime;
    public static Weather currentWeather;

    public FrostWeatherData() {
        super(DATA_NAME);
    }

    public FrostWeatherData(String s) {
        super(s);
    }

    public static FrostWeatherData get(IWorld world) {
        if (!(world instanceof ServerWorld)) {
            return CLIENT_CACHE;
        }
        ServerWorld frostWorld = ((ServerWorld)world).func_201672_e().func_73046_m().func_71218_a(FrostDimensions.frostrealm);
        DimensionSavedDataManager data = frostWorld.func_217481_x();
        FrostWeatherData weatherData = (FrostWeatherData)data.func_215752_a(FrostWeatherData::new, DATA_NAME);
        if (weatherData == null) {
            weatherData = new FrostWeatherData();
            data.func_215757_a((WorldSavedData)weatherData);
        }
        return weatherData;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.setEvent(nbt.func_74779_i("Event"));
        this.setWeatherForced(nbt.func_74767_n("Forced"));
        this.setModified(nbt.func_74767_n("Modified"));
        this.setRainTime(nbt.func_74762_e("RainTime"));
        this.setClearWeatherTime(nbt.func_74762_e("ClearRainTime"));
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74778_a("Event", this.event.toString());
        compound.func_74757_a("Forced", this.isWeatherForced);
        compound.func_74757_a("Modified", this.modified);
        compound.func_74768_a("RainTime", this.rainTime);
        compound.func_74768_a("ClearRainTime", this.clearWeatherTime);
        return compound;
    }

    public boolean isNoWeather() {
        return this.event.equals((Object)FrostWeatherSystem.CLEAR);
    }

    public String getEventString() {
        return this.event.toString();
    }

    public ResourceLocation getEventID() {
        return this.event;
    }

    public Weather getEvent() {
        Weather weatherEvent = FrostWeatherSystem.WEATHER_EVENTS.get(this.event);
        if (weatherEvent == null) {
            weatherEvent = FrostWeatherSystem.WEATHER_EVENTS.get(FrostWeatherSystem.CLEAR);
            FrostRealm.LOGGER.error("Getting the current Weather Event saved data was null for this world, restoring data by defaulting to clear...");
        }
        return weatherEvent;
    }

    public void setEvent(String event) {
        this.event = new ResourceLocation(event);
        this.func_76185_a();
        Weather currentWeather = FrostWeatherSystem.WEATHER_EVENTS.get(this.event);
        if (currentWeather == null) {
            FrostWeatherData.currentWeather = FrostWeatherSystem.WEATHER_EVENTS.get(FrostWeatherSystem.CLEAR);
            FrostRealm.LOGGER.error("Setting the current Weather Event saved data was null for this world, restoring data by defaulting to clear...");
        } else {
            FrostWeatherData.currentWeather = currentWeather;
        }
    }

    public boolean isWeatherForced() {
        return this.isWeatherForced;
    }

    public void setWeatherForced(boolean weatherForced) {
        this.isWeatherForced = weatherForced;
        this.func_76185_a();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        this.func_76185_a();
    }

    public int getClearWeatherTime() {
        return this.clearWeatherTime;
    }

    public void setClearWeatherTime(int p_230391_1_) {
        this.clearWeatherTime = p_230391_1_;
        this.func_76185_a();
    }

    public int getRainTime() {
        return this.rainTime;
    }

    public void setRainTime(int p_76080_1_) {
        this.rainTime = p_76080_1_;
        this.func_76185_a();
    }
}

