/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.world.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.Template;

public class FRTreeFeature
extends Feature<BaseTreeFeatureConfig> {
    public FRTreeFeature(Codec<BaseTreeFeatureConfig> codec) {
        super(codec);
    }

    public static boolean isLog(IWorldGenerationBaseReader world, BlockPos pos) {
        return FRTreeFeature.isReplaceableAt(world, pos) || world.func_217375_a(pos, state -> state.func_235714_a_((ITag)BlockTags.field_200031_h));
    }

    private static boolean isVine(IWorldGenerationBaseReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> state.func_203425_a(Blocks.field_150395_bd));
    }

    private static boolean isWater(IWorldGenerationBaseReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> state.func_203425_a(Blocks.field_150355_j));
    }

    public static boolean isLeaves(IWorldGenerationBaseReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    private static boolean isDirtOrFarmland(IWorldGenerationBaseReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            return FRTreeFeature.func_227250_b_((Block)block) || block == Blocks.field_150458_ak;
        });
    }

    private static boolean isTallPlant(IWorldGenerationBaseReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> {
            Material material = state.func_185904_a();
            return material == Material.field_151582_l;
        });
    }

    public static void setBlockKnownShape(IWorldWriter world, BlockPos pos, BlockState state) {
        world.func_180501_a(pos, state, 19);
    }

    public static boolean isReplaceableAt(IWorldGenerationBaseReader world, BlockPos pos) {
        return FRTreeFeature.isLeaves(world, pos) || FRTreeFeature.isTallPlant(world, pos) || FRTreeFeature.isWater(world, pos);
    }

    private boolean place(IWorldGenerationReader generationReader, Random rand, BlockPos positionIn, Set<BlockPos> leaves, Set<BlockPos> logs, MutableBoundingBox boundingBoxIn, BaseTreeFeatureConfig configIn) {
        int trunk = configIn.field_236678_g_.func_236917_a_(rand);
        int leaf = configIn.field_236677_f_.func_230374_a_(rand, trunk, configIn);
        int k = trunk - leaf;
        int l = configIn.field_236677_f_.func_230376_a_(rand, k);
        BlockPos blockpos = positionIn;
        if (blockpos.func_177956_o() >= 1 && blockpos.func_177956_o() + trunk + 1 <= 256) {
            if (!FRTreeFeature.isDirtOrFarmland((IWorldGenerationBaseReader)generationReader, blockpos.func_177977_b()) || FRTreeFeature.isWater((IWorldGenerationBaseReader)generationReader, positionIn)) {
                return false;
            }
            OptionalInt optionalint = configIn.field_236679_h_.func_236710_c_();
            int l1 = this.getMaxFreeTreeHeight((IWorldGenerationBaseReader)generationReader, trunk, blockpos, configIn);
            if (l1 >= trunk || optionalint.isPresent() && l1 >= optionalint.getAsInt()) {
                List list = configIn.field_236678_g_.func_230382_a_(generationReader, rand, l1, blockpos, leaves, boundingBoxIn, configIn);
                list.forEach(foliage -> configIn.field_236677_f_.func_236752_a_(generationReader, rand, configIn, l1, foliage, leaf, l, logs, boundingBoxIn));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(IWorldGenerationBaseReader p_241521_1_, int p_241521_2_, BlockPos p_241521_3_, BaseTreeFeatureConfig p_241521_4_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i = 0; i <= p_241521_2_ + 1; ++i) {
            int j = p_241521_4_.field_236679_h_.func_230369_a_(p_241521_2_, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    blockpos$mutable.func_239621_a_((Vector3i)p_241521_3_, k, i, l);
                    if (FRTreeFeature.isLog(p_241521_1_, (BlockPos)blockpos$mutable) && (p_241521_4_.field_236681_j_ || !FRTreeFeature.isVine(p_241521_1_, (BlockPos)blockpos$mutable))) continue;
                    return i - 2;
                }
            }
        }
        return p_241521_2_;
    }

    protected void func_230367_a_(IWorldWriter world, BlockPos pos, BlockState state) {
        FRTreeFeature.setBlockKnownShape(world, pos, state);
    }

    public final boolean place(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, BaseTreeFeatureConfig config) {
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_78887_a();
        boolean canPlace = this.place((IWorldGenerationReader)reader, rand, pos, set, set1, mutableboundingbox, config);
        if (mutableboundingbox.field_78897_a <= mutableboundingbox.field_78893_d && canPlace && !set.isEmpty()) {
            if (!config.field_227370_o_.isEmpty()) {
                ArrayList list = Lists.newArrayList((Iterable)set);
                ArrayList list1 = Lists.newArrayList((Iterable)set1);
                list.sort(Comparator.comparingInt(Vector3i::func_177956_o));
                list1.sort(Comparator.comparingInt(Vector3i::func_177956_o));
                config.field_227370_o_.forEach(treeDecorator -> treeDecorator.func_225576_a_(reader, rand, list, list1, set2, mutableboundingbox));
            }
            VoxelShapePart voxelshapepart = this.placeLogsAndLeaves((IWorld)reader, mutableboundingbox, set, set2);
            Template.func_222857_a((IWorld)reader, (int)3, (VoxelShapePart)voxelshapepart, (int)mutableboundingbox.field_78897_a, (int)mutableboundingbox.field_78895_b, (int)mutableboundingbox.field_78896_c);
            return true;
        }
        return false;
    }

    private VoxelShapePart placeLogsAndLeaves(IWorld world, MutableBoundingBox boundingBox, Set<BlockPos> p_236403_3_, Set<BlockPos> p_236403_4_) {
        ArrayList list = Lists.newArrayList();
        BitSetVoxelShapePart voxelshapepart = new BitSetVoxelShapePart(boundingBox.func_78883_b(), boundingBox.func_78882_c(), boundingBox.func_78880_d());
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (BlockPos blockpos : Lists.newArrayList(p_236403_4_)) {
            if (!boundingBox.func_175898_b((Vector3i)blockpos)) continue;
            voxelshapepart.func_199625_a(blockpos.func_177958_n() - boundingBox.field_78897_a, blockpos.func_177956_o() - boundingBox.field_78895_b, blockpos.func_177952_p() - boundingBox.field_78896_c, true, true);
        }
        for (BlockPos blockpos1 : Lists.newArrayList(p_236403_3_)) {
            if (boundingBox.func_175898_b((Vector3i)blockpos1)) {
                voxelshapepart.func_199625_a(blockpos1.func_177958_n() - boundingBox.field_78897_a, blockpos1.func_177956_o() - boundingBox.field_78895_b, blockpos1.func_177952_p() - boundingBox.field_78896_c, true, true);
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                blockpos$mutable.func_239622_a_((Vector3i)blockpos1, direction);
                if (p_236403_3_.contains(blockpos$mutable) || !(blockstate = world.func_180495_p((BlockPos)blockpos$mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa)) continue;
                ((Set)list.get(0)).add(blockpos$mutable.func_185334_h());
                FRTreeFeature.setBlockKnownShape((IWorldWriter)world, (BlockPos)blockpos$mutable, (BlockState)blockstate.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(1)));
                if (!boundingBox.func_175898_b((Vector3i)blockpos$mutable)) continue;
                voxelshapepart.func_199625_a(blockpos$mutable.func_177958_n() - boundingBox.field_78897_a, blockpos$mutable.func_177956_o() - boundingBox.field_78895_b, blockpos$mutable.func_177952_p() - boundingBox.field_78896_c, true, true);
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (boundingBox.func_175898_b((Vector3i)blockpos2)) {
                    voxelshapepart.func_199625_a(blockpos2.func_177958_n() - boundingBox.field_78897_a, blockpos2.func_177956_o() - boundingBox.field_78895_b, blockpos2.func_177952_p() - boundingBox.field_78896_c, true, true);
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    blockpos$mutable.func_239622_a_((Vector3i)blockpos2, direction1);
                    if (set.contains(blockpos$mutable) || set1.contains(blockpos$mutable) || !(blockstate1 = world.func_180495_p((BlockPos)blockpos$mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa) || (k = ((Integer)blockstate1.func_177229_b((Property)BlockStateProperties.field_208514_aa)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(l + 1));
                    FRTreeFeature.setBlockKnownShape((IWorldWriter)world, (BlockPos)blockpos$mutable, blockstate2);
                    if (boundingBox.func_175898_b((Vector3i)blockpos$mutable)) {
                        voxelshapepart.func_199625_a(blockpos$mutable.func_177958_n() - boundingBox.field_78897_a, blockpos$mutable.func_177956_o() - boundingBox.field_78895_b, blockpos$mutable.func_177952_p() - boundingBox.field_78896_c, true, true);
                    }
                    set1.add(blockpos$mutable.func_185334_h());
                }
            }
        }
        return voxelshapepart;
    }
}

