/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.block;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.register.FrostBlocks;
import baguchan.frostrealm.register.FrostDimensions;
import baguchan.frostrealm.world.FrostWorldTeleporter;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;

public class FrostPortalBlock
extends Block {
    public FrostPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean trySpawnPortal(Level worldIn, BlockPos pos) {
        Size size1 = new Size((LevelAccessor)worldIn, pos);
        if (size1.isValid()) {
            size1.placePortalBlocks();
            worldIn.m_5594_(null, pos, SoundEvents.f_11860_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Deprecated
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean good = world.m_8055_(pos.m_7495_()).m_60815_();
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            if (!good) break;
            BlockState neighboringState = world.m_8055_(pos.m_142300_(facing));
            good = neighboringState.m_60734_() == Blocks.f_50127_ || neighboringState == state;
        }
        if (!good) {
            world.m_6798_(2001, pos, Block.m_49956_((BlockState)state));
            world.m_7731_(pos, Blocks.f_49990_.m_49966_(), 3);
        }
    }

    public void m_7892_(BlockState p_196262_1_, Level p_196262_2_, BlockPos p_196262_3_, Entity p_196262_4_) {
        super.m_7892_(p_196262_1_, p_196262_2_, p_196262_3_, p_196262_4_);
        if (p_196262_4_.m_20092_()) {
            p_196262_4_.m_20091_();
        } else {
            p_196262_4_.getCapability(FrostRealm.FROST_PORTAL_CAP).ifPresent(cap -> {
                cap.setInPortal(true);
                int waitTime = cap.getPortalTimer();
                if (waitTime >= 160) {
                    FrostPortalBlock.attemptSendPlayer(p_196262_4_, p_196262_2_);
                    cap.setPortalTimer(0);
                }
            });
        }
    }

    private static ResourceKey<Level> getDestination(Entity entity) {
        return entity.f_19853_.m_46472_() == Level.f_46428_ ? FrostDimensions.frostrealm : Level.f_46428_;
    }

    public static void attemptSendPlayer(Entity entity, Level oldworld) {
        MinecraftServer minecraftserver;
        int i = entity.m_6078_();
        if (!entity.m_6084_()) {
            return;
        }
        if (entity.m_20159_() || entity.m_20160_() || !entity.m_6072_()) {
            return;
        }
        ResourceKey<Level> destination = FrostPortalBlock.getDestination(entity);
        if (entity.f_19853_ != null && (minecraftserver = entity.f_19853_.m_142572_()) != null) {
            ServerLevel serverWorld = oldworld.m_142572_().m_129880_(destination);
            if (serverWorld == null) {
                return;
            }
            entity.f_19853_.m_46473_().m_6180_("portal");
            entity.m_20091_();
            entity.changeDimension(serverWorld, (ITeleporter)new FrostWorldTeleporter());
            entity.f_19853_.m_46473_().m_7238_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        int random = rand.nextInt(100);
        if (random == 0) {
            worldIn.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12286_, SoundSource.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double xPos = (float)pos.m_123341_() + rand.nextFloat();
            double yPos = (double)pos.m_123342_() + 1.0;
            double zPos = (float)pos.m_123343_() + rand.nextFloat();
            double xSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            double ySpeed = rand.nextFloat();
            double d = ((double)rand.nextFloat() - 0.5) * 0.5;
        }
    }

    public static class Size {
        private static final int MAX_SIZE = 12;
        private static final int MIN_SIZE = 2;
        private final LevelAccessor world;
        private boolean valid = false;
        private BlockPos nw;
        private BlockPos se;

        public Size(LevelAccessor world, BlockPos pos) {
            this.world = world;
            int east = this.getDistanceUntilEdge(pos, Direction.EAST);
            int west = this.getDistanceUntilEdge(pos, Direction.WEST);
            int north = this.getDistanceUntilEdge(pos, Direction.NORTH);
            int south = this.getDistanceUntilEdge(pos, Direction.SOUTH);
            int width = east + west - 1;
            int length = north + south - 1;
            if (width > 12 || length > 12) {
                return;
            }
            if (width < 2 || length < 2) {
                return;
            }
            BlockPos neCorner = pos.m_142385_(east).m_142390_(north);
            BlockPos nwCorner = pos.m_142386_(west).m_142390_(north);
            BlockPos seCorner = pos.m_142385_(east).m_142383_(south);
            BlockPos swCorner = pos.m_142386_(west).m_142383_(south);
            this.nw = nwCorner.m_142082_(1, 0, 1);
            this.se = seCorner.m_142082_(-1, 0, -1);
            int wallWidth = width + 2;
            int wallLength = length + 2;
            for (int y = 0; y <= 1; ++y) {
                for (int x = 0; x < wallWidth; ++x) {
                    for (int z = 0; z < wallLength; ++z) {
                        if ((y != 0 || x == 0 || z == 0 || x == wallWidth - 1 || z == wallLength - 1) && (y != 1 || x != 0 && z != 0 && x != wallWidth - 1 && z != wallLength - 1) || this.isSnowBlock(world.m_8055_(nwCorner.m_7495_().m_142082_(x, y, z)))) continue;
                        return;
                    }
                }
            }
            this.valid = true;
        }

        int getDistanceUntilEdge(BlockPos pos, Direction facing) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 9 && this.isEmptyBlock(this.world.m_8055_(blockpos = pos.m_5484_(facing, i))) && this.isSnowBlock(this.world.m_8055_(blockpos.m_7495_())); ++i) {
            }
            BlockState state = this.world.m_8055_(pos.m_5484_(facing, i));
            return this.isSnowBlock(state) ? i : 0;
        }

        boolean isEmptyBlock(BlockState state) {
            return state.m_60734_() == Blocks.f_49990_;
        }

        boolean isSnowBlock(BlockState state) {
            return state.m_60734_() == Blocks.f_50127_;
        }

        public boolean isValid() {
            return this.valid;
        }

        void placePortalBlocks() {
            for (BlockPos portalPos : BlockPos.MutableBlockPos.m_121940_((BlockPos)this.nw, (BlockPos)this.se)) {
                this.world.m_7731_(portalPos, ((FrostPortalBlock)FrostBlocks.FROST_PORTAL.get()).m_49966_(), 2);
            }
        }
    }
}

