/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.block;

import baguchan.frostrealm.register.FrostBlocks;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class FrozenFarmlandBlock
extends Block {
    public static final IntegerProperty MOISTURE = BlockStateProperties.f_61423_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public FrozenFarmlandBlock(BlockBehaviour.Properties p_i48400_1_) {
        super(p_i48400_1_);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_7417_(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, LevelAccessor p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        if (p_196271_2_ == Direction.UP && !p_196271_1_.m_60710_((LevelReader)p_196271_4_, p_196271_5_)) {
            p_196271_4_.m_6219_().m_5945_(p_196271_5_, (Object)this, 1);
        }
        return super.m_7417_(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    public boolean m_7898_(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        BlockState blockstate = p_196260_2_.m_8055_(p_196260_3_.m_7494_());
        return !blockstate.m_60767_().m_76333_() || blockstate.m_60734_() instanceof FenceGateBlock || blockstate.m_60734_() instanceof MovingPistonBlock;
    }

    public BlockState m_5573_(BlockPlaceContext p_196258_1_) {
        return !this.m_49966_().m_60710_((LevelReader)p_196258_1_.m_43725_(), p_196258_1_.m_8083_()) ? ((Block)FrostBlocks.FROZEN_DIRT.get()).m_49966_() : super.m_5573_(p_196258_1_);
    }

    public boolean m_7923_(BlockState p_220074_1_) {
        return true;
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return SHAPE;
    }

    public void m_7458_(BlockState p_225534_1_, ServerLevel p_225534_2_, BlockPos p_225534_3_, Random p_225534_4_) {
        if (!p_225534_1_.m_60710_((LevelReader)p_225534_2_, p_225534_3_)) {
            FrozenFarmlandBlock.turnToDirt(p_225534_1_, (Level)p_225534_2_, p_225534_3_);
        }
    }

    public void m_7455_(BlockState p_225542_1_, ServerLevel p_225542_2_, BlockPos p_225542_3_, Random p_225542_4_) {
        int i = (Integer)p_225542_1_.m_61143_((Property)MOISTURE);
        if (!FrozenFarmlandBlock.isNearWater((LevelReader)p_225542_2_, p_225542_3_) && !p_225542_2_.m_46758_(p_225542_3_.m_7494_())) {
            if (i > 0) {
                p_225542_2_.m_7731_(p_225542_3_, (BlockState)p_225542_1_.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!this.isUnderCrops((BlockGetter)p_225542_2_, p_225542_3_)) {
                FrozenFarmlandBlock.turnToDirt(p_225542_1_, (Level)p_225542_2_, p_225542_3_);
            }
        } else if (i < 7) {
            p_225542_2_.m_7731_(p_225542_3_, (BlockState)p_225542_1_.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void m_142072_(Level p_152426_, BlockState p_152427_, BlockPos p_152428_, Entity p_152429_, float p_152430_) {
        if (!p_152426_.f_46443_ && ForgeHooks.onFarmlandTrample((Level)p_152426_, (BlockPos)p_152428_, (BlockState)((Block)FrostBlocks.FROZEN_DIRT.get()).m_49966_(), (float)p_152430_, (Entity)p_152429_)) {
            FrozenFarmlandBlock.turnToDirt(p_152426_.m_8055_(p_152428_), p_152426_, p_152428_);
        }
        super.m_142072_(p_152426_, p_152427_, p_152428_, p_152429_, p_152430_);
    }

    public static void turnToDirt(BlockState p_199610_0_, Level p_199610_1_, BlockPos p_199610_2_) {
        p_199610_1_.m_46597_(p_199610_2_, FrozenFarmlandBlock.m_49897_((BlockState)p_199610_0_, (BlockState)((Block)FrostBlocks.FROZEN_DIRT.get()).m_49966_(), (Level)p_199610_1_, (BlockPos)p_199610_2_));
    }

    private boolean isUnderCrops(BlockGetter p_176529_0_, BlockPos p_176529_1_) {
        BlockState plant = p_176529_0_.m_8055_(p_176529_1_.m_7494_());
        BlockState state = p_176529_0_.m_8055_(p_176529_1_);
        return plant.m_60734_() instanceof IPlantable && state.canSustainPlant(p_176529_0_, p_176529_1_, Direction.UP, (IPlantable)plant.m_60734_());
    }

    private static boolean isNearWater(LevelReader p_176530_0_, BlockPos p_176530_1_) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)p_176530_1_.m_142082_(-4, 0, -4), (BlockPos)p_176530_1_.m_142082_(4, 1, 4))) {
            if (!p_176530_0_.m_6425_(blockpos).m_76153_((Tag)FluidTags.f_13131_)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)p_176530_0_, (BlockPos)p_176530_1_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{MOISTURE});
    }

    public boolean m_7357_(BlockState p_60475_, BlockGetter p_60476_, BlockPos p_60477_, PathComputationType p_60478_) {
        return false;
    }
}

