/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.capability;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.network.ChangedColdPacket;
import baguchan.frostrealm.network.NetworkHandler;
import baguchan.frostrealm.register.FrostDimensions;
import baguchan.frostrealm.register.FrostTags;
import baguchan.frostrealm.world.data.FrostWeatherData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class ColdCapability
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    protected int temperature = 20;
    protected float temperatureSaturation = 1.0f;
    private int tickTimer;
    private float exhaustionLevel;
    private int lastTemperate = 20;
    private BlockPos hotSource;

    public void addExhaustion(float p_75113_1_) {
        this.exhaustionLevel = Math.min(this.exhaustionLevel + p_75113_1_, 40.0f);
    }

    public void addHot(int p_75122_1_, float p_75122_2_) {
        this.temperature = Math.min(p_75122_1_ + this.temperature, 20);
        this.temperatureSaturation = Math.min(this.temperatureSaturation + (float)p_75122_1_ * p_75122_2_ * 2.0f, (float)this.temperature);
    }

    public void eatHotFood(Item p_221410_1_, ItemStack p_221410_2_) {
        if (p_221410_1_.m_41472_()) {
            FoodProperties temperature = p_221410_1_.m_41473_();
            this.addHot(temperature.m_38744_() / 2, temperature.m_38745_() * 1.2f);
        }
    }

    public void tick(LivingEntity livingentity) {
        if (livingentity.f_19853_.m_46472_() == FrostDimensions.frostrealm && (!EntityTypeTags.f_144294_.m_8110_((Object)livingentity.m_6095_()) || livingentity instanceof Player && !((Player)livingentity).m_7500_() && !((Player)livingentity).m_5833_())) {
            Difficulty difficulty = livingentity.f_19853_.m_46791_();
            this.lastTemperate = this.temperature;
            this.hotSourceTick(livingentity);
            float tempAffect = 1.0f;
            if (!livingentity.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                tempAffect *= 0.9f;
            }
            if (!livingentity.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
                tempAffect *= 0.75f;
            }
            if (!livingentity.m_6844_(EquipmentSlot.LEGS).m_41619_()) {
                tempAffect *= 0.75f;
            }
            if (!livingentity.m_6844_(EquipmentSlot.FEET).m_41619_()) {
                tempAffect *= 0.9f;
            }
            if (FrostWeatherData.get((LevelAccessor)livingentity.f_19853_).isBrizzard() && livingentity.f_19853_.m_45527_(livingentity.m_142538_())) {
                tempAffect *= 1.5f;
            }
            if (this.hotSource == null) {
                this.addExhaustion(tempAffect * 0.01f);
                if (this.exhaustionLevel > 4.0f) {
                    this.exhaustionLevel -= 4.0f;
                    if (this.temperatureSaturation > 0.0f) {
                        this.temperatureSaturation = Math.max(this.temperatureSaturation - 0.1f, 0.0f);
                    } else if (difficulty != Difficulty.PEACEFUL) {
                        this.temperature = Math.max(this.temperature - 1, 0);
                    }
                }
            }
            if (EntityTypeTags.f_144295_.m_8110_((Object)livingentity.m_6095_())) {
                this.temperature = Math.max(this.temperature - 1, 0);
                this.temperatureSaturation = 0.0f;
                livingentity.m_6469_(DamageSource.f_146701_, 4.0f);
            } else if (this.temperature <= 0) {
                ++this.tickTimer;
                if (this.tickTimer >= 80) {
                    if (livingentity.m_21223_() > 4.0f || difficulty == Difficulty.HARD || difficulty == Difficulty.NORMAL) {
                        livingentity.m_6469_(DamageSource.f_146701_, 1.0f);
                    }
                    this.tickTimer = 0;
                }
            } else {
                this.tickTimer = 0;
            }
        } else {
            if (livingentity.f_19797_ % 20 == 0) {
                this.temperatureSaturation = Math.min(this.temperatureSaturation + 0.1f, 1.0f);
                this.temperature = Math.min(this.temperature + 1, 20);
            }
            this.exhaustionLevel = 0.0f;
        }
        if (livingentity.f_19797_ % 10 == 0 && !livingentity.f_19853_.m_5776_()) {
            ChangedColdPacket message = new ChangedColdPacket((Entity)livingentity, this.temperature, this.temperatureSaturation);
            NetworkHandler.SIMPLE_CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> livingentity), (Object)message);
        }
    }

    private void hotSourceTick(LivingEntity livingentity) {
        if (this.hotSource == null || !this.hotSource.m_123306_((Position)livingentity.m_20182_(), 3.46) || !livingentity.f_19853_.m_8055_(this.hotSource).m_60620_(FrostTags.Blocks.HOT_SOURCE) || livingentity.f_19853_.m_8055_(this.hotSource).m_60734_() instanceof CampfireBlock && !CampfireBlock.m_51319_((BlockState)livingentity.f_19853_.m_8055_(this.hotSource))) {
            this.hotSource = null;
        }
        if (this.hotSource == null) {
            int heatRange = 2;
            int entityPosX = (int)livingentity.m_20185_();
            int entityPosY = (int)livingentity.m_20186_();
            int entityPosZ = (int)livingentity.m_20189_();
            if (livingentity.f_19797_ % 20 == 0) {
                for (int hX = entityPosX - heatRange; hX <= entityPosX + heatRange; ++hX) {
                    for (int hY = entityPosY - 2; hY <= entityPosY; ++hY) {
                        for (int hZ = entityPosZ - heatRange; hZ <= entityPosZ + heatRange; ++hZ) {
                            if (!livingentity.f_19853_.m_8055_(new BlockPos(hX, hY, hZ)).m_60620_(FrostTags.Blocks.HOT_SOURCE)) continue;
                            this.hotSource = new BlockPos(hX, hY, hZ);
                        }
                    }
                }
            }
        }
        if (this.hotSource != null && this.hotSource.m_123306_((Position)livingentity.m_20182_(), 3.46) && livingentity.f_19797_ % 20 == 0) {
            this.temperatureSaturation = Math.min(this.temperatureSaturation + 0.1f, 1.0f);
            this.temperature = Math.min(this.temperature + 1, 20);
        }
    }

    public int getTemperatureLevel() {
        return this.temperature;
    }

    public float getSaturationLevel() {
        return this.temperatureSaturation;
    }

    public void setTemperatureLevel(int p_75114_1_) {
        this.temperature = p_75114_1_;
    }

    public void setSaturation(float p_75119_1_) {
        this.temperatureSaturation = p_75119_1_;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return capability == FrostRealm.COLD_CAP ? LazyOptional.of(() -> this).cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("temperatureLevel", this.temperature);
        nbt.m_128405_("temperatureTickTimer", this.tickTimer);
        nbt.m_128350_("temperatureSaturationLevel", this.temperatureSaturation);
        nbt.m_128350_("temperatureExhaustionLevel", this.exhaustionLevel);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128425_("temperatureLevel", 99)) {
            this.temperature = nbt.m_128451_("temperatureLevel");
            this.tickTimer = nbt.m_128451_("temperatureTickTimer");
            this.temperatureSaturation = nbt.m_128457_("temperatureSaturationLevel");
            this.exhaustionLevel = nbt.m_128457_("temperatureExhaustionLevel");
        }
    }
}

