/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.capability;

import baguchan.frostrealm.FrostRealm;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class FrostPortalCapability
implements ICapabilityProvider {
    private boolean isInPortal = false;
    private int aetherPortalTimer = 0;
    private float prevPortalAnimTime;
    private float portalAnimTime = 0.0f;

    public void portalTick(LivingEntity entity) {
        if (entity.f_19853_.f_46443_) {
            this.prevPortalAnimTime = this.portalAnimTime;
            Minecraft mc = Minecraft.m_91087_();
            if (this.isInPortal) {
                if (entity instanceof Player && mc.f_91080_ != null && !mc.f_91080_.m_7043_()) {
                    if (mc.f_91080_ instanceof ContainerScreen) {
                        ((Player)entity).m_6915_();
                    }
                    mc.m_91152_(null);
                }
                if (this.portalAnimTime == 0.0f) {
                    this.playPortalSound(mc);
                }
            }
        }
        if (this.isInPortal) {
            ++this.aetherPortalTimer;
            if (entity.f_19853_.f_46443_) {
                this.portalAnimTime += 0.0125f;
                if (this.portalAnimTime > 1.0f) {
                    this.portalAnimTime = 1.0f;
                }
            }
            this.isInPortal = false;
        } else {
            if (entity.f_19853_.f_46443_) {
                if (this.portalAnimTime > 0.0f) {
                    this.portalAnimTime -= 0.05f;
                }
                if (this.portalAnimTime < 0.0f) {
                    this.portalAnimTime = 0.0f;
                }
            }
            if (this.aetherPortalTimer > 0) {
                this.aetherPortalTimer -= 4;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playPortalSound(Minecraft mc) {
    }

    public void setInPortal(boolean inPortal) {
        this.isInPortal = inPortal;
    }

    public boolean isInPortal() {
        return this.isInPortal;
    }

    public void addPortalTime(int time) {
        this.aetherPortalTimer += time;
    }

    public void setPortalTimer(int timer) {
        this.aetherPortalTimer = timer;
    }

    public int getPortalTimer() {
        return this.aetherPortalTimer;
    }

    public float getPortalAnimTime() {
        return this.portalAnimTime;
    }

    public float getPrevPortalAnimTime() {
        return this.prevPortalAnimTime;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return capability == FrostRealm.FROST_PORTAL_CAP ? LazyOptional.of(() -> this).cast() : LazyOptional.empty();
    }
}

