/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.client.FrostDimensionRenderInfo;
import baguchan.frostrealm.client.model.FrostWraithModel;
import baguchan.frostrealm.client.render.entity.FrostWraithRenderer;
import baguchan.frostrealm.register.FrostBlocks;
import baguchan.frostrealm.register.FrostEntityTypes;
import baguchan.frostrealm.register.FrostModelLayers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="frostrealm", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientRegistrar {
    @SubscribeEvent
    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)FrostEntityTypes.FROST_WRAITH.get(), FrostWraithRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinition(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(FrostModelLayers.FROST_WRAITH, FrostWraithModel::createBodyLayer);
    }

    public static void renderEntity() {
    }

    public static void renderBlockEntity() {
    }

    public static void renderBlockAndItemColor() {
        BlockColors blockColors = Minecraft.m_91087_().m_91298_();
        ItemColors itemColor = Minecraft.m_91087_().getItemColors();
        blockColors.m_92589_((state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)reader, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0), new Block[]{(Block)FrostBlocks.FROZEN_GRASS_BLOCK.get()});
        blockColors.m_92589_((state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)reader, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0), new Block[]{(Block)FrostBlocks.FROST_GRASS.get()});
        itemColor.m_92689_((p_210235_1_, p_210235_2_) -> {
            BlockState blockstate = ((BlockItem)p_210235_1_.m_41720_()).m_40614_().m_49966_();
            return blockColors.m_92577_(blockstate, null, null, p_210235_2_);
        }, new ItemLike[]{(ItemLike)FrostBlocks.FROZEN_GRASS_BLOCK.get()});
        itemColor.m_92689_((p_210235_1_, p_210235_2_) -> {
            BlockState blockstate = ((BlockItem)p_210235_1_.m_41720_()).m_40614_().m_49966_();
            return blockColors.m_92577_(blockstate, null, null, p_210235_2_);
        }, new ItemLike[]{(ItemLike)FrostBlocks.FROST_GRASS.get()});
    }

    public static void renderBlockLayer() {
        ClientRegistrar.setRenderLayer((Block)FrostBlocks.FROST_PORTAL.get(), RenderType.m_110466_());
        ClientRegistrar.setRenderLayer((Block)FrostBlocks.FROZEN_GRASS_BLOCK.get(), RenderType.m_110457_());
        ClientRegistrar.setRenderLayer((Block)FrostBlocks.FROSTROOT_LEAVES.get(), RenderType.m_110457_());
        ClientRegistrar.setRenderLayer((Block)FrostBlocks.FROSTROOT_SAPLING.get(), RenderType.m_110463_());
        ClientRegistrar.setRenderLayer((Block)FrostBlocks.STARDUST_CRYSTAL_CLUSTER.get(), RenderType.m_110466_());
        ClientRegistrar.setRenderLayer((Block)FrostBlocks.FROST_GRASS.get(), RenderType.m_110463_());
        ClientRegistrar.setRenderLayer((Block)FrostBlocks.FROSTBULB_MUSHROOM.get(), RenderType.m_110463_());
        ClientRegistrar.setRenderLayer((Block)FrostBlocks.SUGARBEETS.get(), RenderType.m_110463_());
        ClientRegistrar.setRenderLayer((Block)FrostBlocks.FROST_TORCH.get(), RenderType.m_110463_());
        ClientRegistrar.setRenderLayer((Block)FrostBlocks.WALL_FROST_TORCH.get(), RenderType.m_110463_());
        ClientRegistrar.setRenderLayer((Block)FrostBlocks.FROST_CAMPFIRE.get(), RenderType.m_110463_());
        DimensionSpecialEffects.f_108857_.put((Object)FrostRealm.prefix("effect"), (Object)new FrostDimensionRenderInfo());
    }

    private static void setRenderLayer(Block block, RenderType type) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, type::equals);
    }

    private static void setRenderLayer(Fluid fluid, RenderType type) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, type::equals);
    }

    public static void setup(FMLCommonSetupEvent event) {
        ClientRegistrar.renderEntity();
        ClientRegistrar.renderBlockEntity();
        ClientRegistrar.renderBlockAndItemColor();
        ClientRegistrar.renderBlockLayer();
    }
}

