/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.event;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.block.FrostPortalBlock;
import baguchan.frostrealm.register.FrostBlocks;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientColdHUDEvent {
    protected final Random random = new Random();
    protected int tickCount;
    public static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("frostrealm", "textures/gui/icons.png");

    public static void renderPortalOverlay(RenderGameOverlayEvent.Post event, Minecraft mc, Window window, Entity livingEntity) {
        livingEntity.getCapability(FrostRealm.FROST_PORTAL_CAP).ifPresent(cap -> {
            if (cap.getPortalAnimTime() > 0.0f) {
                float timeInPortal = cap.getPrevPortalAnimTime() + (cap.getPortalAnimTime() - cap.getPrevPortalAnimTime()) * event.getPartialTicks();
                if (timeInPortal < 1.0f) {
                    timeInPortal *= timeInPortal;
                    timeInPortal *= timeInPortal;
                    timeInPortal = timeInPortal * 0.8f + 0.2f;
                }
                RenderSystem.m_69465_();
                RenderSystem.m_69458_((boolean)false);
                RenderSystem.m_69453_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)timeInPortal);
                RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                TextureAtlasSprite textureatlassprite = mc.m_91289_().m_110907_().m_110882_(((FrostPortalBlock)FrostBlocks.FROST_PORTAL.get()).m_49966_());
                float f = textureatlassprite.m_118409_();
                float f1 = textureatlassprite.m_118411_();
                float f2 = textureatlassprite.m_118410_();
                float f3 = textureatlassprite.m_118412_();
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tesselator.m_85915_();
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_5483_(0.0, (double)window.m_85444_(), -90.0).m_7421_(f, f3).m_5752_();
                bufferbuilder.m_5483_((double)window.m_85443_(), (double)window.m_85444_(), -90.0).m_7421_(f2, f3).m_5752_();
                bufferbuilder.m_5483_((double)window.m_85443_(), 0.0, -90.0).m_7421_(f2, f1).m_5752_();
                bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(f, f1).m_5752_();
                tesselator.m_85914_();
                RenderSystem.m_69458_((boolean)true);
                RenderSystem.m_69482_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        });
    }

    @SubscribeEvent
    public void renderHudEvent(RenderGameOverlayEvent.Post event) {
        Entity entity;
        PoseStack stack = event.getMatrixStack();
        Minecraft mc = Minecraft.m_91087_();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && mc.f_91065_ instanceof ForgeIngameGui) {
            entity = mc.m_91288_();
            int screenWidth = mc.m_91268_().m_85445_();
            int screenHeight = mc.m_91268_().m_85446_() - ((ForgeIngameGui)mc.f_91065_).right_height;
            this.random.setSeed(this.tickCount * 312871);
            stack.m_85836_();
            entity.getCapability(FrostRealm.COLD_CAP).ifPresent(cap -> {
                RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_ICONS_LOCATION);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                int l = cap.getTemperatureLevel();
                int j1 = screenWidth / 2 + 91;
                int k1 = screenHeight;
                for (int k6 = 0; k6 < 10; ++k6) {
                    int i7 = k1;
                    int k7 = 16;
                    int i8 = 0;
                    if (cap.getSaturationLevel() <= 0.0f && this.tickCount % (l * 3 + 1) == 0) {
                        i7 = k1 + (this.random.nextInt(3) - 1);
                    }
                    int k8 = j1 - k6 * 8 - 9;
                    mc.f_91065_.m_93228_(stack, k8, i7, 16 + i8 * 9, 27, 9, 9);
                    if (k6 * 2 + 1 < l) {
                        mc.f_91065_.m_93228_(stack, k8, i7, k7 + 36, 27, 9, 9);
                    }
                    if (k6 * 2 + 1 != l) continue;
                    mc.f_91065_.m_93228_(stack, k8, i7, k7 + 45, 27, 9, 9);
                }
            });
            ((ForgeIngameGui)mc.f_91065_).right_height += 10;
            stack.m_85849_();
            ++this.tickCount;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            entity = mc.m_91288_();
            ClientColdHUDEvent.renderPortalOverlay(event, mc, mc.m_91268_(), entity);
        }
    }
}

