/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.render.sky;

import baguchan.frostrealm.event.WeatherHandler;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SimpleRandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ISkyRenderHandler;

public class FrostSkyRenderer
implements ISkyRenderHandler {
    private static final ResourceLocation MOON_LOCATION = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_LOCATION = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation AURORA_TEXTURE = new ResourceLocation("frostrealm", "textures/environment/aurora.png");
    @Nullable
    private VertexBuffer starBuffer;
    @Nullable
    private VertexBuffer skyBuffer;
    @Nullable
    private VertexBuffer darkBuffer;
    public static final PerlinNoise perlinNoiseGenerator = new PerlinNoise((RandomSource)new SimpleRandomSource(8544L), Collections.singletonList(-4));

    public FrostSkyRenderer() {
        this.createStars();
        this.createLightSky();
        this.createDarkSky();
        this.createStars();
    }

    private void createDarkSky() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        if (this.darkBuffer != null) {
            this.darkBuffer.close();
        }
        this.darkBuffer = new VertexBuffer();
        FrostSkyRenderer.buildSkyDisc(bufferbuilder, -16.0f);
        this.darkBuffer.m_85925_(bufferbuilder);
    }

    private void createLightSky() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        if (this.skyBuffer != null) {
            this.skyBuffer.close();
        }
        this.skyBuffer = new VertexBuffer();
        FrostSkyRenderer.buildSkyDisc(bufferbuilder, 16.0f);
        this.skyBuffer.m_85925_(bufferbuilder);
    }

    private static void buildSkyDisc(BufferBuilder p_172948_, float p_172949_) {
        float f = Math.signum(p_172949_) * 512.0f;
        float f1 = 512.0f;
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        p_172948_.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
        p_172948_.m_5483_(0.0, (double)p_172949_, 0.0).m_5752_();
        for (int i = -180; i <= 180; i += 45) {
            p_172948_.m_5483_((double)(f * Mth.m_14089_((float)((float)i * ((float)Math.PI / 180)))), (double)p_172949_, (double)(512.0f * Mth.m_14031_((float)((float)i * ((float)Math.PI / 180))))).m_5752_();
        }
        p_172948_.m_85721_();
    }

    private void createStars() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer();
        this.drawStars(bufferbuilder);
        bufferbuilder.m_85721_();
        this.starBuffer.m_85925_(bufferbuilder);
    }

    private void drawStars(BufferBuilder p_109555_) {
        Random random = new Random(10842L);
        p_109555_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = 0.0;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                p_109555_.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_5752_();
            }
        }
    }

    public float getBrightness(ClientLevel world, float p_228330_1_) {
        float f = world.m_46942_(p_228330_1_);
        float f1 = 1.0f - (Mth.m_14089_((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        f1 = Mth.m_14036_((float)f1, (float)0.0f, (float)1.0f);
        return f1;
    }

    public void render(int ticks, float partialTicks, PoseStack matrixStack, ClientLevel level, Minecraft mc) {
        boolean flag1;
        RenderSystem.m_69472_();
        Vec3 vec3 = level.m_171660_(mc.f_91063_.m_109153_().m_90583_(), partialTicks);
        float f = (float)vec3.f_82479_;
        float f1 = (float)vec3.f_82480_;
        float f2 = (float)vec3.f_82481_;
        FogRenderer.m_109036_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_157429_((float)f, (float)f1, (float)f2, (float)1.0f);
        ShaderInstance shaderinstance = RenderSystem.m_157196_();
        this.skyBuffer.m_166867_(matrixStack.m_85850_().m_85861_(), matrixStack.m_85850_().m_85861_(), shaderinstance);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        float[] afloat = level.m_104583_().m_7518_(level.m_46942_(partialTicks), partialTicks);
        if (afloat != null) {
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_69472_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.m_85836_();
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            float f3 = Mth.m_14031_((float)level.m_46490_(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(f3));
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            float f4 = afloat[0];
            float f5 = afloat[1];
            float f6 = afloat[2];
            Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            bufferbuilder.m_85982_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(f4, f5, f6, afloat[3]).m_5752_();
            int i = 16;
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = Mth.m_14031_((float)f7);
                float f9 = Mth.m_14089_((float)f7);
                bufferbuilder.m_85982_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).m_85950_(afloat[0], afloat[1], afloat[2], 0.0f).m_5752_();
            }
            bufferbuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
            matrixStack.m_85849_();
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        matrixStack.m_85836_();
        float f11 = 1.0f - level.m_46722_(partialTicks);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(level.m_46942_(partialTicks) * 360.0f));
        Matrix4f matrix4f1 = matrixStack.m_85850_().m_85861_();
        float f12 = 30.0f;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SUN_LOCATION);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix4f1, -f12, 100.0f, -f12).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder.m_85982_(matrix4f1, f12, 100.0f, -f12).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_85982_(matrix4f1, f12, 100.0f, f12).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_85982_(matrix4f1, -f12, 100.0f, f12).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        f12 = 20.0f;
        RenderSystem.m_157456_((int)0, (ResourceLocation)MOON_LOCATION);
        int k = level.m_46941_();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f13 = (float)(l + 0) / 4.0f;
        float f14 = (float)(i1 + 0) / 2.0f;
        float f15 = (float)(l + 1) / 4.0f;
        float f16 = (float)(i1 + 1) / 2.0f;
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix4f1, -f12, -100.0f, f12).m_7421_(f15, f16).m_5752_();
        bufferbuilder.m_85982_(matrix4f1, f12, -100.0f, f12).m_7421_(f13, f16).m_5752_();
        bufferbuilder.m_85982_(matrix4f1, f12, -100.0f, -f12).m_7421_(f13, f14).m_5752_();
        bufferbuilder.m_85982_(matrix4f1, -f12, -100.0f, -f12).m_7421_(f15, f14).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        RenderSystem.m_69472_();
        double d0 = mc.f_91063_.m_109153_().m_90583_().m_7096_();
        double d1 = mc.f_91063_.m_109153_().m_90583_().m_7098_();
        double d2 = mc.f_91063_.m_109153_().m_90583_().m_7094_();
        float f9 = mc.f_91063_.m_109152_();
        float f10 = level.m_104811_(partialTicks) * f11;
        boolean bl = flag1 = mc.f_91073_.m_104583_().m_5781_(Mth.m_14107_((double)d0), Mth.m_14107_((double)d1)) || mc.f_91065_.m_93090_().m_93715_();
        if (f10 > 0.0f) {
            RenderSystem.m_157429_((float)f10, (float)f10, (float)f10, (float)f10);
            FogRenderer.m_109017_();
            this.starBuffer.m_166867_(matrixStack.m_85850_().m_85861_(), matrixStack.m_85850_().m_85861_(), GameRenderer.m_172808_());
            FogRenderer.setupFog((Camera)mc.f_91063_.m_109153_(), (FogRenderer.FogMode)FogRenderer.FogMode.FOG_SKY, (float)f, (boolean)flag1, (float)partialTicks);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        matrixStack.m_85849_();
        RenderSystem.m_69472_();
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double d4 = mc.f_91074_.m_20299_((float)partialTicks).f_82480_ - level.m_6106_().m_171687_((LevelHeightAccessor)level);
        if (d4 < 0.0) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 12.0, 0.0);
            this.darkBuffer.m_166867_(matrixStack.m_85850_().m_85861_(), matrixStack.m_85850_().m_85861_(), shaderinstance);
            matrixStack.m_85849_();
        }
        if (level.m_104583_().m_108882_()) {
            RenderSystem.m_157429_((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f), (float)1.0f);
        } else {
            RenderSystem.m_157429_((float)f, (float)f1, (float)f2, (float)1.0f);
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69458_((boolean)true);
        matrixStack.m_85836_();
        Matrix4f matrix4f2 = matrixStack.m_85850_().m_85861_();
        float weatherStrength = WeatherHandler.INSTANCE.getWeatherStrength(partialTicks);
        float auroraLevel = this.getBrightness(level, partialTicks) * (1.0f - weatherStrength) * (1.0f - level.m_46722_(partialTicks));
        if (!(auroraLevel <= 0.0f)) {
            RenderSystem.m_69478_();
            RenderSystem.m_69465_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69453_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)auroraLevel);
            RenderSystem.m_157456_((int)0, (ResourceLocation)AURORA_TEXTURE);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            float d = (float)(perlinNoiseGenerator.m_75408_((double)((float)ticks / 10000.0f), 0.0, 0.0) * 400.0);
            float e = (float)(perlinNoiseGenerator.m_75408_((double)((float)ticks / 10000.0f), 500.0, 0.0) * 400.0);
            float h = (float)(perlinNoiseGenerator.m_75408_((double)((float)ticks / 10000.0f), 1000.0, 0.0) * 400.0);
            float g = (float)(perlinNoiseGenerator.m_75408_((double)((float)ticks / 10000.0f), 1500.0, 0.0) * 400.0);
            bufferbuilder.m_85982_(matrix4f2, -1000.0f + d, 100.0f, -1000.0f + d - f).m_7421_(0.0f, 0.0f).m_5752_();
            bufferbuilder.m_85982_(matrix4f2, 1000.0f + e, 100.0f, -1000.0f + e - g).m_7421_(1.0f, 0.0f).m_5752_();
            bufferbuilder.m_85982_(matrix4f2, 1000.0f + f, 100.0f, 1000.0f + f - d).m_7421_(1.0f, 1.0f).m_5752_();
            bufferbuilder.m_85982_(matrix4f2, -1000.0f + g, 100.0f, 1000.0f + g - e).m_7421_(0.0f, 1.0f).m_5752_();
            bufferbuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69453_();
            RenderSystem.m_69461_();
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69482_();
        }
        matrixStack.m_85849_();
    }
}

