/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.render.sky;

import baguchan.frostrealm.event.WeatherHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IWeatherRenderHandler;

@OnlyIn(value=Dist.CLIENT)
public class FrostWeatherRenderer
implements IWeatherRenderHandler {
    private static final ResourceLocation RAIN_LOCATION = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation SNOW_LOCATION = new ResourceLocation("textures/environment/snow.png");
    private final float[] rainSizeX = new float[1024];
    private final float[] rainSizeZ = new float[1024];

    public FrostWeatherRenderer() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = Mth.m_14116_((float)(f * f + f1 * f1));
                this.rainSizeX[i << 5 | j] = -f1 / f2;
                this.rainSizeZ[i << 5 | j] = f / f2;
            }
        }
    }

    public void render(int ticks, float partialTicks, ClientLevel world, Minecraft mc, LightTexture lightmap, double xIn, double yIn, double zIn) {
        this.renderNormalWeather(ticks, partialTicks, mc, lightmap, xIn, yIn, zIn);
        this.renderBlizzard(ticks, partialTicks, mc, lightmap, xIn, yIn, zIn);
    }

    private void renderBlizzard(int ticks, float partialTicks, Minecraft mc, LightTexture lightmap, double xIn, double yIn, double zIn) {
        float f;
        if (WeatherHandler.INSTANCE.isBlizzard() && !((f = WeatherHandler.INSTANCE.getWeatherStrength(partialTicks)) <= 0.0f)) {
            lightmap.m_109896_();
            ClientLevel level = mc.f_91073_;
            int i = Mth.m_14107_((double)xIn);
            int j = Mth.m_14107_((double)yIn);
            int k = Mth.m_14107_((double)zIn);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderSystem.m_69464_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            int l = 5;
            if (Minecraft.m_91405_()) {
                l = 10;
            }
            RenderSystem.m_69458_((boolean)Minecraft.m_91085_());
            int i1 = -1;
            float f1 = (float)ticks + partialTicks;
            RenderSystem.m_157427_(GameRenderer::m_172829_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int j1 = k - l; j1 <= k + l; ++j1) {
                for (int k1 = i - l; k1 <= i + l; ++k1) {
                    int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                    double d0 = (double)this.rainSizeX[l1] * 0.5;
                    double d1 = (double)this.rainSizeZ[l1] * 0.5;
                    blockpos$mutableblockpos.m_122178_(k1, 0, j1);
                    Biome biome = level.m_46857_((BlockPos)blockpos$mutableblockpos);
                    int i2 = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, (BlockPos)blockpos$mutableblockpos).m_123342_();
                    int j2 = j - l;
                    int k2 = j + l;
                    if (j2 < i2) {
                        j2 = i2;
                    }
                    if (k2 < i2) {
                        k2 = i2;
                    }
                    int l2 = i2;
                    if (i2 < j) {
                        l2 = j;
                    }
                    if (j2 == k2) continue;
                    Random random = new Random(k1 * k1 * 3121 + k1 * 45238971 ^ j1 * j1 * 418711 + j1 * 13761);
                    blockpos$mutableblockpos.m_122178_(k1, j2, j1);
                    if (i1 != 1) {
                        if (i1 >= 0) {
                            tesselator.m_85914_();
                        }
                        i1 = 1;
                        RenderSystem.m_157456_((int)0, (ResourceLocation)SNOW_LOCATION);
                        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                    }
                    float f6 = -((float)(ticks & 0x1FF) + partialTicks) / 16.0f;
                    float f7 = (float)(random.nextDouble() + (double)f1 * 0.01 * (double)((float)random.nextGaussian()));
                    float f8 = (float)(random.nextDouble() + (double)(f1 * (float)random.nextGaussian()) * 0.001);
                    double d3 = (double)k1 + 0.5 - xIn;
                    double d5 = (double)j1 + 0.5 - zIn;
                    float f9 = (float)Math.sqrt(d3 * d3 + d5 * d5) / (float)l;
                    float f10 = ((1.0f - f9 * f9) * 0.3f + 0.5f) * f;
                    blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                    int k3 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                    int l3 = k3 >> 16 & 0xFFFF;
                    int i4 = k3 & 0xFFFF;
                    int j4 = (l3 * 3 + 240) / 4;
                    int k4 = (i4 * 3 + 240) / 4;
                    bufferbuilder.m_5483_((double)k1 - xIn - d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn - d1 + 0.5).m_7421_(0.0f + f7, (float)j2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - xIn + d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn + d1 + 0.5).m_7421_(1.0f + f7, (float)j2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - xIn + d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn + d1 + 0.5).m_7421_(1.0f + f7, (float)k2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - xIn - d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn - d1 + 0.5).m_7421_(0.0f + f7, (float)k2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                }
            }
            if (i1 >= 0) {
                tesselator.m_85914_();
            }
            RenderSystem.m_69481_();
            RenderSystem.m_69461_();
            lightmap.m_109891_();
        }
    }

    private void renderNormalWeather(int ticks, float partialTicks, Minecraft mc, LightTexture lightmap, double xIn, double yIn, double zIn) {
        float f = mc.f_91073_.m_46722_(partialTicks);
        if (!(f <= 0.0f)) {
            lightmap.m_109896_();
            ClientLevel level = mc.f_91073_;
            int i = Mth.m_14107_((double)xIn);
            int j = Mth.m_14107_((double)yIn);
            int k = Mth.m_14107_((double)zIn);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderSystem.m_69464_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            int l = 5;
            if (Minecraft.m_91405_()) {
                l = 10;
            }
            RenderSystem.m_69458_((boolean)Minecraft.m_91085_());
            int i1 = -1;
            float f1 = (float)ticks + partialTicks;
            RenderSystem.m_157427_(GameRenderer::m_172829_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int j1 = k - l; j1 <= k + l; ++j1) {
                for (int k1 = i - l; k1 <= i + l; ++k1) {
                    int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                    double d0 = (double)this.rainSizeX[l1] * 0.5;
                    double d1 = (double)this.rainSizeZ[l1] * 0.5;
                    blockpos$mutableblockpos.m_122178_(k1, 0, j1);
                    Biome biome = level.m_46857_((BlockPos)blockpos$mutableblockpos);
                    if (biome.m_47530_() == Biome.Precipitation.NONE) continue;
                    int i2 = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, (BlockPos)blockpos$mutableblockpos).m_123342_();
                    int j2 = j - l;
                    int k2 = j + l;
                    if (j2 < i2) {
                        j2 = i2;
                    }
                    if (k2 < i2) {
                        k2 = i2;
                    }
                    int l2 = i2;
                    if (i2 < j) {
                        l2 = j;
                    }
                    if (j2 == k2) continue;
                    Random random = new Random(k1 * k1 * 3121 + k1 * 45238971 ^ j1 * j1 * 418711 + j1 * 13761);
                    blockpos$mutableblockpos.m_122178_(k1, j2, j1);
                    float f2 = biome.m_47505_((BlockPos)blockpos$mutableblockpos);
                    if (f2 >= 0.15f) {
                        if (i1 != 0) {
                            if (i1 >= 0) {
                                tesselator.m_85914_();
                            }
                            i1 = 0;
                            RenderSystem.m_157456_((int)0, (ResourceLocation)RAIN_LOCATION);
                            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                        }
                        int i3 = ticks + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                        float f3 = -((float)i3 + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                        double d2 = (double)k1 + 0.5 - xIn;
                        double d4 = (double)j1 + 0.5 - zIn;
                        float f4 = (float)Math.sqrt(d2 * d2 + d4 * d4) / (float)l;
                        float f5 = ((1.0f - f4 * f4) * 0.5f + 0.5f) * f;
                        blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                        int j3 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                        bufferbuilder.m_5483_((double)k1 - xIn - d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn - d1 + 0.5).m_7421_(0.0f, (float)j2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - xIn + d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn + d1 + 0.5).m_7421_(1.0f, (float)j2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - xIn + d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn + d1 + 0.5).m_7421_(1.0f, (float)k2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - xIn - d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn - d1 + 0.5).m_7421_(0.0f, (float)k2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        continue;
                    }
                    if (i1 != 1) {
                        if (i1 >= 0) {
                            tesselator.m_85914_();
                        }
                        i1 = 1;
                        RenderSystem.m_157456_((int)0, (ResourceLocation)SNOW_LOCATION);
                        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                    }
                    float f6 = -((float)(ticks & 0x1FF) + partialTicks) / 512.0f;
                    float f7 = (float)(random.nextDouble() + (double)f1 * 0.01 * (double)((float)random.nextGaussian()));
                    float f8 = (float)(random.nextDouble() + (double)(f1 * (float)random.nextGaussian()) * 0.001);
                    double d3 = (double)k1 + 0.5 - xIn;
                    double d5 = (double)j1 + 0.5 - zIn;
                    float f9 = (float)Math.sqrt(d3 * d3 + d5 * d5) / (float)l;
                    float f10 = ((1.0f - f9 * f9) * 0.3f + 0.5f) * f;
                    blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                    int k3 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                    int l3 = k3 >> 16 & 0xFFFF;
                    int i4 = k3 & 0xFFFF;
                    int j4 = (l3 * 3 + 240) / 4;
                    int k4 = (i4 * 3 + 240) / 4;
                    bufferbuilder.m_5483_((double)k1 - xIn - d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn - d1 + 0.5).m_7421_(0.0f + f7, (float)j2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - xIn + d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn + d1 + 0.5).m_7421_(1.0f + f7, (float)j2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - xIn + d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn + d1 + 0.5).m_7421_(1.0f + f7, (float)k2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - xIn - d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn - d1 + 0.5).m_7421_(0.0f + f7, (float)k2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                }
            }
            if (i1 >= 0) {
                tesselator.m_85914_();
            }
            RenderSystem.m_69481_();
            RenderSystem.m_69461_();
            lightmap.m_109891_();
        }
    }
}

