/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.command;

import baguchan.frostrealm.api.Weather;
import baguchan.frostrealm.network.NetworkHandler;
import baguchan.frostrealm.network.WeatherPacket;
import baguchan.frostrealm.register.FrostDimensions;
import baguchan.frostrealm.register.FrostWeatherSystem;
import baguchan.frostrealm.world.data.FrostWeatherData;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelAccessor;

public class SetWeatherCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> getWeatherCommandNode() {
        List weatherTypes = FrostWeatherSystem.WEATHER_EVENTPOINT.stream().map(Weather::getID).map(ResourceLocation::toString).collect(Collectors.toList());
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"frostweather").then(Commands.m_82129_((String)"weathertype", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, sb) -> SharedSuggestionProvider.m_82981_(weatherTypes.stream(), (SuggestionsBuilder)sb)).executes(cs -> SetWeatherCommand.setWeatherType(((CommandSourceStack)cs.getSource()).m_81372_(), (CommandSourceStack)cs.getSource(), StringArgumentType.getString((CommandContext)cs, (String)"weathertype"))));
    }

    public static int setWeatherType(ServerLevel world, CommandSourceStack source, String weatherType) {
        Weather weatherEvent = FrostWeatherSystem.WEATHER_EVENTS.get(new ResourceLocation(weatherType));
        Weather previousWeatherEvent = FrostWeatherData.currentWeather;
        if (weatherEvent != null) {
            if (world.m_46472_() == FrostDimensions.frostrealm) {
                FrostWeatherData.get((LevelAccessor)world).setEvent(weatherEvent.getID().toString());
                FrostWeatherData.get((LevelAccessor)world).setRainTime(6000);
                source.m_81372_().m_8795_(LivingEntity::m_6084_).forEach(player -> NetworkHandler.sendToClient(player, new WeatherPacket(FrostWeatherData.get((LevelAccessor)world).getEventString())));
                source.m_81354_((Component)new TranslatableComponent("commands.frostrealm.weather.success", new Object[]{weatherType}), true);
            } else {
                source.m_81352_((Component)new TranslatableComponent("commands.frostrealm.weather.fail.not_frostrealm"));
            }
        } else {
            source.m_81352_((Component)new TranslatableComponent("commands.frostrealm.weather.fail", new Object[]{weatherType}));
        }
        return 1;
    }
}

