/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.data;

import baguchan.frostrealm.block.SugarBeetBlock;
import baguchan.frostrealm.data.provider.FRBlockLootTableProvider;
import baguchan.frostrealm.register.FrostBlocks;
import baguchan.frostrealm.register.FrostItems;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class FRLootTables
extends LootTableProvider {
    private static final LootItemCondition.Builder HAS_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    private static final LootItemCondition.Builder HAS_NO_SILK_TOUCH = HAS_SILK_TOUCH.m_81807_();
    private static final LootItemCondition.Builder HAS_SHEARS = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42574_}));
    private static final LootItemCondition.Builder HAS_SHEARS_OR_SILK_TOUCH = HAS_SHEARS.m_7818_(HAS_SILK_TOUCH);
    private static final LootItemCondition.Builder HAS_NO_SHEARS_OR_SILK_TOUCH = HAS_SHEARS_OR_SILK_TOUCH.m_81807_();
    private static final Set<Item> EXPLOSION_RESISTANT = (Set)Stream.of(net.minecraft.world.level.block.Blocks.f_50260_, net.minecraft.world.level.block.Blocks.f_50273_, net.minecraft.world.level.block.Blocks.f_50569_, net.minecraft.world.level.block.Blocks.f_50310_, net.minecraft.world.level.block.Blocks.f_50312_, net.minecraft.world.level.block.Blocks.f_50316_, net.minecraft.world.level.block.Blocks.f_50314_, net.minecraft.world.level.block.Blocks.f_50318_, net.minecraft.world.level.block.Blocks.f_50320_, net.minecraft.world.level.block.Blocks.f_50456_, net.minecraft.world.level.block.Blocks.f_50525_, net.minecraft.world.level.block.Blocks.f_50521_, net.minecraft.world.level.block.Blocks.f_50522_, net.minecraft.world.level.block.Blocks.f_50466_, net.minecraft.world.level.block.Blocks.f_50464_, net.minecraft.world.level.block.Blocks.f_50523_, net.minecraft.world.level.block.Blocks.f_50460_, net.minecraft.world.level.block.Blocks.f_50465_, net.minecraft.world.level.block.Blocks.f_50462_, net.minecraft.world.level.block.Blocks.f_50459_, net.minecraft.world.level.block.Blocks.f_50458_, net.minecraft.world.level.block.Blocks.f_50463_, net.minecraft.world.level.block.Blocks.f_50520_, net.minecraft.world.level.block.Blocks.f_50524_, net.minecraft.world.level.block.Blocks.f_50457_, net.minecraft.world.level.block.Blocks.f_50461_).map(ItemLike::m_5456_).collect(ImmutableSet.toImmutableSet());
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public FRLootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    public String m_6055_() {
        return "FrostRealm LootTables";
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(Blocks::new, (Object)LootContextParamSets.f_81421_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
    }

    private static LootTable.Builder dropSeedsForStem(Block stem, Item stemSeed) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)FRLootTables.applyExplosionDecay((ItemLike)stem, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)stemSeed).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.53333336f))))));
    }

    protected static <T> T applyExplosionDecay(ItemLike p_124132_, FunctionUserBuilder<T> p_124133_) {
        return (T)(!EXPLOSION_RESISTANT.contains(p_124132_.m_5456_()) ? p_124133_.m_5577_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()) : p_124133_.m_5476_());
    }

    public static class Blocks
    extends FRBlockLootTableProvider {
        protected void addTables() {
            this.dropWithSilk((Supplier<? extends Block>)FrostBlocks.FROZEN_GRASS_BLOCK, (Supplier<? extends ItemLike>)FrostBlocks.FROZEN_DIRT);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FROZEN_DIRT);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FRIGID_STONE);
            this.slab((Supplier<? extends SlabBlock>)FrostBlocks.FRIGID_STONE_SLAB);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FRIGID_STONE_STAIRS);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FRIGID_STONE_BRICK);
            this.slab((Supplier<? extends SlabBlock>)FrostBlocks.FRIGID_STONE_BRICK_SLAB);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FRIGID_STONE_BRICK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FRIGID_STONE_SMOOTH_BRICK);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FROSTROOT_LOG);
            this.m_124175_((Block)FrostBlocks.FROSTROOT_LEAVES.get(), leaves -> Blocks.m_124157_((Block)leaves, (Block)((Block)FrostBlocks.FROSTROOT_SAPLING.get()), (float[])DEFAULT_SAPLING_DROP_RATES).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(HAS_NO_SHEARS_OR_SILK_TOUCH).m_79076_(((LootPoolSingletonContainer.Builder)Blocks.m_124134_((ItemLike)((ItemLike)FrostBlocks.FROSTROOT_LEAVES.get()), (ConditionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)FrostItems.FROZEN_FRUIT.get())))).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f})))));
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FROSTROOT_SAPLING);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FROSTROOT_PLANKS);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FROSTROOT_PLANKS_SLAB);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FROSTROOT_PLANKS_STAIRS);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FROSTROOT_FENCE);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FROSTROOT_FENCE_GATE);
            this.m_124175_((Block)FrostBlocks.FROST_CRYSTAL_ORE.get(), p_218548_0_ -> Blocks.m_124168_((Block)p_218548_0_, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)Blocks.m_124131_((ItemLike)p_218548_0_, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)FrostItems.FROST_CRYSTAL.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))))));
            this.m_124175_((Block)FrostBlocks.GLIMMERROCK_ORE.get(), p_218548_0_ -> Blocks.m_124168_((Block)p_218548_0_, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)Blocks.m_124131_((ItemLike)p_218548_0_, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)FrostItems.GLIMMERROCK.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))))));
            this.dropWithFortune((Supplier<? extends Block>)FrostBlocks.STARDUST_CRYSTAL_ORE, (Supplier<? extends Item>)FrostItems.STARDUST_CRYSTAL);
            this.m_124175_((Block)FrostBlocks.STARDUST_CRYSTAL_CLUSTER.get(), p_218548_0_ -> Blocks.m_124168_((Block)p_218548_0_, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)Blocks.m_124131_((ItemLike)p_218548_0_, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)FrostItems.STARDUST_CRYSTAL.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))))));
            this.m_124165_((Block)FrostBlocks.FROST_GRASS.get(), Blocks.m_124125_());
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FROSTBULB_MUSHROOM);
            LootItemBlockStatePropertyCondition.Builder ilootcondition$ibuilder = LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)FrostBlocks.SUGARBEETS.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SugarBeetBlock.AGE, 3));
            this.m_124165_((Block)FrostBlocks.SUGARBEETS.get(), Blocks.m_124142_((Block)((Block)FrostBlocks.SUGARBEETS.get()), (Item)((Item)FrostItems.SUGARBEET.get()), (Item)((Item)FrostItems.SUGARBEET_SEEDS.get()), (LootItemCondition.Builder)ilootcondition$ibuilder));
            this.dropOther((Supplier<? extends Block>)FrostBlocks.FROZEN_FARMLAND, (ItemLike)FrostBlocks.FROZEN_DIRT.get());
            this.dropOther((Supplier<? extends Block>)FrostBlocks.FROST_TORCH, (ItemLike)FrostItems.FROST_TORCH.get());
            this.dropOther((Supplier<? extends Block>)FrostBlocks.WALL_FROST_TORCH, (ItemLike)FrostItems.FROST_TORCH.get());
            this.dropOther((Supplier<? extends Block>)FrostBlocks.FROST_CAMPFIRE, (ItemLike)FrostItems.FROST_CRYSTAL.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return FrostBlocks.BLOCKS.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }
}

