/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.event;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.capability.ColdCapability;
import baguchan.frostrealm.capability.FrostPortalCapability;
import baguchan.frostrealm.network.ChangedColdPacket;
import baguchan.frostrealm.network.NetworkHandler;
import baguchan.frostrealm.register.FrostBlocks;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="frostrealm")
public class CommonEventHandler {
    @SubscribeEvent
    public static void onHoeEvent(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        BlockState state = event.getWorld().m_8055_(event.getHitVec().m_82425_());
        BlockState stateUp = event.getWorld().m_8055_(event.getHitVec().m_82425_().m_7494_());
        if (stack.m_41720_() instanceof HoeItem && (state.m_60734_() == FrostBlocks.FROZEN_DIRT.get() || state.m_60734_() == FrostBlocks.FROZEN_GRASS_BLOCK.get()) && stateUp.m_60795_()) {
            event.getWorld().m_7731_(event.getHitVec().m_82425_(), ((Block)FrostBlocks.FROZEN_FARMLAND.get()).m_49966_(), 2);
            event.getPlayer().m_6674_(event.getHand());
            stack.m_41622_(1, (LivingEntity)event.getPlayer(), playerEntity -> playerEntity.m_21190_(event.getHand()));
            event.getWorld().m_5594_(event.getPlayer(), event.getHitVec().m_82425_(), SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("frostrealm", "cold"), (ICapabilityProvider)new ColdCapability());
            event.addCapability(new ResourceLocation("frostrealm", "frost_portal"), (ICapabilityProvider)new FrostPortalCapability());
        }
    }

    @SubscribeEvent
    public static void onEntitySpawn(LivingSpawnEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!livingEntity.f_19853_.f_46443_) {
            livingEntity.getCapability(FrostRealm.COLD_CAP).ifPresent(cap -> {
                ChangedColdPacket message = new ChangedColdPacket((Entity)livingEntity, cap.getTemperatureLevel(), cap.getSaturationLevel());
                NetworkHandler.SIMPLE_CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> livingEntity), (Object)message);
            });
        }
    }

    @SubscribeEvent
    public static void onUpdateCapability(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!livingEntity.f_19853_.f_46443_) {
            livingEntity.getCapability(FrostRealm.COLD_CAP).ifPresent(cap -> cap.tick(livingEntity));
        }
        livingEntity.getCapability(FrostRealm.FROST_PORTAL_CAP).ifPresent(cap -> cap.portalTick(livingEntity));
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            player.getCapability(FrostRealm.COLD_CAP).ifPresent(cap -> NetworkHandler.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ChangedColdPacket((Entity)player, cap.getTemperatureLevel(), cap.getSaturationLevel())));
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player playerEntity = event.getPlayer();
        playerEntity.getCapability(FrostRealm.COLD_CAP).ifPresent(cap -> NetworkHandler.SIMPLE_CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> playerEntity), (Object)new ChangedColdPacket((Entity)playerEntity, cap.getTemperatureLevel(), cap.getSaturationLevel())));
    }
}

