/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.event;

import baguchan.frostrealm.api.Weather;
import baguchan.frostrealm.register.FrostDimensions;
import baguchan.frostrealm.register.FrostWeatherSystem;
import baguchan.frostrealm.utils.WeatherUtil;
import baguchan.frostrealm.world.data.FrostWeatherData;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WeatherHandler {
    public static final WeatherHandler INSTANCE = new WeatherHandler();
    public float oWeatherStrength;
    public float weatherStrength;
    private long lastUpdateTime;
    public Weather playingWeather;
    private boolean isWeak;

    public float getWeatherStrength(float p_72867_1_) {
        return Mth.m_14179_((float)p_72867_1_, (float)this.oWeatherStrength, (float)this.weatherStrength);
    }

    public boolean isBlizzard() {
        return this.playingWeather.getID() == FrostWeatherSystem.BLIZZARD;
    }

    public boolean isNoWeather() {
        return this.playingWeather.getID() == FrostWeatherSystem.CLEAR;
    }

    public boolean isFog() {
        return this.playingWeather.getID() == FrostWeatherSystem.FOG;
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            FrostWeatherData data = FrostWeatherData.get((LevelAccessor)event.world);
            this.oWeatherStrength = this.weatherStrength;
            if (this.playingWeather != null) {
                if (data.getEvent().getID() == FrostWeatherSystem.BLIZZARD) {
                    this.isWeak = false;
                    this.weatherStrength = (float)((double)this.weatherStrength + 0.01);
                } else {
                    this.isWeak = true;
                    this.weatherStrength = (float)((double)this.weatherStrength - 0.01);
                }
            }
            this.weatherStrength = Mth.m_14036_((float)this.weatherStrength, (float)0.0f, (float)1.0f);
            if (this.playingWeather == null) {
                this.playingWeather = data.getEvent();
            } else if (this.playingWeather.getID() != data.getEvent().getID() && !this.isWeak) {
                this.playingWeather = data.getEvent();
            } else if (this.playingWeather.getID() != data.getEvent().getID() && this.isWeak && this.weatherStrength <= 0.0f) {
                this.playingWeather = data.getEvent();
            }
            if (event.side.isServer()) {
                Level world = event.world;
                ServerLevel serverWorld = (ServerLevel)event.world;
                if (serverWorld.m_6018_().m_46472_() == FrostDimensions.frostrealm) {
                    int tickSpeed = world.m_46469_().m_46215_(GameRules.f_46143_);
                    long worldTime = world.m_6106_().m_6793_();
                    WeatherUtil.doWeatherAndRollWeatherEventChance(FrostWeatherData.get((LevelAccessor)serverWorld), serverWorld);
                    if (worldTime % 10L == 0L) {
                        FrostWeatherSystem.updateWeatherEventPacket(serverWorld, serverWorld.m_8795_(LivingEntity::m_6084_), false);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void renderTickEvent(TickEvent.RenderTickEvent event) {
    }

    @SubscribeEvent
    public void worldLoadEvent(WorldEvent.Load event) {
    }

    @SubscribeEvent
    public void playerTickEvent(TickEvent.PlayerTickEvent event) {
    }

    @SubscribeEvent
    public void entityTickEvent(LivingEvent.LivingUpdateEvent event) {
        FrostWeatherData.currentWeather.livingEntityUpdate(event.getEntity());
    }

    @SubscribeEvent
    public void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        FrostWeatherSystem.updateWeatherEventPacket(((ServerPlayer)event.getPlayer()).m_9236_(), Collections.singletonList((ServerPlayer)event.getPlayer()), true);
    }

    @SubscribeEvent
    public void clientTickEvent(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (event.phase == TickEvent.Phase.START && minecraft.f_91073_ != null && minecraft.f_91074_ != null && minecraft.f_91073_.m_46472_() == FrostDimensions.frostrealm) {
            int n = minecraft.f_91073_.m_46469_().m_46215_(GameRules.f_46143_);
        }
    }
}

