/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.network;

import baguchan.frostrealm.FrostRealm;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class ChangedColdPacket {
    private int entityId;
    private final int temperature;
    private final float temperatureSaturation;

    public ChangedColdPacket(Entity entity, int temperature, float temperatureSaturation) {
        this.entityId = entity.m_142049_();
        this.temperature = temperature;
        this.temperatureSaturation = temperatureSaturation;
    }

    public ChangedColdPacket(int entityID, int temperature, float temperatureSaturation) {
        this.entityId = entityID;
        this.temperature = temperature;
        this.temperatureSaturation = temperatureSaturation;
    }

    public static void writeToPacket(ChangedColdPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.entityId);
        buf.writeInt(packet.temperature);
        buf.writeFloat(packet.temperatureSaturation);
    }

    public static ChangedColdPacket readFromPacket(FriendlyByteBuf buf) {
        return new ChangedColdPacket(buf.readInt(), buf.readInt(), buf.readFloat());
    }

    public static void handle(ChangedColdPacket message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Entity entity = Minecraft.m_91087_().f_91074_.f_19853_.m_6815_(message.entityId);
                if (entity != null && entity instanceof LivingEntity) {
                    entity.getCapability(FrostRealm.COLD_CAP, null).ifPresent(cap -> {
                        cap.setTemperatureLevel(message.temperature);
                        cap.setSaturation(message.temperatureSaturation);
                    });
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

