/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.network;

import baguchan.frostrealm.network.ChangedColdPacket;
import baguchan.frostrealm.network.WeatherPacket;
import baguchan.frostrealm.network.WeatherStrengthPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.Level;
import net.minecraftforge.fmllegacy.network.NetworkDirection;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.fmllegacy.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel SIMPLE_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("frostrealm", "network"), () -> "1", "1"::equals, "1"::equals);

    public static void init() {
        SIMPLE_CHANNEL.registerMessage(0, WeatherPacket.class, WeatherPacket::writeToPacket, WeatherPacket::readFromPacket, WeatherPacket::handle);
        SIMPLE_CHANNEL.registerMessage(1, WeatherStrengthPacket.class, WeatherStrengthPacket::writeToPacket, WeatherStrengthPacket::readFromPacket, WeatherStrengthPacket::handle);
        SIMPLE_CHANNEL.registerMessage(2, ChangedColdPacket.class, ChangedColdPacket::writeToPacket, ChangedColdPacket::readFromPacket, ChangedColdPacket::handle);
    }

    public static void sendToClient(ServerPlayer playerEntity, Object objectToSend) {
        SIMPLE_CHANNEL.sendTo(objectToSend, playerEntity.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToDimension(Object packet, ServerLevel serverWorld, ResourceKey<Level> dimension) {
        PlayerList playerList = serverWorld.m_142572_().m_6846_();
        for (int i = 0; i < playerList.m_11309_(); ++i) {
            ServerPlayer serverPlayer = (ServerPlayer)playerList.m_11314_().get(i);
            if (serverPlayer.f_19853_.m_46472_() != dimension) continue;
            NetworkHandler.sendToClient(serverPlayer, packet);
        }
    }

    public static void sendToServer(Object objectToSend) {
        SIMPLE_CHANNEL.sendToServer(objectToSend);
    }
}

