/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.register;

import baguchan.frostrealm.register.FrostBlocks;
import baguchan.frostrealm.register.FrostTags;
import baguchan.frostrealm.world.feature.BlockStateHeightFeatureConfig;
import baguchan.frostrealm.world.feature.ClusterFeature;
import baguchan.frostrealm.world.feature.FRTreeFeature;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.CountConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.DecoratorConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.DeltaFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HeightmapConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneDecoratorConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RangeDecoratorConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SpringConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BushFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.heightproviders.VeryBiasedToBottomHeight;
import net.minecraft.world.level.levelgen.placement.ConfiguredDecorator;
import net.minecraft.world.level.levelgen.placement.FeatureDecorator;
import net.minecraft.world.level.levelgen.placement.FrequencyWithExtraChanceDecoratorConfiguration;
import net.minecraft.world.level.levelgen.placement.WaterDepthThresholdConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class FrostFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"frostrealm");
    public static final RegistryObject<Feature<TreeConfiguration>> FROSTREALM_TREE = FEATURES.register("frostrealm_tree", () -> new FRTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_));
    public static final RegistryObject<Feature<BlockStateHeightFeatureConfig>> CLUSTER = FEATURES.register("cluster", () -> new ClusterFeature(BlockStateHeightFeatureConfig.CODEC));

    public static void registerConfiguredFeatures() {
        FrostFeatures.register("spring", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.SPRING.m_158248_(new RangeDecoratorConfiguration((HeightProvider)VeryBiasedToBottomHeight.m_162058_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158935_((int)8), (int)8)))).m_64152_()).m_64158_(20));
        FrostFeatures.register("hot_spring_pond", ConfiguredFeatures.HOT_SPRING_PONDS.m_7679_(FeatureDecorator.f_70679_.m_70720_((DecoratorConfiguration)new CountConfiguration(40))));
        FrostFeatures.register("frost_crystal_ore", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.FROST_CRYSTAL_ORE.m_158245_(VerticalAnchor.m_158921_(), VerticalAnchor.m_158922_((int)220))).m_64152_()).m_64158_(20));
        FrostFeatures.register("frost_crystal_extra", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.FROST_CRYSTAL_ORE.m_158250_(VerticalAnchor.m_158922_((int)0), VerticalAnchor.m_158922_((int)140))).m_64152_()).m_64158_(10));
        FrostFeatures.register("glimmerrock_ore", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.GLIMMERROCK_ORE.m_158250_(VerticalAnchor.m_158922_((int)-80), VerticalAnchor.m_158922_((int)32))).m_64152_()).m_64158_(15));
        FrostFeatures.register("stardust_crystal_ore", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.STARDUST_CRYSTAL_ORE.m_158245_(VerticalAnchor.m_158922_((int)0), VerticalAnchor.m_158922_((int)140))).m_64152_()).m_64158_(6));
        FrostFeatures.register("stardust_crystal_cluster", (ConfiguredFeature)((ConfiguredFeature)ConfiguredFeatures.STARDUST_CRYSTAL_CLUSTER.m_64152_()).m_158241_(4));
        FrostFeatures.register("frostroot_plain_vegitation", ConfiguredFeatures.FROSTROOT_PLAIN_VEGETATION);
        FrostFeatures.register("frostroot_forest_vegitation", ConfiguredFeatures.FROSTROOT_FOREST_VEGETATION);
    }

    private static <FC extends FeatureConfiguration> void register(String name, ConfiguredFeature<FC, ?> feature) {
        Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)new ResourceLocation("frostrealm", name), feature);
    }

    public static final class ConfiguredFeatures {
        static final RuleTest FRIGID_STONE_FILLER = new TagMatchTest(FrostTags.Blocks.BASE_STONE_FROSTREALM);
        public static final ConfiguredFeature<?, ?> SPRING = Feature.f_65765_.m_65815_((FeatureConfiguration)new SpringConfiguration(Fluids.f_76193_.m_76145_(), false, 4, 1, (Set)ImmutableSet.of((Object)((Block)FrostBlocks.FRIGID_STONE.get()), (Object)((Block)FrostBlocks.FROZEN_GRASS_BLOCK.get()), (Object)((Block)FrostBlocks.FROZEN_DIRT.get()))));
        public static final ConfiguredFeature<?, ?> HOT_SPRING_PONDS = Feature.f_65748_.m_65815_((FeatureConfiguration)new DeltaFeatureConfiguration(Blocks.f_49991_.m_49966_(), ((Block)FrostBlocks.FRIGID_STONE.get()).m_49966_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7), (IntProvider)UniformInt.m_146622_((int)0, (int)2))).m_7679_(FeatureDecorator.f_70679_.m_70720_((DecoratorConfiguration)new CountConfiguration(40)));
        public static final ConfiguredFeature<?, ?> FROST_CRYSTAL_ORE = Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(FRIGID_STONE_FILLER, ((Block)FrostBlocks.FROST_CRYSTAL_ORE.get()).m_49966_(), 17));
        public static final ConfiguredFeature<?, ?> GLIMMERROCK_ORE = Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(FRIGID_STONE_FILLER, ((Block)FrostBlocks.GLIMMERROCK_ORE.get()).m_49966_(), 9));
        public static final ConfiguredFeature<?, ?> STARDUST_CRYSTAL_ORE = Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(FRIGID_STONE_FILLER, ((Block)FrostBlocks.STARDUST_CRYSTAL_ORE.get()).m_49966_(), 6));
        public static final ConfiguredFeature<?, ?> STARDUST_CRYSTAL_CLUSTER = ((Feature)CLUSTER.get()).m_65815_((FeatureConfiguration)new BlockStateHeightFeatureConfig(((Block)FrostBlocks.STARDUST_CRYSTAL_CLUSTER.get()).m_49966_(), 12)).m_7679_(FeatureDecorator.f_70679_.m_70720_((DecoratorConfiguration)new CountConfiguration(1)));
        public static final ConfiguredFeature<TreeConfiguration, ?> FROSTROOT_TREE = ((Feature)FROSTREALM_TREE.get()).m_65815_((FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SimpleStateProvider(((RotatedPillarBlock)FrostBlocks.FROSTROOT_LOG.get()).m_49966_()), (TrunkPlacer)new FancyTrunkPlacer(3, 4, 0), (BlockStateProvider)new SimpleStateProvider(((LeavesBlock)FrostBlocks.FROSTROOT_LEAVES.get()).m_49966_()), (BlockStateProvider)new SimpleStateProvider(((SaplingBlock)FrostBlocks.FROSTROOT_SAPLING.get()).m_49966_()), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)3), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68244_().m_68251_());
        public static final ConfiguredFeature<TreeConfiguration, ?> SMALL_FROSTROOT_TREE = ((Feature)FROSTREALM_TREE.get()).m_65815_((FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SimpleStateProvider(((RotatedPillarBlock)FrostBlocks.FROSTROOT_LOG.get()).m_49966_()), (TrunkPlacer)new StraightTrunkPlacer(3, 2, 0), (BlockStateProvider)new SimpleStateProvider(((LeavesBlock)FrostBlocks.FROSTROOT_LEAVES.get()).m_49966_()), (BlockStateProvider)new SimpleStateProvider(((SaplingBlock)FrostBlocks.FROSTROOT_SAPLING.get()).m_49966_()), (FoliagePlacer)new BushFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)1), 2), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68244_().m_68251_());
        public static final ConfiguredFeature<TreeConfiguration, ?> FANCY_FROSTROOT_TREE = ((Feature)FROSTREALM_TREE.get()).m_65815_((FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SimpleStateProvider(((RotatedPillarBlock)FrostBlocks.FROSTROOT_LOG.get()).m_49966_()), (TrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (BlockStateProvider)new SimpleStateProvider(((LeavesBlock)FrostBlocks.FROSTROOT_LEAVES.get()).m_49966_()), (BlockStateProvider)new SimpleStateProvider(((SaplingBlock)FrostBlocks.FROSTROOT_SAPLING.get()).m_49966_()), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).m_68244_().m_68251_());
        public static final ConfiguredFeature<?, ?> FROSTROOT_PLAIN_VEGETATION = Feature.f_65754_.m_65815_((FeatureConfiguration)new RandomFeatureConfiguration((List)ImmutableList.of((Object)SMALL_FROSTROOT_TREE.m_65383_(0.33333334f)), FROSTROOT_TREE)).m_7679_(Decorators.HEIGHTMAP_SQUARE).m_7679_(FeatureDecorator.f_70686_.m_70720_((DecoratorConfiguration)new FrequencyWithExtraChanceDecoratorConfiguration(0, 0.05f, 1)));
        public static final ConfiguredFeature<?, ?> FROSTROOT_FOREST_VEGETATION = Feature.f_65754_.m_65815_((FeatureConfiguration)new RandomFeatureConfiguration((List)ImmutableList.of((Object)FANCY_FROSTROOT_TREE.m_65383_(0.33333334f)), FROSTROOT_TREE)).m_7679_(Decorators.HEIGHTMAP_SQUARE).m_7679_(FeatureDecorator.f_70686_.m_70720_((DecoratorConfiguration)new FrequencyWithExtraChanceDecoratorConfiguration(4, 0.05f, 1)));
    }

    protected static final class Decorators {
        public static final BeehiveDecorator BEEHIVE_0002 = new BeehiveDecorator(0.002f);
        public static final BeehiveDecorator BEEHIVE_002 = new BeehiveDecorator(0.02f);
        public static final BeehiveDecorator BEEHIVE_005 = new BeehiveDecorator(0.05f);
        public static final ConfiguredDecorator<HeightmapConfiguration> HEIGHTMAP = FeatureDecorator.f_70688_.m_70720_((DecoratorConfiguration)new HeightmapConfiguration(Heightmap.Types.MOTION_BLOCKING));
        public static final ConfiguredDecorator<HeightmapConfiguration> HEIGHTMAP_TOP_SOLID = FeatureDecorator.f_70688_.m_70720_((DecoratorConfiguration)new HeightmapConfiguration(Heightmap.Types.OCEAN_FLOOR_WG));
        public static final ConfiguredDecorator<HeightmapConfiguration> HEIGHTMAP_WORLD_SURFACE = FeatureDecorator.f_70688_.m_70720_((DecoratorConfiguration)new HeightmapConfiguration(Heightmap.Types.WORLD_SURFACE_WG));
        public static final ConfiguredDecorator<HeightmapConfiguration> HEIGHTMAP_OCEAN_FLOOR = FeatureDecorator.f_70688_.m_70720_((DecoratorConfiguration)new HeightmapConfiguration(Heightmap.Types.OCEAN_FLOOR));
        public static final ConfiguredDecorator<HeightmapConfiguration> HEIGHTMAP_DOUBLE = FeatureDecorator.f_70689_.m_70720_((DecoratorConfiguration)new HeightmapConfiguration(Heightmap.Types.MOTION_BLOCKING));
        public static final RangeDecoratorConfiguration FULL_RANGE = new RangeDecoratorConfiguration((HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158929_()));
        public static final RangeDecoratorConfiguration RANGE_10_10 = new RangeDecoratorConfiguration((HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158930_((int)10), (VerticalAnchor)VerticalAnchor.m_158935_((int)10)));
        public static final RangeDecoratorConfiguration RANGE_8_8 = new RangeDecoratorConfiguration((HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158930_((int)8), (VerticalAnchor)VerticalAnchor.m_158935_((int)8)));
        public static final RangeDecoratorConfiguration RANGE_4_4 = new RangeDecoratorConfiguration((HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158930_((int)4), (VerticalAnchor)VerticalAnchor.m_158935_((int)4)));
        public static final RangeDecoratorConfiguration RANGE_BOTTOM_TO_60 = new RangeDecoratorConfiguration((HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)60)));
        public static final ConfiguredDecorator<?> FIRE = (ConfiguredDecorator)((ConfiguredDecorator)FeatureDecorator.f_70692_.m_70720_((DecoratorConfiguration)RANGE_4_4).m_64152_()).m_64160_(5);
        public static final ConfiguredDecorator<?> ADD_32 = FeatureDecorator.f_70696_.m_70720_((DecoratorConfiguration)NoneDecoratorConfiguration.f_67811_);
        public static final ConfiguredDecorator<?> HEIGHTMAP_WITH_TREE_THRESHOLD = HEIGHTMAP_OCEAN_FLOOR.m_7679_(FeatureDecorator.f_162179_.m_70720_((DecoratorConfiguration)new WaterDepthThresholdConfiguration(0)));
        public static final ConfiguredDecorator<?> HEIGHTMAP_WITH_TREE_THRESHOLD_SQUARED = (ConfiguredDecorator)HEIGHTMAP_WITH_TREE_THRESHOLD.m_64152_();
        public static final ConfiguredDecorator<?> HEIGHTMAP_SQUARE = (ConfiguredDecorator)HEIGHTMAP.m_64152_();
        public static final ConfiguredDecorator<?> HEIGHTMAP_DOUBLE_SQUARE = (ConfiguredDecorator)HEIGHTMAP_DOUBLE.m_64152_();
        public static final ConfiguredDecorator<?> TOP_SOLID_HEIGHTMAP_SQUARE = (ConfiguredDecorator)HEIGHTMAP_TOP_SOLID.m_64152_();
        public static final ConfiguredDecorator<?> DARK_OAK_DECORATOR = HEIGHTMAP_WITH_TREE_THRESHOLD.m_7679_(FeatureDecorator.f_70705_.m_70720_((DecoratorConfiguration)DecoratorConfiguration.f_67591_));

        protected Decorators() {
        }
    }
}

