/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.register;

import baguchan.frostrealm.api.Weather;
import baguchan.frostrealm.event.WeatherHandler;
import baguchan.frostrealm.network.NetworkHandler;
import baguchan.frostrealm.network.WeatherPacket;
import baguchan.frostrealm.weather.Blizzard;
import baguchan.frostrealm.weather.Clear;
import baguchan.frostrealm.weather.Fog;
import baguchan.frostrealm.world.data.FrostWeatherData;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.LevelAccessor;

public class FrostWeatherSystem {
    public static final ResourceLocation BLIZZARD = new ResourceLocation("frostrealm", "blizzard");
    public static final ResourceLocation FOG = new ResourceLocation("frostrealm", "fog");
    public static final ResourceLocation CLEAR = new ResourceLocation("frostrealm", "clear");
    public static HashMap<ResourceLocation, Double> WEATHER_EVENT_CONTROLLER = new HashMap();
    public static HashMap<ResourceLocation, Weather> WEATHER_EVENTS = new HashMap();
    public static final ObjectOpenHashSet<Weather> WEATHER_EVENTPOINT = new ObjectOpenHashSet();
    private static ResourceLocation cachedEvent = CLEAR;

    public static void fillWeatherEventsMapAndWeatherEventController() {
        for (Weather weatherEvent : WEATHER_EVENTPOINT) {
            WEATHER_EVENTS.put(weatherEvent.getID(), weatherEvent);
            WEATHER_EVENT_CONTROLLER.put(weatherEvent.getID(), weatherEvent.getDefaultChance());
        }
    }

    public static void addDefaultWeatherEvents() {
        WEATHER_EVENTPOINT.add((Object)new Blizzard());
        WEATHER_EVENTPOINT.add((Object)new Fog());
        WEATHER_EVENTPOINT.add((Object)new Clear());
    }

    public static void updateWeatherEventPacket(ServerLevel world, List<ServerPlayer> players, boolean justJoined) {
        FrostWeatherData weatherData = FrostWeatherData.get((LevelAccessor)world);
        ResourceLocation currentEvent = weatherData.getEventID();
        if (!cachedEvent.equals((Object)currentEvent) || justJoined) {
            players.forEach(player -> NetworkHandler.sendToClient(player, new WeatherPacket(currentEvent.toString())));
            cachedEvent = currentEvent;
        }
    }

    public static void rollWeatherEventChance(Random random, ServerLevel world, boolean isRaining, FrostWeatherData data, List<ServerPlayer> players) {
        if (WeatherHandler.INSTANCE.getWeatherStrength(1.0f) == 0.0f && data.isNoWeather() && !FrostWeatherData.get((LevelAccessor)world).isWeatherForced()) {
            AtomicBoolean weatherEventWasSet = new AtomicBoolean(false);
            WEATHER_EVENT_CONTROLLER.forEach((event, chance) -> {
                if (event != CLEAR && random.nextDouble() < chance) {
                    weatherEventWasSet.set(true);
                    FrostWeatherData.get((LevelAccessor)world).setEvent(event.toString());
                }
            });
            players.forEach(player -> NetworkHandler.sendToClient(player, new WeatherPacket(FrostWeatherData.get((LevelAccessor)world).getEventString())));
        }
    }
}

