/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.tileentity;

import baguchan.frostrealm.register.FrostTileEntities;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FrostCampfireBlockEntity
extends BlockEntity
implements Clearable {
    private static final int BURN_COOL_SPEED = 2;
    private static final int NUM_SLOTS = 4;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final int[] cookingProgress = new int[4];
    private final int[] cookingTime = new int[4];

    public FrostCampfireBlockEntity(BlockPos p_155301_, BlockState p_155302_) {
        super((BlockEntityType)FrostTileEntities.FROST_CAMPFIRE.get(), p_155301_, p_155302_);
    }

    public static void cookTick(Level p_155307_, BlockPos p_155308_, BlockState p_155309_, FrostCampfireBlockEntity p_155310_) {
        boolean var4 = false;
        for (int var5 = 0; var5 < p_155310_.items.size(); ++var5) {
            ItemStack var6 = (ItemStack)p_155310_.items.get(var5);
            if (var6.m_41619_()) continue;
            var4 = true;
            int n = var5;
            p_155310_.cookingProgress[n] = p_155310_.cookingProgress[n] + 1;
            if (p_155310_.cookingProgress[var5] < p_155310_.cookingTime[var5]) continue;
            SimpleContainer var7 = new SimpleContainer(new ItemStack[]{var6});
            ItemStack var8 = p_155307_.m_7465_().m_44015_(RecipeType.f_44111_, (Container)var7, p_155307_).map(arg_0 -> FrostCampfireBlockEntity.lambda$cookTick$0((Container)var7, arg_0)).orElse(var6);
            Containers.m_18992_((Level)p_155307_, (double)p_155308_.m_123341_(), (double)p_155308_.m_123342_(), (double)p_155308_.m_123343_(), (ItemStack)var8);
            p_155310_.items.set(var5, (Object)ItemStack.f_41583_);
            p_155307_.m_7260_(p_155308_, p_155309_, p_155309_, 3);
        }
        if (var4) {
            FrostCampfireBlockEntity.m_155232_((Level)p_155307_, (BlockPos)p_155308_, (BlockState)p_155309_);
        }
    }

    public static void cooldownTick(Level p_155314_, BlockPos p_155315_, BlockState p_155316_, FrostCampfireBlockEntity p_155317_) {
        boolean var4 = false;
        for (int var5 = 0; var5 < p_155317_.items.size(); ++var5) {
            if (p_155317_.cookingProgress[var5] <= 0) continue;
            var4 = true;
            p_155317_.cookingProgress[var5] = Mth.m_14045_((int)(p_155317_.cookingProgress[var5] - 2), (int)0, (int)p_155317_.cookingTime[var5]);
        }
        if (var4) {
            FrostCampfireBlockEntity.m_155232_((Level)p_155314_, (BlockPos)p_155315_, (BlockState)p_155316_);
        }
    }

    public static void particleTick(Level p_155319_, BlockPos p_155320_, BlockState p_155321_, FrostCampfireBlockEntity p_155322_) {
        int var5;
        Random var4 = p_155319_.f_46441_;
        if (var4.nextFloat() < 0.11f) {
            for (var5 = 0; var5 < var4.nextInt(2) + 2; ++var5) {
                CampfireBlock.m_51251_((Level)p_155319_, (BlockPos)p_155320_, (boolean)((Boolean)p_155321_.m_61143_((Property)CampfireBlock.f_51228_)), (boolean)false);
            }
        }
        var5 = ((Direction)p_155321_.m_61143_((Property)CampfireBlock.f_51230_)).m_122416_();
        for (int var6 = 0; var6 < p_155322_.items.size(); ++var6) {
            if (((ItemStack)p_155322_.items.get(var6)).m_41619_() || !(var4.nextFloat() < 0.2f)) continue;
            Direction var7 = Direction.m_122407_((int)Math.floorMod(var6 + var5, 4));
            float var8 = 0.3125f;
            double var9 = (double)p_155320_.m_123341_() + 0.5 - (double)((float)var7.m_122429_() * 0.3125f) + (double)((float)var7.m_122427_().m_122429_() * 0.3125f);
            double var11 = (double)p_155320_.m_123342_() + 0.5;
            double var13 = (double)p_155320_.m_123343_() + 0.5 - (double)((float)var7.m_122431_() * 0.3125f) + (double)((float)var7.m_122427_().m_122431_() * 0.3125f);
            for (int var15 = 0; var15 < 4; ++var15) {
                p_155319_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, var9, var11, var13, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void m_142466_(CompoundTag p_155312_) {
        int[] var2;
        super.m_142466_(p_155312_);
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)p_155312_, this.items);
        if (p_155312_.m_128425_("CookingTimes", 11)) {
            var2 = p_155312_.m_128465_("CookingTimes");
            System.arraycopy(var2, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, var2.length));
        }
        if (p_155312_.m_128425_("CookingTotalTimes", 11)) {
            var2 = p_155312_.m_128465_("CookingTotalTimes");
            System.arraycopy(var2, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, var2.length));
        }
    }

    public CompoundTag m_6945_(CompoundTag p_59060_) {
        this.saveMetadataAndItems(p_59060_);
        p_59060_.m_128385_("CookingTimes", this.cookingProgress);
        p_59060_.m_128385_("CookingTotalTimes", this.cookingTime);
        return p_59060_;
    }

    private CompoundTag saveMetadataAndItems(CompoundTag p_59064_) {
        super.m_6945_(p_59064_);
        ContainerHelper.m_18976_((CompoundTag)p_59064_, this.items, (boolean)true);
        return p_59064_;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 13, this.m_5995_());
    }

    public CompoundTag m_5995_() {
        return this.saveMetadataAndItems(new CompoundTag());
    }

    public Optional<CampfireCookingRecipe> getCookableRecipe(ItemStack p_59052_) {
        return this.items.stream().noneMatch(ItemStack::m_41619_) ? Optional.empty() : this.f_58857_.m_7465_().m_44015_(RecipeType.f_44111_, (Container)new SimpleContainer(new ItemStack[]{p_59052_}), this.f_58857_);
    }

    public boolean placeFood(ItemStack p_59054_, int p_59055_) {
        for (int var3 = 0; var3 < this.items.size(); ++var3) {
            ItemStack var4 = (ItemStack)this.items.get(var3);
            if (!var4.m_41619_()) continue;
            this.cookingTime[var3] = p_59055_;
            this.cookingProgress[var3] = 0;
            this.items.set(var3, (Object)p_59054_.m_41620_(1));
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void dowse() {
        if (this.f_58857_ != null) {
            this.markUpdated();
        }
    }

    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)FrostTileEntities.FROST_CAMPFIRE.get();
    }

    private static /* synthetic */ ItemStack lambda$cookTick$0(Container var7, CampfireCookingRecipe p_155305_) {
        return p_155305_.m_5874_(var7);
    }
}

