/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.world;

import baguchan.frostrealm.world.SeedHolder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.biome.Biomes;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class FrostBiomeProvider
extends BiomeSource {
    private static final NoiseParameters DEFAULT_NOISE_PARAMETERS = new NoiseParameters(-7, (List<Double>)ImmutableList.of((Object)1.0, (Object)1.0));
    public static final MapCodec<FrostBiomeProvider> DIRECT_CODEC = RecordCodecBuilder.mapCodec(p_48477_ -> p_48477_.group((App)Codec.LONG.fieldOf("seed").orElseGet(SeedHolder::getSeed).forGetter(p_151852_ -> p_151852_.seed), (App)RecordCodecBuilder.create(p_151838_ -> p_151838_.group((App)Biome.ClimateParameters.f_47649_.fieldOf("parameters").forGetter(Pair::getFirst), (App)Biome.f_47431_.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)p_151838_, Pair::of)).listOf().fieldOf("biomes").forGetter(p_151850_ -> p_151850_.parameters), (App)NoiseParameters.CODEC.fieldOf("temperature_noise").forGetter(p_151848_ -> p_151848_.temperatureParams), (App)NoiseParameters.CODEC.fieldOf("humidity_noise").forGetter(p_151846_ -> p_151846_.humidityParams), (App)NoiseParameters.CODEC.fieldOf("altitude_noise").forGetter(p_151844_ -> p_151844_.altitudeParams), (App)NoiseParameters.CODEC.fieldOf("weirdness_noise").forGetter(p_151842_ -> p_151842_.weirdnessParams)).apply((Applicative)p_48477_, FrostBiomeProvider::new));
    public static final Codec<FrostBiomeProvider> CODEC = Codec.mapEither(PresetInstance.CODEC, DIRECT_CODEC).xmap(p_48473_ -> (FrostBiomeProvider)((Object)((Object)p_48473_.map(PresetInstance::biomeSource, Function.identity()))), p_48471_ -> p_48471_.preset().map(Either::left).orElseGet(() -> Either.right((Object)p_48471_))).codec();
    private final NoiseParameters temperatureParams;
    private final NoiseParameters humidityParams;
    private final NoiseParameters altitudeParams;
    private final NoiseParameters weirdnessParams;
    private final NormalNoise temperatureNoise;
    private final NormalNoise humidityNoise;
    private final NormalNoise altitudeNoise;
    private final NormalNoise weirdnessNoise;
    private final List<Pair<Biome.ClimateParameters, Supplier<Biome>>> parameters;
    private final boolean useY;
    private final long seed;
    private final Optional<Pair<Registry<Biome>, Preset>> preset;

    public FrostBiomeProvider(long p_151828_, List<Pair<Biome.ClimateParameters, Supplier<Biome>>> p_151829_) {
        this(p_151828_, p_151829_, Optional.empty());
    }

    FrostBiomeProvider(long p_48456_, List<Pair<Biome.ClimateParameters, Supplier<Biome>>> p_48457_, Optional<Pair<Registry<Biome>, Preset>> p_48458_) {
        this(p_48456_, p_48457_, DEFAULT_NOISE_PARAMETERS, DEFAULT_NOISE_PARAMETERS, DEFAULT_NOISE_PARAMETERS, DEFAULT_NOISE_PARAMETERS, p_48458_);
    }

    private FrostBiomeProvider(long p_48441_, List<Pair<Biome.ClimateParameters, Supplier<Biome>>> p_48442_, NoiseParameters p_48443_, NoiseParameters p_48444_, NoiseParameters p_48445_, NoiseParameters p_48446_) {
        this(p_48441_, p_48442_, p_48443_, p_48444_, p_48445_, p_48446_, Optional.empty());
    }

    private FrostBiomeProvider(long p_48448_, List<Pair<Biome.ClimateParameters, Supplier<Biome>>> p_48449_, NoiseParameters p_48450_, NoiseParameters p_48451_, NoiseParameters p_48452_, NoiseParameters p_48453_, Optional<Pair<Registry<Biome>, Preset>> p_48454_) {
        super(p_48449_.stream().map(Pair::getSecond));
        this.seed = p_48448_;
        this.preset = p_48454_;
        this.temperatureParams = p_48450_;
        this.humidityParams = p_48451_;
        this.altitudeParams = p_48452_;
        this.weirdnessParams = p_48453_;
        this.temperatureNoise = NormalNoise.m_164350_((RandomSource)new WorldgenRandom(p_48448_), (int)p_48450_.firstOctave(), (DoubleList)p_48450_.amplitudes());
        this.humidityNoise = NormalNoise.m_164350_((RandomSource)new WorldgenRandom(p_48448_ + 1L), (int)p_48451_.firstOctave(), (DoubleList)p_48451_.amplitudes());
        this.altitudeNoise = NormalNoise.m_164350_((RandomSource)new WorldgenRandom(p_48448_ + 2L), (int)p_48452_.firstOctave(), (DoubleList)p_48452_.amplitudes());
        this.weirdnessNoise = NormalNoise.m_164350_((RandomSource)new WorldgenRandom(p_48448_ + 3L), (int)p_48453_.firstOctave(), (DoubleList)p_48453_.amplitudes());
        this.parameters = p_48449_;
        this.useY = false;
    }

    public static FrostBiomeProvider overworld(Registry<Biome> p_151833_, long p_151834_) {
        ImmutableList<Pair<Biome.ClimateParameters, Supplier<Biome>>> immutablelist = FrostBiomeProvider.parameters(p_151833_);
        NoiseParameters multinoisebiomesource$noiseparameters = new NoiseParameters(-9, 1.0, 0.0, 3.0, 3.0, 3.0, 3.0);
        NoiseParameters multinoisebiomesource$noiseparameters1 = new NoiseParameters(-7, 1.0, 2.0, 4.0, 4.0);
        NoiseParameters multinoisebiomesource$noiseparameters2 = new NoiseParameters(-9, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        NoiseParameters multinoisebiomesource$noiseparameters3 = new NoiseParameters(-8, 1.2, 0.6, 0.0, 0.0, 1.0, 0.0);
        return new FrostBiomeProvider(p_151834_, (List<Pair<Biome.ClimateParameters, Supplier<Biome>>>)immutablelist, multinoisebiomesource$noiseparameters, multinoisebiomesource$noiseparameters1, multinoisebiomesource$noiseparameters2, multinoisebiomesource$noiseparameters3, Optional.empty());
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    public BiomeSource m_7206_(long p_48466_) {
        return new FrostBiomeProvider(p_48466_, this.parameters, this.temperatureParams, this.humidityParams, this.altitudeParams, this.weirdnessParams, this.preset);
    }

    private Optional<PresetInstance> preset() {
        return this.preset.map(p_48475_ -> new PresetInstance((Preset)p_48475_.getSecond(), (Registry<Biome>)((Registry)p_48475_.getFirst()), this.seed));
    }

    public Biome m_7158_(int p_48479_, int p_48480_, int p_48481_) {
        int i = this.useY ? p_48480_ : 0;
        Biome.ClimateParameters biome$climateparameters = new Biome.ClimateParameters((float)this.temperatureNoise.m_75380_((double)p_48479_, (double)i, (double)p_48481_), (float)this.humidityNoise.m_75380_((double)p_48479_, (double)i, (double)p_48481_), (float)this.altitudeNoise.m_75380_((double)p_48479_, (double)i, (double)p_48481_), (float)this.weirdnessNoise.m_75380_((double)p_48479_, (double)i, (double)p_48481_), 0.0f);
        return this.parameters.stream().min(Comparator.comparing(p_48469_ -> Float.valueOf(((Biome.ClimateParameters)p_48469_.getFirst()).m_47662_(biome$climateparameters)))).map(Pair::getSecond).map(Supplier::get).orElse(Biomes.f_127322_);
    }

    public static ImmutableList<Pair<Biome.ClimateParameters, Supplier<Biome>>> parameters(Registry<Biome> p_151831_) {
        return ImmutableList.of((Object)Pair.of((Object)new Biome.ClimateParameters(0.0f, 0.0f, 0.0f, 0.0f, 0.0f), () -> (Biome)p_151831_.m_123013_(net.minecraft.world.level.biome.Biomes.f_48202_)));
    }

    public boolean stable(long p_48483_) {
        return this.seed == p_48483_ && this.preset.isPresent() && Objects.equals(this.preset.get().getSecond(), Preset.NETHER);
    }

    static class NoiseParameters {
        private final int firstOctave;
        private final DoubleList amplitudes;
        public static final Codec<NoiseParameters> CODEC = RecordCodecBuilder.create(p_48510_ -> p_48510_.group((App)Codec.INT.fieldOf("firstOctave").forGetter(NoiseParameters::firstOctave), (App)Codec.DOUBLE.listOf().fieldOf("amplitudes").forGetter(NoiseParameters::amplitudes)).apply((Applicative)p_48510_, NoiseParameters::new));

        public NoiseParameters(int p_48506_, List<Double> p_48507_) {
            this.firstOctave = p_48506_;
            this.amplitudes = new DoubleArrayList(p_48507_);
        }

        public NoiseParameters(int p_151854_, double ... p_151855_) {
            this.firstOctave = p_151854_;
            this.amplitudes = new DoubleArrayList(p_151855_);
        }

        public int firstOctave() {
            return this.firstOctave;
        }

        public DoubleList amplitudes() {
            return this.amplitudes;
        }
    }

    public static class Preset {
        static final Map<ResourceLocation, Preset> BY_NAME = Maps.newHashMap();
        public static final Preset NETHER = new Preset(new ResourceLocation("nether"), (Function3<Preset, Registry<Biome>, Long, FrostBiomeProvider>)((Function3)(p_48524_, p_48525_, p_48526_) -> new FrostBiomeProvider((long)p_48526_, (List<Pair<Biome.ClimateParameters, Supplier<Biome>>>)ImmutableList.of((Object)Pair.of((Object)new Biome.ClimateParameters(0.0f, 0.0f, 0.0f, 0.0f, 0.0f), () -> (Biome)p_48525_.m_123013_(net.minecraft.world.level.biome.Biomes.f_48209_)), (Object)Pair.of((Object)new Biome.ClimateParameters(0.0f, -0.5f, 0.0f, 0.0f, 0.0f), () -> (Biome)p_48525_.m_123013_(net.minecraft.world.level.biome.Biomes.f_48199_)), (Object)Pair.of((Object)new Biome.ClimateParameters(0.4f, 0.0f, 0.0f, 0.0f, 0.0f), () -> (Biome)p_48525_.m_123013_(net.minecraft.world.level.biome.Biomes.f_48200_)), (Object)Pair.of((Object)new Biome.ClimateParameters(0.0f, 0.5f, 0.0f, 0.0f, 0.375f), () -> (Biome)p_48525_.m_123013_(net.minecraft.world.level.biome.Biomes.f_48201_)), (Object)Pair.of((Object)new Biome.ClimateParameters(-0.5f, 0.0f, 0.0f, 0.0f, 0.175f), () -> (Biome)p_48525_.m_123013_(net.minecraft.world.level.biome.Biomes.f_48175_))), Optional.of(Pair.of((Object)p_48525_, (Object)p_48524_)))));
        final ResourceLocation name;
        private final Function3<Preset, Registry<Biome>, Long, FrostBiomeProvider> biomeSource;

        public Preset(ResourceLocation p_48518_, Function3<Preset, Registry<Biome>, Long, FrostBiomeProvider> p_48519_) {
            this.name = p_48518_;
            this.biomeSource = p_48519_;
            BY_NAME.put(p_48518_, this);
        }

        public FrostBiomeProvider biomeSource(Registry<Biome> p_48530_, long p_48531_) {
            return (FrostBiomeProvider)((Object)this.biomeSource.apply((Object)this, p_48530_, (Object)p_48531_));
        }
    }

    static final class PresetInstance {
        public static final MapCodec<PresetInstance> CODEC = RecordCodecBuilder.mapCodec(p_48558_ -> p_48558_.group((App)ResourceLocation.f_135803_.flatXmap(p_151869_ -> Optional.ofNullable(Preset.BY_NAME.get(p_151869_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown preset: " + p_151869_))), p_151867_ -> DataResult.success((Object)p_151867_.name)).fieldOf("preset").stable().forGetter(PresetInstance::preset), (App)RegistryLookupCodec.m_135622_((ResourceKey)Registry.f_122885_).forGetter(PresetInstance::biomes), (App)Codec.LONG.fieldOf("seed").stable().forGetter(PresetInstance::seed)).apply((Applicative)p_48558_, p_48558_.stable(PresetInstance::new)));
        private final Preset preset;
        private final Registry<Biome> biomes;
        private final long seed;

        PresetInstance(Preset p_48546_, Registry<Biome> p_48547_, long p_48548_) {
            this.preset = p_48546_;
            this.biomes = p_48547_;
            this.seed = p_48548_;
        }

        public Preset preset() {
            return this.preset;
        }

        public Registry<Biome> biomes() {
            return this.biomes;
        }

        public long seed() {
            return this.seed;
        }

        public FrostBiomeProvider biomeSource() {
            return this.preset.biomeSource(this.biomes, this.seed);
        }
    }
}

