/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.world;

import baguchan.frostrealm.world.SeedHolder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.BaseStoneSource;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.Cavifier;
import net.minecraft.world.level.levelgen.DepthBasedReplacingBaseStoneSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseInterpolator;
import net.minecraft.world.level.levelgen.NoiseModifier;
import net.minecraft.world.level.levelgen.NoiseSampler;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.NoodleCavifier;
import net.minecraft.world.level.levelgen.OreVeinifier;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SimpleRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import net.minecraft.world.level.levelgen.synth.SurfaceNoise;
import net.minecraftforge.common.world.StructureSpawnManager;

public class FrostChunkGenerator
extends ChunkGenerator {
    public static final Codec<FrostChunkGenerator> CODEC = RecordCodecBuilder.create(p_64405_ -> p_64405_.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(p_158489_ -> p_158489_.f_62137_), (App)Codec.LONG.fieldOf("seed").orElseGet(SeedHolder::getSeed).stable().forGetter(p_158487_ -> p_158487_.seed), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(p_158458_ -> p_158458_.f_62139_)).apply((Applicative)p_64405_, p_64405_.stable(FrostChunkGenerator::new)));
    private static final BlockState AIR = Blocks.f_50016_.m_49966_();
    private static final BlockState[] EMPTY_COLUMN = new BlockState[0];
    private final int cellHeight;
    private final int cellWidth;
    final int cellCountX;
    final int cellCountY;
    final int cellCountZ;
    private final SurfaceNoise surfaceNoise;
    private final NormalNoise barrierNoise;
    private final NormalNoise waterLevelNoise;
    private final NormalNoise lavaNoise;
    protected final BlockState defaultBlock;
    protected final BlockState defaultFluid;
    private final long seed;
    protected final Supplier<NoiseGeneratorSettings> f_62139_;
    private final int height;
    private final NoiseSampler sampler;
    private final BaseStoneSource baseStoneSource;
    final OreVeinifier oreVeinifier;
    final NoodleCavifier noodleCavifier;

    public FrostChunkGenerator(BiomeSource p_64337_, long p_64338_, Supplier<NoiseGeneratorSettings> p_64339_) {
        this(p_64337_, p_64337_, p_64338_, p_64339_);
    }

    private FrostChunkGenerator(BiomeSource p_64341_, BiomeSource p_64342_, long p_64343_, Supplier<NoiseGeneratorSettings> p_64344_) {
        super(p_64341_, p_64342_, p_64344_.get().m_64457_(), p_64343_);
        SimplexNoise simplexnoise;
        this.seed = p_64343_;
        NoiseGeneratorSettings noisegeneratorsettings = p_64344_.get();
        this.f_62139_ = p_64344_;
        NoiseSettings noisesettings = noisegeneratorsettings.m_64481_();
        this.height = noisesettings.m_64534_();
        this.cellHeight = QuartPos.m_175402_((int)noisesettings.m_64541_());
        this.cellWidth = QuartPos.m_175402_((int)noisesettings.m_64540_());
        this.defaultBlock = noisegeneratorsettings.m_64482_();
        this.defaultFluid = noisegeneratorsettings.m_64483_();
        this.cellCountX = 16 / this.cellWidth;
        this.cellCountY = noisesettings.m_64534_() / this.cellHeight;
        this.cellCountZ = 16 / this.cellWidth;
        WorldgenRandom worldgenrandom = new WorldgenRandom(p_64343_);
        BlendedNoise blendednoise = new BlendedNoise((RandomSource)worldgenrandom);
        this.surfaceNoise = noisesettings.m_64544_() ? new PerlinSimplexNoise((RandomSource)worldgenrandom, IntStream.rangeClosed(-3, 0)) : new PerlinNoise((RandomSource)worldgenrandom, IntStream.rangeClosed(-3, 0));
        worldgenrandom.m_158876_(2620);
        PerlinNoise perlinnoise = new PerlinNoise((RandomSource)worldgenrandom, IntStream.rangeClosed(-15, 0));
        if (noisesettings.m_64546_()) {
            WorldgenRandom worldgenrandom1 = new WorldgenRandom(p_64343_);
            worldgenrandom1.m_158876_(17292);
            simplexnoise = new SimplexNoise((RandomSource)worldgenrandom1);
        } else {
            simplexnoise = null;
        }
        this.barrierNoise = NormalNoise.m_164354_((RandomSource)new SimpleRandomSource(worldgenrandom.nextLong()), (int)-3, (double[])new double[]{1.0});
        this.waterLevelNoise = NormalNoise.m_164354_((RandomSource)new SimpleRandomSource(worldgenrandom.nextLong()), (int)-3, (double[])new double[]{1.0, 0.0, 2.0});
        this.lavaNoise = NormalNoise.m_164354_((RandomSource)new SimpleRandomSource(worldgenrandom.nextLong()), (int)-1, (double[])new double[]{1.0, 0.0});
        Object noisemodifier = noisegeneratorsettings.m_158568_() ? new Cavifier((RandomSource)worldgenrandom, noisesettings.m_158703_() / this.cellHeight) : NoiseModifier.f_158626_;
        this.sampler = new NoiseSampler(p_64341_, this.cellWidth, this.cellHeight, this.cellCountY, noisesettings, blendednoise, simplexnoise, perlinnoise, noisemodifier);
        this.baseStoneSource = new DepthBasedReplacingBaseStoneSource(p_64343_, this.defaultBlock, Blocks.f_152550_.m_49966_(), noisegeneratorsettings);
        this.oreVeinifier = new OreVeinifier(p_64343_, this.defaultBlock, this.cellWidth, this.cellHeight, noisegeneratorsettings.m_64481_().m_158703_());
        this.noodleCavifier = new NoodleCavifier(p_64343_);
    }

    private boolean isAquifersEnabled() {
        return this.f_62139_.get().m_158567_();
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public ChunkGenerator m_6819_(long p_64374_) {
        return new FrostChunkGenerator(this.f_62137_.m_7206_(p_64374_), p_64374_, this.f_62139_);
    }

    public boolean stable(long p_64376_, ResourceKey<NoiseGeneratorSettings> p_64377_) {
        return this.seed == p_64376_ && this.f_62139_.get().m_64476_(p_64377_);
    }

    private double[] makeAndFillNoiseColumn(int p_158392_, int p_158393_, int p_158394_, int p_158395_) {
        double[] adouble = new double[p_158395_ + 1];
        this.fillNoiseColumn(adouble, p_158392_, p_158393_, p_158394_, p_158395_);
        return adouble;
    }

    private void fillNoiseColumn(double[] p_158467_, int p_158468_, int p_158469_, int p_158470_, int p_158471_) {
        NoiseSettings noisesettings = this.f_62139_.get().m_64481_();
        this.sampler.m_158678_(p_158467_, p_158468_, p_158469_, noisesettings, this.m_6337_(), p_158470_, p_158471_);
    }

    public int m_142647_(int p_158405_, int p_158406_, Heightmap.Types p_158407_, LevelHeightAccessor p_158408_) {
        int i = Math.max(this.f_62139_.get().m_64481_().m_158703_(), p_158408_.m_141937_());
        int j = Math.min(this.f_62139_.get().m_64481_().m_158703_() + this.f_62139_.get().m_64481_().m_64534_(), p_158408_.m_151558_());
        int k = Mth.m_14042_((int)i, (int)this.cellHeight);
        int l = Mth.m_14042_((int)(j - i), (int)this.cellHeight);
        return l <= 0 ? p_158408_.m_141937_() : this.iterateNoiseColumn(p_158405_, p_158406_, null, p_158407_.m_64299_(), k, l).orElse(p_158408_.m_141937_());
    }

    public NoiseColumn m_141914_(int p_158401_, int p_158402_, LevelHeightAccessor p_158403_) {
        int i = Math.max(this.f_62139_.get().m_64481_().m_158703_(), p_158403_.m_141937_());
        int j = Math.min(this.f_62139_.get().m_64481_().m_158703_() + this.f_62139_.get().m_64481_().m_64534_(), p_158403_.m_151558_());
        int k = Mth.m_14042_((int)i, (int)this.cellHeight);
        int l = Mth.m_14042_((int)(j - i), (int)this.cellHeight);
        if (l <= 0) {
            return new NoiseColumn(i, EMPTY_COLUMN);
        }
        BlockState[] ablockstate = new BlockState[l * this.cellHeight];
        this.iterateNoiseColumn(p_158401_, p_158402_, ablockstate, null, k, l);
        return new NoiseColumn(i, ablockstate);
    }

    public BaseStoneSource m_142168_() {
        return this.baseStoneSource;
    }

    private OptionalInt iterateNoiseColumn(int p_158414_, int p_158415_, @Nullable BlockState[] p_158416_, @Nullable Predicate<BlockState> p_158417_, int p_158418_, int p_158419_) {
        int i = SectionPos.m_123171_((int)p_158414_);
        int j = SectionPos.m_123171_((int)p_158415_);
        int k = Math.floorDiv(p_158414_, this.cellWidth);
        int l = Math.floorDiv(p_158415_, this.cellWidth);
        int i1 = Math.floorMod(p_158414_, this.cellWidth);
        int j1 = Math.floorMod(p_158415_, this.cellWidth);
        double d0 = (double)i1 / (double)this.cellWidth;
        double d1 = (double)j1 / (double)this.cellWidth;
        double[][] adouble = new double[][]{this.makeAndFillNoiseColumn(k, l, p_158418_, p_158419_), this.makeAndFillNoiseColumn(k, l + 1, p_158418_, p_158419_), this.makeAndFillNoiseColumn(k + 1, l, p_158418_, p_158419_), this.makeAndFillNoiseColumn(k + 1, l + 1, p_158418_, p_158419_)};
        Aquifer aquifer = this.getAquifer(p_158418_, p_158419_, new ChunkPos(i, j));
        for (int k1 = p_158419_ - 1; k1 >= 0; --k1) {
            double d2 = adouble[0][k1];
            double d3 = adouble[1][k1];
            double d4 = adouble[2][k1];
            double d5 = adouble[3][k1];
            double d6 = adouble[0][k1 + 1];
            double d7 = adouble[1][k1 + 1];
            double d8 = adouble[2][k1 + 1];
            double d9 = adouble[3][k1 + 1];
            for (int l1 = this.cellHeight - 1; l1 >= 0; --l1) {
                double d10 = (double)l1 / (double)this.cellHeight;
                double d11 = Mth.m_14019_((double)d10, (double)d0, (double)d1, (double)d2, (double)d6, (double)d4, (double)d8, (double)d3, (double)d7, (double)d5, (double)d9);
                int i2 = k1 * this.cellHeight + l1;
                int j2 = i2 + p_158418_ * this.cellHeight;
                BlockState blockstate = this.updateNoiseAndGenerateBaseState(Beardifier.f_158059_, aquifer, this.baseStoneSource, NoiseModifier.f_158626_, p_158414_, j2, p_158415_, d11);
                if (p_158416_ != null) {
                    p_158416_[i2] = blockstate;
                }
                if (p_158417_ == null || !p_158417_.test(blockstate)) continue;
                return OptionalInt.of(j2 + 1);
            }
        }
        return OptionalInt.empty();
    }

    private Aquifer getAquifer(int p_158397_, int p_158398_, ChunkPos p_158399_) {
        return !this.isAquifersEnabled() ? Aquifer.m_157956_((int)this.m_6337_(), (BlockState)this.defaultFluid) : Aquifer.m_157959_((ChunkPos)p_158399_, (NormalNoise)this.barrierNoise, (NormalNoise)this.waterLevelNoise, (NormalNoise)this.lavaNoise, (NoiseGeneratorSettings)this.f_62139_.get(), (NoiseSampler)this.sampler, (int)(p_158397_ * this.cellHeight), (int)(p_158398_ * this.cellHeight));
    }

    protected BlockState updateNoiseAndGenerateBaseState(Beardifier p_158440_, Aquifer p_158441_, BaseStoneSource p_158442_, NoiseModifier p_158443_, int p_158444_, int p_158445_, int p_158446_, double p_158447_) {
        double d0 = Mth.m_14008_((double)(p_158447_ / 200.0), (double)-1.0, (double)1.0);
        d0 = d0 / 2.0 - d0 * d0 * d0 / 24.0;
        d0 = p_158443_.m_142124_(d0, p_158444_, p_158445_, p_158446_);
        return p_158441_.m_142419_(p_158442_, p_158444_, p_158445_, p_158446_, d0);
    }

    public void m_7338_(WorldGenRegion p_64381_, ChunkAccess p_64382_) {
        ChunkPos chunkpos = p_64382_.m_7697_();
        int i = chunkpos.f_45578_;
        int j = chunkpos.f_45579_;
        WorldgenRandom worldgenrandom = new WorldgenRandom();
        worldgenrandom.m_64682_(i, j);
        ChunkPos chunkpos1 = p_64382_.m_7697_();
        int k = chunkpos1.m_45604_();
        int l = chunkpos1.m_45605_();
        double d0 = 0.0625;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i1 = 0; i1 < 16; ++i1) {
            for (int j1 = 0; j1 < 16; ++j1) {
                int k1 = k + i1;
                int l1 = l + j1;
                int i2 = p_64382_.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, i1, j1) + 1;
                double d1 = this.surfaceNoise.m_5495_((double)k1 * 0.0625, (double)l1 * 0.0625, 0.0625, (double)i1 * 0.0625) * 15.0;
                int j2 = this.f_62139_.get().m_158566_();
                p_64381_.m_46857_((BlockPos)blockpos$mutableblockpos.m_122178_(k + i1, i2, l + j1)).m_151682_((Random)worldgenrandom, p_64382_, k1, l1, i2, d1, this.defaultBlock, this.defaultFluid, this.m_6337_(), j2, p_64381_.m_7328_());
            }
        }
        this.setBedrock(p_64382_, (Random)worldgenrandom);
    }

    private void setBedrock(ChunkAccess p_64400_, Random p_64401_) {
        boolean flag1;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i = p_64400_.m_7697_().m_45604_();
        int j = p_64400_.m_7697_().m_45605_();
        NoiseGeneratorSettings noisegeneratorsettings = this.f_62139_.get();
        int k = noisegeneratorsettings.m_64481_().m_158703_();
        int l = k + noisegeneratorsettings.m_64485_();
        int i1 = this.height - 1 + k - noisegeneratorsettings.m_64484_();
        int j1 = 5;
        int k1 = p_64400_.m_141937_();
        int l1 = p_64400_.m_151558_();
        boolean flag = i1 + 5 - 1 >= k1 && i1 < l1;
        boolean bl = flag1 = l + 5 - 1 >= k1 && l < l1;
        if (flag || flag1) {
            for (BlockPos blockpos : BlockPos.m_121976_((int)i, (int)0, (int)j, (int)(i + 15), (int)0, (int)(j + 15))) {
                if (flag) {
                    for (int i2 = 0; i2 < 5; ++i2) {
                        if (i2 > p_64401_.nextInt(5)) continue;
                        p_64400_.m_6978_((BlockPos)blockpos$mutableblockpos.m_122178_(blockpos.m_123341_(), i1 - i2, blockpos.m_123343_()), Blocks.f_50752_.m_49966_(), false);
                    }
                }
                if (!flag1) continue;
                for (int j2 = 4; j2 >= 0; --j2) {
                    if (j2 > p_64401_.nextInt(5)) continue;
                    p_64400_.m_6978_((BlockPos)blockpos$mutableblockpos.m_122178_(blockpos.m_123341_(), l + j2, blockpos.m_123343_()), Blocks.f_50752_.m_49966_(), false);
                }
            }
        }
    }

    public CompletableFuture<ChunkAccess> m_142189_(Executor p_158463_, StructureFeatureManager p_158464_, ChunkAccess p_158465_) {
        NoiseSettings noisesettings = this.f_62139_.get().m_64481_();
        int i = Math.max(noisesettings.m_158703_(), p_158465_.m_141937_());
        int j = Math.min(noisesettings.m_158703_() + noisesettings.m_64534_(), p_158465_.m_151558_());
        int k = Mth.m_14042_((int)i, (int)this.cellHeight);
        int l = Mth.m_14042_((int)(j - i), (int)this.cellHeight);
        if (l <= 0) {
            return CompletableFuture.completedFuture(p_158465_);
        }
        int i1 = p_158465_.m_151564_(l * this.cellHeight - 1 + i);
        int j1 = p_158465_.m_151564_(i);
        return CompletableFuture.supplyAsync(() -> {
            ChunkAccess chunkaccess;
            HashSet set = Sets.newHashSet();
            try {
                for (int k1 = i1; k1 >= j1; --k1) {
                    LevelChunkSection levelchunksection = p_158465_.m_156115_(k1);
                    levelchunksection.m_62981_();
                    set.add(levelchunksection);
                }
                chunkaccess = this.doFill(p_158464_, p_158465_, k, l);
            }
            finally {
                for (LevelChunkSection levelchunksection1 : set) {
                    levelchunksection1.m_63006_();
                }
            }
            return chunkaccess;
        }, Util.m_137578_());
    }

    private ChunkAccess doFill(StructureFeatureManager p_158428_, ChunkAccess p_158429_, int p_158430_, int p_158431_) {
        Heightmap heightmap = p_158429_.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = p_158429_.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        ChunkPos chunkpos = p_158429_.m_7697_();
        int i = chunkpos.m_45604_();
        int j = chunkpos.m_45605_();
        Beardifier beardifier = Beardifier.f_158059_;
        Aquifer aquifer = this.getAquifer(p_158430_, p_158431_, chunkpos);
        NoiseInterpolator noiseinterpolator = new NoiseInterpolator(this.cellCountX, p_158431_, this.cellCountZ, chunkpos, p_158430_, this::fillNoiseColumn);
        ArrayList list = Lists.newArrayList((Object[])new NoiseInterpolator[]{noiseinterpolator});
        Consumer<NoiseInterpolator> consumer = list::add;
        DoubleFunction<BaseStoneSource> doublefunction = this.createBaseStoneSource(p_158430_, chunkpos, consumer);
        DoubleFunction<NoiseModifier> doublefunction1 = this.createCaveNoiseModifier(p_158430_, chunkpos, consumer);
        list.forEach(NoiseInterpolator::m_158601_);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k = 0; k < this.cellCountX; ++k) {
            int l = k;
            list.forEach(p_158426_ -> p_158426_.m_158604_(l));
            for (int i1 = 0; i1 < this.cellCountZ; ++i1) {
                LevelChunkSection levelchunksection = p_158429_.m_156115_(p_158429_.m_151559_() - 1);
                for (int j1 = p_158431_ - 1; j1 >= 0; --j1) {
                    int k1 = i1;
                    int l1 = j1;
                    list.forEach(p_158412_ -> p_158412_.m_158606_(l1, k1));
                    for (int i2 = this.cellHeight - 1; i2 >= 0; --i2) {
                        int j2 = (p_158430_ + j1) * this.cellHeight + i2;
                        int k2 = j2 & 0xF;
                        int l2 = p_158429_.m_151564_(j2);
                        if (p_158429_.m_151564_(levelchunksection.m_63017_()) != l2) {
                            levelchunksection = p_158429_.m_156115_(l2);
                        }
                        double d0 = (double)i2 / (double)this.cellHeight;
                        list.forEach(p_158476_ -> p_158476_.m_158602_(d0));
                        for (int i3 = 0; i3 < this.cellWidth; ++i3) {
                            int j3 = i + k * this.cellWidth + i3;
                            int k3 = j3 & 0xF;
                            double d1 = (double)i3 / (double)this.cellWidth;
                            list.forEach(p_158390_ -> p_158390_.m_158613_(d1));
                            for (int l3 = 0; l3 < this.cellWidth; ++l3) {
                                int i4 = j + i1 * this.cellWidth + l3;
                                int j4 = i4 & 0xF;
                                double d2 = (double)l3 / (double)this.cellWidth;
                                double d3 = noiseinterpolator.m_158618_(d2);
                                BlockState blockstate = this.updateNoiseAndGenerateBaseState(beardifier, aquifer, doublefunction.apply(d2), doublefunction1.apply(d2), j3, j2, i4, d3);
                                if (blockstate == AIR) continue;
                                if (blockstate.m_60791_() != 0 && p_158429_ instanceof ProtoChunk) {
                                    blockpos$mutableblockpos.m_122178_(j3, j2, i4);
                                    ((ProtoChunk)p_158429_).m_63277_((BlockPos)blockpos$mutableblockpos);
                                }
                                levelchunksection.m_62991_(k3, k2, j4, blockstate, false);
                                heightmap.m_64249_(k3, j2, j4, blockstate);
                                heightmap1.m_64249_(k3, j2, j4, blockstate);
                                if (!aquifer.m_142203_() || blockstate.m_60819_().m_76178_()) continue;
                                blockpos$mutableblockpos.m_122178_(j3, j2, i4);
                                p_158429_.m_5783_().m_5945_((BlockPos)blockpos$mutableblockpos, (Object)blockstate.m_60819_().m_76152_(), 0);
                            }
                        }
                    }
                }
            }
            list.forEach(NoiseInterpolator::m_158612_);
        }
        return p_158429_;
    }

    private DoubleFunction<NoiseModifier> createCaveNoiseModifier(int p_158421_, ChunkPos p_158422_, Consumer<NoiseInterpolator> p_158423_) {
        if (!this.f_62139_.get().m_158571_()) {
            return p_158473_ -> NoiseModifier.f_158626_;
        }
        NoodleCaveNoiseModifier noisebasedchunkgenerator$noodlecavenoisemodifier = new NoodleCaveNoiseModifier(p_158422_, p_158421_);
        noisebasedchunkgenerator$noodlecavenoisemodifier.listInterpolators(p_158423_);
        return noisebasedchunkgenerator$noodlecavenoisemodifier::prepare;
    }

    private DoubleFunction<BaseStoneSource> createBaseStoneSource(int p_158478_, ChunkPos p_158479_, Consumer<NoiseInterpolator> p_158480_) {
        if (!this.f_62139_.get().m_158570_()) {
            return p_158387_ -> this.baseStoneSource;
        }
        OreVeinNoiseSource noisebasedchunkgenerator$oreveinnoisesource = new OreVeinNoiseSource(p_158479_, p_158478_, this.seed + 1L);
        noisebasedchunkgenerator$oreveinnoisesource.listInterpolators(p_158480_);
        BaseStoneSource basestonesource = (p_158450_, p_158451_, p_158452_) -> {
            BlockState blockstate = noisebasedchunkgenerator$oreveinnoisesource.m_142722_(p_158450_, p_158451_, p_158452_);
            return blockstate != this.defaultBlock ? blockstate : this.baseStoneSource.m_142722_(p_158450_, p_158451_, p_158452_);
        };
        return p_158456_ -> {
            noisebasedchunkgenerator$oreveinnoisesource.prepare(p_158456_);
            return basestonesource;
        };
    }

    protected Aquifer m_142439_(ChunkAccess p_158438_) {
        ChunkPos chunkpos = p_158438_.m_7697_();
        int i = Math.max(this.f_62139_.get().m_64481_().m_158703_(), p_158438_.m_141937_());
        int j = Mth.m_14042_((int)i, (int)this.cellHeight);
        return this.getAquifer(j, this.cellCountY, chunkpos);
    }

    public int m_6331_() {
        return this.height;
    }

    public int m_6337_() {
        return this.f_62139_.get().m_64486_();
    }

    public int m_142062_() {
        return this.f_62139_.get().m_64481_().m_158703_();
    }

    public WeightedRandomList<MobSpawnSettings.SpawnerData> m_142184_(Biome p_158433_, StructureFeatureManager p_158434_, MobCategory p_158435_, BlockPos p_158436_) {
        WeightedRandomList spawns = StructureSpawnManager.getStructureSpawns((StructureFeatureManager)p_158434_, (MobCategory)p_158435_, (BlockPos)p_158436_);
        if (spawns != null) {
            return spawns;
        }
        return p_158435_ == MobCategory.UNDERGROUND_WATER_CREATURE && p_158434_.m_47285_(p_158436_, false, StructureFeature.f_67023_).m_73603_() ? StructureFeature.f_67023_.m_160477_() : super.m_142184_(p_158433_, p_158434_, p_158435_, p_158436_);
    }

    public void m_6929_(WorldGenRegion p_64379_) {
        if (!this.f_62139_.get().m_64487_()) {
            ChunkPos chunkpos = p_64379_.m_143488_();
            Biome biome = p_64379_.m_46857_(chunkpos.m_45615_());
            WorldgenRandom worldgenrandom = new WorldgenRandom();
            worldgenrandom.m_64690_(p_64379_.m_7328_(), chunkpos.m_45604_(), chunkpos.m_45605_());
            NaturalSpawner.m_151616_((ServerLevelAccessor)p_64379_, (Biome)biome, (ChunkPos)chunkpos, (Random)worldgenrandom);
        }
    }

    class NoodleCaveNoiseModifier
    implements NoiseModifier {
        private final NoiseInterpolator toggle;
        private final NoiseInterpolator thickness;
        private final NoiseInterpolator ridgeA;
        private final NoiseInterpolator ridgeB;
        private double factorZ;

        public NoodleCaveNoiseModifier(ChunkPos p_158501_, int p_158502_) {
            this.toggle = new NoiseInterpolator(FrostChunkGenerator.this.cellCountX, FrostChunkGenerator.this.cellCountY, FrostChunkGenerator.this.cellCountZ, p_158501_, p_158502_, (arg_0, arg_1, arg_2, arg_3, arg_4) -> ((NoodleCavifier)FrostChunkGenerator.this.noodleCavifier).m_158742_(arg_0, arg_1, arg_2, arg_3, arg_4));
            this.thickness = new NoiseInterpolator(FrostChunkGenerator.this.cellCountX, FrostChunkGenerator.this.cellCountY, FrostChunkGenerator.this.cellCountZ, p_158501_, p_158502_, (arg_0, arg_1, arg_2, arg_3, arg_4) -> ((NoodleCavifier)FrostChunkGenerator.this.noodleCavifier).m_158765_(arg_0, arg_1, arg_2, arg_3, arg_4));
            this.ridgeA = new NoiseInterpolator(FrostChunkGenerator.this.cellCountX, FrostChunkGenerator.this.cellCountY, FrostChunkGenerator.this.cellCountZ, p_158501_, p_158502_, (arg_0, arg_1, arg_2, arg_3, arg_4) -> ((NoodleCavifier)FrostChunkGenerator.this.noodleCavifier).m_158771_(arg_0, arg_1, arg_2, arg_3, arg_4));
            this.ridgeB = new NoiseInterpolator(FrostChunkGenerator.this.cellCountX, FrostChunkGenerator.this.cellCountY, FrostChunkGenerator.this.cellCountZ, p_158501_, p_158502_, (arg_0, arg_1, arg_2, arg_3, arg_4) -> ((NoodleCavifier)FrostChunkGenerator.this.noodleCavifier).m_158777_(arg_0, arg_1, arg_2, arg_3, arg_4));
        }

        public NoiseModifier prepare(double p_158504_) {
            this.factorZ = p_158504_;
            return this;
        }

        public double m_142124_(double p_158508_, int p_158509_, int p_158510_, int p_158511_) {
            double d0 = this.toggle.m_158618_(this.factorZ);
            double d1 = this.thickness.m_158618_(this.factorZ);
            double d2 = this.ridgeA.m_158618_(this.factorZ);
            double d3 = this.ridgeB.m_158618_(this.factorZ);
            return FrostChunkGenerator.this.noodleCavifier.m_158732_(p_158508_, p_158509_, p_158510_, p_158511_, d0, d1, d2, d3, FrostChunkGenerator.this.m_142062_());
        }

        public void listInterpolators(Consumer<NoiseInterpolator> p_158506_) {
            p_158506_.accept(this.toggle);
            p_158506_.accept(this.thickness);
            p_158506_.accept(this.ridgeA);
            p_158506_.accept(this.ridgeB);
        }
    }

    class OreVeinNoiseSource
    implements BaseStoneSource {
        private final NoiseInterpolator veininess;
        private final NoiseInterpolator veinA;
        private final NoiseInterpolator veinB;
        private double factorZ;
        private final long seed;
        private final WorldgenRandom random = new WorldgenRandom();

        public OreVeinNoiseSource(ChunkPos p_158521_, int p_158522_, long p_158523_) {
            this.veininess = new NoiseInterpolator(FrostChunkGenerator.this.cellCountX, FrostChunkGenerator.this.cellCountY, FrostChunkGenerator.this.cellCountZ, p_158521_, p_158522_, (arg_0, arg_1, arg_2, arg_3, arg_4) -> ((OreVeinifier)FrostChunkGenerator.this.oreVeinifier).m_158827_(arg_0, arg_1, arg_2, arg_3, arg_4));
            this.veinA = new NoiseInterpolator(FrostChunkGenerator.this.cellCountX, FrostChunkGenerator.this.cellCountY, FrostChunkGenerator.this.cellCountZ, p_158521_, p_158522_, (arg_0, arg_1, arg_2, arg_3, arg_4) -> ((OreVeinifier)FrostChunkGenerator.this.oreVeinifier).m_158843_(arg_0, arg_1, arg_2, arg_3, arg_4));
            this.veinB = new NoiseInterpolator(FrostChunkGenerator.this.cellCountX, FrostChunkGenerator.this.cellCountY, FrostChunkGenerator.this.cellCountZ, p_158521_, p_158522_, (arg_0, arg_1, arg_2, arg_3, arg_4) -> ((OreVeinifier)FrostChunkGenerator.this.oreVeinifier).m_158849_(arg_0, arg_1, arg_2, arg_3, arg_4));
            this.seed = p_158523_;
        }

        public void listInterpolators(Consumer<NoiseInterpolator> p_158527_) {
            p_158527_.accept(this.veininess);
            p_158527_.accept(this.veinA);
            p_158527_.accept(this.veinB);
        }

        public void prepare(double p_158525_) {
            this.factorZ = p_158525_;
        }

        public BlockState m_142722_(int p_158529_, int p_158530_, int p_158531_) {
            double d0 = this.veininess.m_158618_(this.factorZ);
            double d1 = this.veinA.m_158618_(this.factorZ);
            double d2 = this.veinB.m_158618_(this.factorZ);
            this.random.m_158961_(this.seed, p_158529_, p_158530_, p_158531_);
            return FrostChunkGenerator.this.oreVeinifier.m_158819_((RandomSource)this.random, p_158529_, p_158530_, p_158531_, d0, d1, d2);
        }
    }
}

