/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.world;

import baguchan.frostrealm.block.FrostPortalBlock;
import baguchan.frostrealm.register.FrostBlocks;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class FrostWorldTeleporter
implements ITeleporter {
    private static final Map<ResourceLocation, Map<ColumnPos, PortalPosition>> destinationCoordinateCache = new HashMap<ResourceLocation, Map<ColumnPos, PortalPosition>>();
    private static final Object2LongMap<ColumnPos> columnMap = new Object2LongOpenHashMap();

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel dest, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        PortalInfo pos = FrostWorldTeleporter.placeInExistingPortal(dest, entity, entity.m_142538_(), entity instanceof Player);
        if (pos == null) {
            pos = FrostWorldTeleporter.moveToSafeCoords(dest, entity);
            FrostWorldTeleporter.makePortal(entity, dest, pos.f_77676_);
            pos = FrostWorldTeleporter.placeInExistingPortal(dest, entity, new BlockPos(pos.f_77676_), entity instanceof Player);
        }
        return pos;
    }

    @Nullable
    private static PortalInfo placeInExistingPortal(ServerLevel world, Entity entity, BlockPos pos, boolean isPlayer) {
        PortalPosition portalPosition;
        int i = 200;
        boolean flag = true;
        BlockPos blockpos = BlockPos.f_121853_;
        ColumnPos columnPos = new ColumnPos(pos);
        if (!isPlayer && columnMap.containsKey((Object)columnPos)) {
            return null;
        }
        PortalPosition portalPosition2 = portalPosition = destinationCoordinateCache.containsKey(world.m_46472_().getRegistryName()) ? destinationCoordinateCache.get(world.m_46472_().getRegistryName()).get(columnPos) : null;
        if (portalPosition != null) {
            blockpos = portalPosition.pos;
            portalPosition.lastUpdateTime = world.m_46467_();
            flag = false;
        } else {
            double d0 = Double.MAX_VALUE;
            for (int i1 = -i; i1 <= i; ++i1) {
                for (int j1 = -i; j1 <= i; ++j1) {
                    if (!world.m_6857_().m_61937_(pos.m_142082_(i1, 0, j1))) continue;
                    ChunkPos chunkPos = new ChunkPos(pos.m_142082_(i1, 0, j1));
                    LevelChunk chunk = world.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
                    BlockPos blockpos1 = pos.m_142082_(i1, FrostWorldTeleporter.getScanHeight(world, pos) - pos.m_123342_(), j1);
                    while (blockpos1.m_123342_() >= 0) {
                        BlockPos blockpos2 = blockpos1.m_7495_();
                        if (!(d0 >= 0.0 && blockpos1.m_123331_((Vec3i)pos) >= d0 || !FrostWorldTeleporter.isPortal(chunk.m_8055_(blockpos1)))) {
                            blockpos2 = blockpos1.m_7495_();
                            while (FrostWorldTeleporter.isPortal(chunk.m_8055_(blockpos2))) {
                                blockpos1 = blockpos2;
                                blockpos2 = blockpos2.m_7495_();
                            }
                            double d1 = blockpos1.m_123331_((Vec3i)pos);
                            if (d0 < 0.0 || d1 < d0) {
                                d0 = d1;
                                blockpos = blockpos1;
                                i = Mth.m_14167_((float)Mth.m_14116_((float)((float)d1)));
                            }
                        }
                        blockpos1 = blockpos2;
                    }
                }
            }
        }
        if (blockpos.equals((Object)BlockPos.f_121853_)) {
            long factor = world.m_46467_() + 300L;
            columnMap.put((Object)columnPos, factor);
            return null;
        }
        if (flag) {
            destinationCoordinateCache.putIfAbsent(world.m_46472_().getRegistryName(), Maps.newHashMapWithExpectedSize((int)4096));
            destinationCoordinateCache.get(world.m_46472_().getRegistryName()).put(columnPos, new PortalPosition(blockpos, world.m_46467_()));
            world.m_7726_().registerTickingTicket(TicketType.f_9447_, new ChunkPos(blockpos), 3, (Object)new BlockPos(columnPos.f_140723_, blockpos.m_123342_(), columnPos.f_140724_));
        }
        BlockPos[] portalBorder = FrostWorldTeleporter.getBoundaryPositions(world, blockpos).toArray(new BlockPos[0]);
        BlockPos borderPos = portalBorder[0];
        double portalX = (double)borderPos.m_123341_() + 0.5;
        double portalY = (double)borderPos.m_123342_() + 1.0;
        double portalZ = (double)borderPos.m_123343_() + 0.5;
        return FrostWorldTeleporter.makePortalInfo(entity, portalX, portalY, portalZ);
    }

    private static int getScanHeight(ServerLevel world, BlockPos pos) {
        return FrostWorldTeleporter.getScanHeight(world, pos.m_123341_(), pos.m_123343_());
    }

    private static int getScanHeight(ServerLevel world, int x, int z) {
        int worldHeight = world.m_141928_() - 1;
        int chunkHeight = world.m_6325_(x >> 4, z >> 4).m_62098_() + 15;
        return Math.min(worldHeight, chunkHeight);
    }

    private static boolean isPortal(BlockState state) {
        return state.m_60734_() == FrostBlocks.FROST_PORTAL.get();
    }

    private static Set<BlockPos> getBoundaryPositions(ServerLevel world, BlockPos start) {
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        checked.add(start);
        FrostWorldTeleporter.checkAdjacent(world, start, checked, result);
        return result;
    }

    private static void checkAdjacent(ServerLevel world, BlockPos pos, Set<BlockPos> checked, Set<BlockPos> result) {
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            BlockPos offset = pos.m_142300_(facing);
            if (!checked.add(offset)) continue;
            if (FrostWorldTeleporter.isPortalAt(world, offset)) {
                FrostWorldTeleporter.checkAdjacent(world, offset, checked, result);
                continue;
            }
            result.add(offset);
        }
    }

    private static boolean isPortalAt(ServerLevel world, BlockPos pos) {
        return FrostWorldTeleporter.isPortal(world.m_8055_(pos));
    }

    private static PortalInfo moveToSafeCoords(ServerLevel world, Entity entity) {
        BlockPos pos = entity.m_142538_();
        if (FrostWorldTeleporter.isSafeAround((Level)world, pos, entity)) {
            return FrostWorldTeleporter.makePortalInfo(entity, entity.m_20182_());
        }
        BlockPos safeCoords = FrostWorldTeleporter.findSafeCoords(world, 200, pos, entity);
        if (safeCoords != null) {
            return FrostWorldTeleporter.makePortalInfo(entity, safeCoords.m_123341_(), entity.m_20186_(), safeCoords.m_123343_());
        }
        safeCoords = FrostWorldTeleporter.findSafeCoords(world, 400, pos, entity);
        if (safeCoords != null) {
            return FrostWorldTeleporter.makePortalInfo(entity, safeCoords.m_123341_(), entity.m_20186_(), safeCoords.m_123343_());
        }
        return FrostWorldTeleporter.makePortalInfo(entity, entity.m_20182_());
    }

    public static boolean isSafeAround(Level world, BlockPos pos, Entity entity) {
        if (!FrostWorldTeleporter.isSafe(world, pos, entity)) {
            return false;
        }
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            if (FrostWorldTeleporter.isSafe(world, pos.m_5484_(facing, 16), entity)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSafe(Level world, BlockPos pos, Entity entity) {
        return FrostWorldTeleporter.checkPos(world, pos);
    }

    private static boolean checkPos(Level world, BlockPos pos) {
        return world.m_6857_().m_61937_(pos);
    }

    @Nullable
    private static BlockPos findSafeCoords(ServerLevel world, int range, BlockPos pos, Entity entity) {
        int attempts = range / 8;
        for (int x = 0; x < attempts; ++x) {
            for (int z = 0; z < attempts; ++z) {
                BlockPos dPos = new BlockPos(pos.m_123341_() + x * attempts - range / 2, 100, pos.m_123343_() + z * attempts - range / 2);
                if (!FrostWorldTeleporter.isSafeAround((Level)world, dPos, entity)) continue;
                return dPos;
            }
        }
        return null;
    }

    private static void makePortal(Entity entity, ServerLevel world, Vec3 pos) {
        FrostWorldTeleporter.loadSurroundingArea(world, pos);
        BlockPos spot = FrostWorldTeleporter.findPortalCoords(world, pos, blockPos -> FrostWorldTeleporter.isPortalAt(world, blockPos));
        String name = entity.m_7755_().getString();
        if (spot != null) {
            FrostWorldTeleporter.cachePortalCoords(world, pos, spot);
            return;
        }
        spot = FrostWorldTeleporter.findPortalCoords(world, pos, blockpos -> FrostWorldTeleporter.isIdealForPortal(world, blockpos));
        if (spot != null) {
            FrostWorldTeleporter.cachePortalCoords(world, pos, FrostWorldTeleporter.makePortalAt((Level)world, spot));
            return;
        }
        spot = FrostWorldTeleporter.findPortalCoords(world, pos, blockPos -> FrostWorldTeleporter.isOkayForPortal(world, blockPos));
        if (spot != null) {
            FrostWorldTeleporter.cachePortalCoords(world, pos, FrostWorldTeleporter.makePortalAt((Level)world, spot));
            return;
        }
        double yFactor = FrostWorldTeleporter.getYFactor(world);
        FrostWorldTeleporter.cachePortalCoords(world, pos, FrostWorldTeleporter.makePortalAt((Level)world, new BlockPos(entity.m_20185_(), entity.m_20186_() * yFactor - 1.0, entity.m_20189_())));
    }

    private static boolean isOkayForPortal(ServerLevel world, BlockPos pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = 0; potentialY < 4; ++potentialY) {
                    BlockPos tPos = pos.m_142082_(potentialX - 1, potentialY, potentialZ - 1);
                    Material material = world.m_8055_(tPos).m_60767_();
                    if ((potentialY != 0 || material.m_76333_() || material.m_76332_()) && (potentialY < 1 || material.m_76336_())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static void loadSurroundingArea(ServerLevel world, Vec3 pos) {
        int x = Mth.m_14107_((double)pos.f_82479_) >> 4;
        int z = Mth.m_14107_((double)pos.f_82480_) >> 4;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                world.m_6325_(x + dx, z + dz);
            }
        }
    }

    @Nullable
    private static BlockPos findPortalCoords(ServerLevel world, Vec3 loc, Predicate<BlockPos> predicate) {
        double yFactor = FrostWorldTeleporter.getYFactor(world);
        int entityX = Mth.m_14107_((double)loc.f_82479_);
        int entityZ = Mth.m_14107_((double)loc.f_82481_);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        double spotWeight = -1.0;
        BlockPos spot = null;
        int range = 16;
        for (int rx = entityX - range; rx <= entityX + range; ++rx) {
            double xWeight = (double)rx + 0.5 - loc.f_82479_;
            for (int rz = entityZ - range; rz <= entityZ + range; ++rz) {
                double zWeight = (double)rz + 0.5 - loc.f_82481_;
                for (int ry = FrostWorldTeleporter.getScanHeight(world, rx, rz); ry >= 0; --ry) {
                    if (!world.m_46859_((BlockPos)pos.m_122178_(rx, ry, rz))) continue;
                    while (ry > 0 && world.m_46859_((BlockPos)pos.m_122178_(rx, ry - 1, rz))) {
                        --ry;
                    }
                    double yWeight = (double)ry + 0.5 - loc.f_82480_ * yFactor;
                    double rPosWeight = xWeight * xWeight + yWeight * yWeight + zWeight * zWeight;
                    if (!(spotWeight < 0.0) && !(rPosWeight < spotWeight) || !predicate.test((BlockPos)pos)) continue;
                    spotWeight = rPosWeight;
                    spot = pos.m_7949_();
                }
            }
        }
        return spot;
    }

    private static double getYFactor(ServerLevel world) {
        return world.m_46472_().getRegistryName().equals((Object)Level.f_46428_.getRegistryName()) ? 2.0 : 0.5;
    }

    private static void cachePortalCoords(ServerLevel world, Vec3 loc, BlockPos pos) {
        int x = Mth.m_14107_((double)loc.f_82479_);
        int z = Mth.m_14107_((double)loc.f_82481_);
        destinationCoordinateCache.putIfAbsent(world.m_46472_().getRegistryName(), Maps.newHashMapWithExpectedSize((int)4096));
        destinationCoordinateCache.get(world.m_46472_().getRegistryName()).put(new ColumnPos(x, z), new PortalPosition(pos, world.m_46467_()));
    }

    private static boolean isIdealForPortal(ServerLevel world, BlockPos pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = 0; potentialY < 4; ++potentialY) {
                    BlockPos tPos = pos.m_142082_(potentialX - 1, potentialY, potentialZ - 1);
                    Material material = world.m_8055_(tPos).m_60767_();
                    if ((potentialY != 0 || material == Material.f_76302_) && (potentialY < 1 || material.m_76336_())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static BlockPos makePortalAt(Level world, BlockPos pos) {
        BlockState portalState = ((FrostPortalBlock)FrostBlocks.FROST_PORTAL.get()).m_49966_();
        while (pos.m_123341_() > world.m_142475_() + 1 && world.m_46859_(pos)) {
            pos = pos.m_7495_();
        }
        while (!world.m_46859_(pos.m_7494_()) && world.m_8055_(pos).m_60734_() != FrostBlocks.FROZEN_GRASS_BLOCK.get()) {
            pos = pos.m_7494_();
        }
        BlockState snowstate = Blocks.f_50127_.m_49966_();
        for (BlockPos basePos : BlockPos.MutableBlockPos.m_121940_((BlockPos)pos.m_142082_(-2, 0, -2), (BlockPos)pos.m_142082_(2, 1, 2))) {
            world.m_7731_(basePos, snowstate, 2);
        }
        for (BlockPos airPos : BlockPos.MutableBlockPos.m_121940_((BlockPos)pos.m_142082_(-2, 2, -1), (BlockPos)pos.m_142082_(2, 3, 1))) {
            world.m_7731_(airPos, Blocks.f_50016_.m_49966_(), 2);
        }
        for (BlockPos portalPos : BlockPos.MutableBlockPos.m_121940_((BlockPos)pos.m_142082_(-1, 1, -1), (BlockPos)pos.m_142082_(1, 1, 1))) {
            world.m_7731_(portalPos, portalState, 2);
        }
        return pos;
    }

    private static PortalInfo makePortalInfo(Entity entity, double x, double y, double z) {
        return FrostWorldTeleporter.makePortalInfo(entity, new Vec3(x, y, z));
    }

    private static PortalInfo makePortalInfo(Entity entity, Vec3 pos) {
        return new PortalInfo(pos, Vec3.f_82478_, entity.m_146909_(), entity.m_146908_());
    }

    static class PortalPosition {
        public final BlockPos pos;
        public long lastUpdateTime;

        public PortalPosition(BlockPos pos, long time) {
            this.pos = pos;
            this.lastUpdateTime = time;
        }
    }
}

