/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.world.data;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.api.Weather;
import baguchan.frostrealm.register.FrostDimensions;
import baguchan.frostrealm.register.FrostWeatherSystem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class FrostWeatherData
extends SavedData {
    public static String DATA_NAME = "frostrealm:weather_data";
    private static final FrostWeatherData CLIENT_CACHE = new FrostWeatherData();
    private ResourceLocation event = FrostWeatherSystem.CLEAR;
    private boolean isWeatherForced;
    private boolean modified;
    private int rainTime;
    private int clearWeatherTime;
    public static Weather currentWeather;

    public static FrostWeatherData get(LevelAccessor world) {
        if (!(world instanceof ServerLevel)) {
            return CLIENT_CACHE;
        }
        ServerLevel frostWorld = ((ServerLevel)world).m_6018_().m_142572_().m_129880_(FrostDimensions.frostrealm);
        DimensionDataStorage data = frostWorld.m_8895_();
        FrostWeatherData weatherData = (FrostWeatherData)data.m_164861_(FrostWeatherData::load, FrostWeatherData::new, DATA_NAME);
        if (weatherData == null) {
            weatherData = new FrostWeatherData();
            data.m_164855_(DATA_NAME, (SavedData)weatherData);
        }
        return weatherData;
    }

    public static FrostWeatherData load(CompoundTag nbt) {
        FrostWeatherData frostWeatherData = new FrostWeatherData();
        frostWeatherData.setEvent(nbt.m_128461_("Event"));
        frostWeatherData.setWeatherForced(nbt.m_128471_("Forced"));
        frostWeatherData.setModified(nbt.m_128471_("Modified"));
        frostWeatherData.setRainTime(nbt.m_128451_("RainTime"));
        frostWeatherData.setClearWeatherTime(nbt.m_128451_("ClearRainTime"));
        return frostWeatherData;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128359_("Event", this.event.toString());
        compound.m_128379_("Forced", this.isWeatherForced);
        compound.m_128379_("Modified", this.modified);
        compound.m_128405_("RainTime", this.rainTime);
        compound.m_128405_("ClearRainTime", this.clearWeatherTime);
        return compound;
    }

    public boolean isNoWeather() {
        return this.event.equals((Object)FrostWeatherSystem.CLEAR);
    }

    public boolean isBrizzard() {
        return this.event.equals((Object)FrostWeatherSystem.BLIZZARD);
    }

    public String getEventString() {
        return this.event.toString();
    }

    public ResourceLocation getEventID() {
        return this.event;
    }

    public Weather getEvent() {
        Weather weatherEvent = FrostWeatherSystem.WEATHER_EVENTS.get(this.event);
        if (weatherEvent == null) {
            weatherEvent = FrostWeatherSystem.WEATHER_EVENTS.get(FrostWeatherSystem.CLEAR);
            FrostRealm.LOGGER.error("Getting the current Weather Event saved data was null for this world, restoring data by defaulting to clear...");
        }
        return weatherEvent;
    }

    public void setEvent(String event) {
        this.event = new ResourceLocation(event);
        this.m_77762_();
        Weather currentWeather = FrostWeatherSystem.WEATHER_EVENTS.get(this.event);
        if (currentWeather == null) {
            FrostWeatherData.currentWeather = FrostWeatherSystem.WEATHER_EVENTS.get(FrostWeatherSystem.CLEAR);
            FrostRealm.LOGGER.error("Setting the current Weather Event saved data was null for this world, restoring data by defaulting to clear...");
        } else {
            FrostWeatherData.currentWeather = currentWeather;
        }
    }

    public boolean isWeatherForced() {
        return this.isWeatherForced;
    }

    public void setWeatherForced(boolean weatherForced) {
        this.isWeatherForced = weatherForced;
        this.m_77762_();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        this.m_77762_();
    }

    public int getClearWeatherTime() {
        return this.clearWeatherTime;
    }

    public void setClearWeatherTime(int p_230391_1_) {
        this.clearWeatherTime = p_230391_1_;
        this.m_77762_();
    }

    public int getRainTime() {
        return this.rainTime;
    }

    public void setRainTime(int p_76080_1_) {
        this.rainTime = p_76080_1_;
        this.m_77762_();
    }
}

