/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.world.feature;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class FRTreeFeature
extends Feature<TreeConfiguration> {
    private static final int BLOCK_UPDATE_FLAGS = 19;

    public FRTreeFeature(Codec<TreeConfiguration> p_67201_) {
        super(p_67201_);
    }

    public static boolean isFree(LevelSimulatedReader p_67263_, BlockPos p_67264_) {
        return FRTreeFeature.validTreePos(p_67263_, p_67264_) || p_67263_.m_7433_(p_67264_, p_67281_ -> p_67281_.m_60620_((Tag)BlockTags.f_13106_));
    }

    private static boolean isVine(LevelSimulatedReader p_67278_, BlockPos p_67279_) {
        return p_67278_.m_7433_(p_67279_, p_67276_ -> p_67276_.m_60713_(Blocks.f_50191_));
    }

    private static boolean isBlockWater(LevelSimulatedReader p_67283_, BlockPos p_67284_) {
        return p_67283_.m_7433_(p_67284_, p_67271_ -> p_67271_.m_60713_(Blocks.f_49990_));
    }

    public static boolean isAirOrLeaves(LevelSimulatedReader p_67268_, BlockPos p_67269_) {
        return p_67268_.m_7433_(p_67269_, p_67266_ -> p_67266_.m_60795_() || p_67266_.m_60620_((Tag)BlockTags.f_13035_));
    }

    private static boolean isReplaceablePlant(LevelSimulatedReader p_67289_, BlockPos p_67290_) {
        return p_67289_.m_7433_(p_67290_, p_160551_ -> {
            Material var1 = p_160551_.m_60767_();
            return var1 == Material.f_76302_;
        });
    }

    private static void setBlockKnownShape(LevelWriter p_67257_, BlockPos p_67258_, BlockState p_67259_) {
        p_67257_.m_7731_(p_67258_, p_67259_, 19);
    }

    public static boolean validTreePos(LevelSimulatedReader p_67273_, BlockPos p_67274_) {
        return FRTreeFeature.isAirOrLeaves(p_67273_, p_67274_) || FRTreeFeature.isReplaceablePlant(p_67273_, p_67274_) || FRTreeFeature.isBlockWater(p_67273_, p_67274_);
    }

    private boolean doPlace(WorldGenLevel p_160511_, Random p_160512_, BlockPos p_160513_, BiConsumer<BlockPos, BlockState> p_160514_, BiConsumer<BlockPos, BlockState> p_160515_, TreeConfiguration p_160516_) {
        int var7 = p_160516_.f_68190_.m_70309_(p_160512_);
        int var8 = p_160516_.f_68189_.m_5969_(p_160512_, var7, p_160516_);
        int var9 = var7 - var8;
        int var10 = p_160516_.f_68189_.m_5937_(p_160512_, var9);
        if (p_160513_.m_123342_() >= p_160511_.m_141937_() + 1 && p_160513_.m_123342_() + var7 + 1 <= p_160511_.m_151558_()) {
            if (!p_160516_.f_161214_.m_7112_(p_160512_, p_160513_).m_60710_((LevelReader)p_160511_, p_160513_)) {
                return false;
            }
            OptionalInt var11 = p_160516_.f_68191_.m_68295_();
            int var12 = this.getMaxFreeTreeHeight((LevelSimulatedReader)p_160511_, var7, p_160513_, p_160516_);
            if (var12 >= var7 || var11.isPresent() && var12 >= var11.getAsInt()) {
                List var13 = p_160516_.f_68190_.m_142625_((LevelSimulatedReader)p_160511_, p_160514_, p_160512_, var12, p_160513_, p_160516_);
                var13.forEach(p_160539_ -> p_160516_.f_68189_.m_161413_((LevelSimulatedReader)p_160511_, p_160515_, p_160512_, p_160516_, var12, p_160539_, var8, var10));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(LevelSimulatedReader p_67216_, int p_67217_, BlockPos p_67218_, TreeConfiguration p_67219_) {
        BlockPos.MutableBlockPos var5 = new BlockPos.MutableBlockPos();
        for (int var6 = 0; var6 <= p_67217_ + 1; ++var6) {
            int var7 = p_67219_.f_68191_.m_6133_(p_67217_, var6);
            for (int var8 = -var7; var8 <= var7; ++var8) {
                for (int var9 = -var7; var9 <= var7; ++var9) {
                    var5.m_122154_((Vec3i)p_67218_, var8, var6, var9);
                    if (FRTreeFeature.isFree(p_67216_, (BlockPos)var5) && (p_67219_.f_68193_ || !FRTreeFeature.isVine(p_67216_, (BlockPos)var5))) continue;
                    return var6 - 2;
                }
            }
        }
        return p_67217_;
    }

    protected void m_5974_(LevelWriter p_67221_, BlockPos p_67222_, BlockState p_67223_) {
        FRTreeFeature.setBlockKnownShape(p_67221_, p_67222_, p_67223_);
    }

    public final boolean m_142674_(FeaturePlaceContext<TreeConfiguration> p_160530_) {
        WorldGenLevel var2 = p_160530_.m_159774_();
        Random var3 = p_160530_.m_159776_();
        BlockPos var4 = p_160530_.m_159777_();
        TreeConfiguration var5 = (TreeConfiguration)p_160530_.m_159778_();
        HashSet var6 = Sets.newHashSet();
        HashSet var7 = Sets.newHashSet();
        HashSet var8 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> var9 = (p_160555_, p_160556_) -> {
            var6.add(p_160555_.m_7949_());
            var2.m_7731_(p_160555_, p_160556_, 19);
        };
        BiConsumer<BlockPos, BlockState> var10 = (p_160548_, p_160549_) -> {
            var7.add(p_160548_.m_7949_());
            var2.m_7731_(p_160548_, p_160549_, 19);
        };
        BiConsumer<BlockPos, BlockState> var11 = (p_160543_, p_160544_) -> {
            var8.add(p_160543_.m_7949_());
            var2.m_7731_(p_160543_, p_160544_, 19);
        };
        boolean var12 = this.doPlace(var2, var3, var4, var9, var10, var5);
        if (!(!var12 || var6.isEmpty() && var7.isEmpty())) {
            if (!var5.f_68187_.isEmpty()) {
                ArrayList var13 = Lists.newArrayList((Iterable)var6);
                ArrayList var14 = Lists.newArrayList((Iterable)var7);
                var13.sort(Comparator.comparingInt(Vec3i::m_123342_));
                var14.sort(Comparator.comparingInt(Vec3i::m_123342_));
                var5.f_68187_.forEach(p_160528_ -> p_160528_.m_142741_((LevelSimulatedReader)var2, var11, var3, var13, var14));
            }
            return BoundingBox.m_162378_((Iterable)Iterables.concat((Iterable)var6, (Iterable)var7, (Iterable)var8)).map(p_160521_ -> {
                DiscreteVoxelShape var13 = FRTreeFeature.updateLeaves((LevelAccessor)var2, p_160521_, var6, var8);
                StructureTemplate.m_74510_((LevelAccessor)var2, (int)3, (DiscreteVoxelShape)var13, (int)p_160521_.m_162395_(), (int)p_160521_.m_162396_(), (int)p_160521_.m_162398_());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static DiscreteVoxelShape updateLeaves(LevelAccessor p_67203_, BoundingBox p_67204_, Set<BlockPos> p_67205_, Set<BlockPos> p_67206_) {
        ArrayList var4 = Lists.newArrayList();
        BitSetDiscreteVoxelShape var5 = new BitSetDiscreteVoxelShape(p_67204_.m_71056_(), p_67204_.m_71057_(), p_67204_.m_71058_());
        for (int var7 = 0; var7 < 6; ++var7) {
            var4.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos var20 = new BlockPos.MutableBlockPos();
        for (BlockPos var9 : Lists.newArrayList(p_67206_)) {
            if (!p_67204_.m_71051_((Vec3i)var9)) continue;
            var5.m_142703_(var9.m_123341_() - p_67204_.m_162395_(), var9.m_123342_() - p_67204_.m_162396_(), var9.m_123343_() - p_67204_.m_162398_());
        }
        for (BlockPos var9 : Lists.newArrayList(p_67205_)) {
            if (p_67204_.m_71051_((Vec3i)var9)) {
                var5.m_142703_(var9.m_123341_() - p_67204_.m_162395_(), var9.m_123342_() - p_67204_.m_162396_(), var9.m_123343_() - p_67204_.m_162398_());
            }
            for (Direction var13 : Direction.values()) {
                BlockState var14;
                var20.m_122159_((Vec3i)var9, var13);
                if (p_67205_.contains(var20) || !(var14 = p_67203_.m_8055_((BlockPos)var20)).m_61138_((Property)BlockStateProperties.f_61414_)) continue;
                ((Set)var4.get(0)).add(var20.m_7949_());
                FRTreeFeature.setBlockKnownShape((LevelWriter)p_67203_, (BlockPos)var20, (BlockState)var14.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1)));
                if (!p_67204_.m_71051_((Vec3i)var20)) continue;
                var5.m_142703_(var20.m_123341_() - p_67204_.m_162395_(), var20.m_123342_() - p_67204_.m_162396_(), var20.m_123343_() - p_67204_.m_162398_());
            }
        }
        for (int var21 = 1; var21 < 6; ++var21) {
            Set var22 = (Set)var4.get(var21 - 1);
            Set var23 = (Set)var4.get(var21);
            for (BlockPos var25 : var22) {
                if (p_67204_.m_71051_((Vec3i)var25)) {
                    var5.m_142703_(var25.m_123341_() - p_67204_.m_162395_(), var25.m_123342_() - p_67204_.m_162396_(), var25.m_123343_() - p_67204_.m_162398_());
                }
                for (Direction var16 : Direction.values()) {
                    int var18;
                    BlockState var17;
                    var20.m_122159_((Vec3i)var25, var16);
                    if (var22.contains(var20) || var23.contains(var20) || !(var17 = p_67203_.m_8055_((BlockPos)var20)).m_61138_((Property)BlockStateProperties.f_61414_) || (var18 = ((Integer)var17.m_61143_((Property)BlockStateProperties.f_61414_)).intValue()) <= var21 + 1) continue;
                    BlockState var19 = (BlockState)var17.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(var21 + 1));
                    FRTreeFeature.setBlockKnownShape((LevelWriter)p_67203_, (BlockPos)var20, var19);
                    if (p_67204_.m_71051_((Vec3i)var20)) {
                        var5.m_142703_(var20.m_123341_() - p_67204_.m_162395_(), var20.m_123342_() - p_67204_.m_162396_(), var20.m_123343_() - p_67204_.m_162398_());
                    }
                    var23.add(var20.m_7949_());
                }
            }
        }
        return var5;
    }
}

