/*
 * Decompiled with CFR 0.152.
 */
package teamfrost.frostrealm.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamfrost.frostrealm.FrostRealmTab;
import teamfrost.frostrealm.block.enums.SaplingVariant;
import teamfrost.frostrealm.handler.FrostrealmBlocks;
import teamfrost.frostrealm.handler.ModelRegisterCallback;
import teamfrost.frostrealm.world.dimension.gen.GenFrozenTree;

public class BlockFrozenSapling
extends BlockBush
implements IGrowable,
ModelRegisterCallback {
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);

    public BlockFrozenSapling() {
        this.func_149647_a(FrostRealmTab.BLOCK);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149663_c("frozen_sapling");
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        GenFrozenTree treeGenerator = new GenFrozenTree(true);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 4);
        if (!treeGenerator.func_180709_b(world, rand, pos)) {
            world.func_180501_a(pos, state, 4);
        }
    }

    protected boolean func_185514_i(IBlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak || block == FrostrealmBlocks.FROZEN_DIRT || state.func_185904_a() == Material.field_151577_b;
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        BlockPos down = pos.func_177977_b();
        IBlockState soil = world.func_180495_p(down);
        return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, down, EnumFacing.UP, (IPlantable)this);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 4 && rand.nextInt(7) == 0) {
                this.func_176474_b(worldIn, rand, pos, state);
            }
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        for (int i = 0; i < SaplingVariant.values().length; ++i) {
            String variant = "inventory_" + SaplingVariant.values()[i].func_176610_l();
            ModelResourceLocation mrl = new ModelResourceLocation(this.getRegistryName(), variant);
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)mrl);
        }
    }
}

