/*
 * Decompiled with CFR 0.152.
 */
package teamfrost.frostrealm.capability;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import teamfrost.frostrealm.api.IWarmCapability;
import teamfrost.frostrealm.capability.WarmCapabilityManager;

public class WarmCapabilityProvider
implements ICapabilityProvider,
INBTSerializable,
IWarmCapability {
    float warm;
    float maxWarm;

    WarmCapabilityProvider(boolean isNew) {
        if (isNew) {
            this.warm = 40.0f;
            this.maxWarm = 40.0f;
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return WarmCapabilityManager.warmCapability != null && capability == WarmCapabilityManager.warmCapability;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == WarmCapabilityManager.warmCapability) {
            return (T)WarmCapabilityManager.warmCapability.cast((Object)this);
        }
        return null;
    }

    @Override
    public float getWarm() {
        return this.warm;
    }

    @Override
    public float getMaxWarm() {
        return this.maxWarm;
    }

    @Override
    public void setWarm(float warm) {
        this.warm = warm;
        if (warm < 0.0f) {
            this.warm = 0.0f;
        }
        if (warm > this.getMaxWarm()) {
            this.warm = this.getMaxWarm();
        }
    }

    @Override
    public void setMaxWarm(float maxWarm) {
        this.maxWarm = maxWarm;
    }

    public NBTBase serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("maxWarm", this.getMaxWarm());
        tag.func_74776_a("warm", this.getWarm());
        return tag;
    }

    public void deserializeNBT(NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            if (tag.func_74764_b("maxWarm")) {
                this.setMaxWarm(tag.func_74760_g("maxWarm"));
            }
            if (tag.func_74764_b("warm")) {
                this.setWarm(tag.func_74760_g("warm"));
            }
        }
    }
}

