/*
 * Decompiled with CFR 0.152.
 */
package teamfrost.frostrealm.client.sky;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javafx.scene.shape.Mesh;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamfrost.frostrealm.client.sky.AuroraRenderer;
import teamfrost.frostrealm.world.dimension.FrostRealmWorldProvider;

@SideOnly(value=Side.CLIENT)
public class FrostSkyRenderer
extends IRenderHandler {
    public static final ResourceLocation SKY_TEXTURE = new ResourceLocation("frostrealm:textures/environment/frostrealm_sky.png");
    protected List<AuroraRenderer> auroras = new ArrayList<AuroraRenderer>();
    private static int skyDomeDispList = -1;
    private static Mesh starMesh;
    protected int ticks;

    public FrostSkyRenderer() {
        if (skyDomeDispList == -1) {
            skyDomeDispList = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)skyDomeDispList, (int)4864);
            GlStateManager.func_187415_K();
        }
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        this.renderSky(partialTicks, world, mc);
        this.renderAuroras(partialTicks, world, mc);
        this.resetRenderingStates();
    }

    protected void renderSky(float partialTicks, WorldClient world, Minecraft mc) {
        Vec3d skyColor = world.func_72833_a(mc.func_175606_aa(), partialTicks);
        float skyR = (float)skyColor.field_72450_a;
        float skyG = (float)skyColor.field_72448_b;
        float skyB = (float)skyColor.field_72449_c;
        float anaglyphR = 0.0f;
        float anaglyphG = 0.0f;
        float anaglyphB = 0.0f;
        if (mc.field_71474_y.field_74337_g) {
            anaglyphR = (skyR * 30.0f + skyG * 59.0f + skyB * 11.0f) / 100.0f;
            anaglyphG = (skyR * 30.0f + skyG * 70.0f) / 100.0f;
            anaglyphB = (skyR * 30.0f + skyB * 70.0f) / 100.0f;
            skyR = anaglyphR;
            skyG = anaglyphG;
            skyB = anaglyphB;
        }
        float invRainStrength = 1.0f - world.func_72867_j(partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        float starBrightness = (world.func_72880_h(partialTicks) + 0.5f) * invRainStrength * invRainStrength * invRainStrength;
        float fade = 1.0f;
        GlStateManager.func_179121_F();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        if (world.field_73011_w.func_76561_g()) {
            GlStateManager.func_179131_c((float)(skyR * 0.2f + 0.04f), (float)(skyG * 0.2f + 0.04f), (float)(skyB * 0.6f + 0.1f), (float)(starBrightness / 1.0f));
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179106_n();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.func_74518_a();
        GlStateManager.func_179132_a((boolean)false);
        mc.field_71446_o.func_110577_a(SKY_TEXTURE);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        for (int k1 = 0; k1 < 6; ++k1) {
            GlStateManager.func_179094_E();
            if (k1 == 1) {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (k1 == 2) {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (k1 == 3) {
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (k1 == 4) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (k1 == 5) {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b(-90.0, -40.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(-90.0, -40.0, 90.0).func_187315_a(0.0, 16.0).func_181675_d();
            bufferbuilder.func_181662_b(90.0, -40.0, 90.0).func_187315_a(16.0, 16.0).func_181675_d();
            bufferbuilder.func_181662_b(90.0, -40.0, -90.0).func_187315_a(16.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
    }

    protected void resetRenderingStates() {
        GlStateManager.func_179092_a((int)516, (float)0.5f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
    }

    protected void renderAuroras(float partialTicks, WorldClient world, Minecraft mc) {
        Random rand = world.field_73012_v;
        if (!this.auroras.isEmpty()) {
            GlStateManager.func_179106_n();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)(-mc.func_175598_ae().field_78731_m), (double)0.0);
            for (AuroraRenderer aurora : this.auroras) {
                aurora.render(partialTicks, 1.0f);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179141_d();
            GlStateManager.func_179132_a((boolean)true);
        }
    }

    public void update(WorldClient world, Minecraft mc) {
        ++this.ticks;
        Random rand = world.field_73012_v;
        double newAuroraPosX = mc.field_71439_g.field_70165_t + (double)rand.nextInt(220) - 110.0;
        double newAuroraPosZ = mc.field_71439_g.field_70161_v + (double)rand.nextInt(220) - 110.0;
        double newAuroraPosY = 180.0;
        double minDist = 0.0;
        for (AuroraRenderer aurora : this.auroras) {
            double dist = aurora.getDistance(newAuroraPosX, newAuroraPosY, newAuroraPosZ);
            if (!(dist < minDist) && minDist != 0.0) continue;
            minDist = dist;
        }
        if (this.auroras.isEmpty()) {
            for (int k1 = 0; k1 < 4; ++k1) {
                double newAuroraPosX2 = mc.field_71439_g.field_70165_t + (double)rand.nextInt(120) - (double)rand.nextInt(120);
                double newAuroraPosZ2 = mc.field_71439_g.field_70161_v + (double)rand.nextInt(120) - (double)rand.nextInt(120);
                ArrayList<Vector4f> gradients = new ArrayList<Vector4f>();
                gradients.add(new Vector4f(0.0f, 1.0f, 0.0f, 0.01f));
                gradients.add(new Vector4f(0.0f, 1.0f, 0.0f, 0.15f));
                gradients.add(new Vector4f(0.0f, 1.0f, 0.8f, 0.8f));
                gradients.add(new Vector4f(0.0f, 0.7f, 1.0f, 0.15f));
                gradients.add(new Vector4f(0.0f, 0.4f, 1.0f, 0.01f));
                this.auroras.add(new AuroraRenderer(newAuroraPosX2, newAuroraPosY + (double)rand.nextInt(60), newAuroraPosZ2, new Vector2d((double)(rand.nextFloat() * 2.0f - 1.0f), (double)(rand.nextFloat() * 2.0f - 1.0f)), rand.nextInt(40) + 15, gradients));
            }
        }
        Iterator<AuroraRenderer> auroraIT = this.auroras.iterator();
        while (auroraIT.hasNext()) {
            AuroraRenderer aurora = auroraIT.next();
            if (aurora.isRemoved()) {
                auroraIT.remove();
                continue;
            }
            aurora.update();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            FrostSkyRenderer skyRenderer = FrostRealmWorldProvider.getFrostSkyRenderer();
            if (world != null && skyRenderer != null) {
                skyRenderer.update(world, Minecraft.func_71410_x());
            }
        }
    }
}

