/*
 * Decompiled with CFR 0.152.
 */
package teamfrost.frostrealm.mob;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import teamfrost.frostrealm.api.IIcyMob;
import teamfrost.frostrealm.handler.IcySounds;
import teamfrost.frostrealm.mob.shotentity.EntityIceBall;

public class EntityIcyCore
extends EntityMob
implements IIcyMob {
    private static final ResourceLocation LOOT_TABLE = new ResourceLocation("frostrealm", "entitys/icycore");
    private float heightOffset = 0.7f;
    private int heightOffsetUpdateTime;

    public EntityIcyCore(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 1.1f);
        this.field_70728_aV = 12;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIIceballAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySnowman.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(3.0);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    protected SoundEvent func_184639_G() {
        return IcySounds.ICYCORE_AMBIENT;
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SNOW_SHOVEL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        super.func_70636_d();
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.6f;
    }

    protected void func_70619_bc() {
        EntityLivingBase entitylivingbase = this.func_70638_az();
        if (entitylivingbase != null) {
            if (entitylivingbase != null && entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() > this.field_70163_u + (double)this.func_70047_e() + (double)this.heightOffset) {
                this.field_70181_x += ((double)0.3f - this.field_70181_x) * (double)0.3f;
                this.field_70160_al = true;
            }
            --this.heightOffsetUpdateTime;
            if (this.heightOffsetUpdateTime <= 0) {
                this.heightOffsetUpdateTime = 100;
                this.heightOffset = 0.7f + (float)this.field_70146_Z.nextGaussian() * 3.0f;
            }
        }
        super.func_70619_bc();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(20) == 0 && super.func_70601_bi();
    }

    public class AIIceballAttack
    extends EntityAIBase {
        private final EntityIcyCore core;
        private int attackStep;
        private int attackTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;

        public AIIceballAttack(EntityIcyCore coreIn) {
            this.core = coreIn;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.core.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75246_d() {
            --this.attackTime;
            EntityLivingBase entitylivingbase = this.core.func_70638_az();
            double d0 = this.core.func_70068_e((Entity)entitylivingbase);
            if (d0 < 4.0) {
                if (this.attackTime <= 0) {
                    this.attackTime = 20;
                    this.core.func_70652_k((Entity)entitylivingbase);
                }
            } else if (d0 < this.getFollowDistance() * this.getFollowDistance()) {
                if (d0 > 54.0) {
                    this.core.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
                } else if (d0 < 38.0) {
                    this.core.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                }
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep == 1) {
                        this.attackTime = 60;
                    } else if (this.attackStep <= 4) {
                        this.attackTime = 6;
                    } else {
                        this.attackTime = 100;
                        this.attackStep = 0;
                    }
                    if (this.attackStep > 1) {
                        float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                        for (int i = 0; i < 1; ++i) {
                            EntityIceBall snowball = new EntityIceBall(this.core.field_70170_p, (EntityLivingBase)this.core);
                            double d4 = entitylivingbase.field_70165_t - this.core.field_70165_t;
                            double d1 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 3.0f) - snowball.field_70163_u;
                            double d2 = entitylivingbase.field_70161_v - this.core.field_70161_v;
                            float f2 = MathHelper.func_76133_a((double)(d4 * d4 + d2 * d2)) * 0.2f;
                            snowball.func_70186_c(d4, d1 + (double)f2, d2, 1.6f, 0.0f);
                            this.core.func_184185_a(SoundEvents.field_187805_fE, 1.0f, 1.0f / (this.core.func_70681_au().nextFloat() * 0.4f + 0.8f));
                            this.core.field_70170_p.func_72838_d((Entity)snowball);
                        }
                    }
                }
                this.core.func_70671_ap().func_75651_a((Entity)entitylivingbase, 10.0f, 10.0f);
            } else {
                this.core.func_70661_as().func_75499_g();
                this.core.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
            }
            super.func_75246_d();
        }

        private double getFollowDistance() {
            IAttributeInstance iattributeinstance = this.core.func_110148_a(SharedMonsterAttributes.field_111265_b);
            return iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
        }
    }
}

