/*
 * Decompiled with CFR 0.152.
 */
package teamfrost.frostrealm.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;

public class QuadBuilder {
    public final VertexFormat format;
    private TextureAtlasSprite sprite;
    private boolean switchUV = false;
    private TRSRTransformation transformation;
    private float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private Vec3d normal;
    private int tintIndex = -1;
    private EnumFacing cullFace;
    private EnumFacing orientation;
    private boolean diffuseLighting = true;
    private final List<Vertex> vertices;
    private int blockLight = -1;
    private int skyLight = -1;
    private boolean hasLightmapElement;

    public QuadBuilder(VertexFormat format) {
        this(50, format);
    }

    public QuadBuilder(int vertices, VertexFormat format) {
        this.vertices = new ArrayList<Vertex>(vertices);
        this.format = new VertexFormat(format);
        this.hasLightmapElement = this.format.func_177343_g().contains(DefaultVertexFormats.field_181716_p);
    }

    public QuadBuilder setCullFace(@Nullable EnumFacing cullFace) {
        this.cullFace = cullFace;
        return this;
    }

    public QuadBuilder setOrientation(@Nullable EnumFacing orientation) {
        this.orientation = orientation;
        return this;
    }

    public QuadBuilder setDiffuseLighting(boolean diffuseLighting) {
        this.diffuseLighting = diffuseLighting;
        return this;
    }

    public QuadBuilder setTintIndex(int index) {
        this.tintIndex = index;
        return this;
    }

    public QuadBuilder setLightmap(int blockLight, int skyLight) {
        this.removeLightmap();
        return this;
    }

    public QuadBuilder removeLightmap() {
        this.blockLight = -1;
        this.skyLight = -1;
        return this;
    }

    public QuadBuilder setNormal(Vec3d normal) {
        this.normal = normal;
        return this;
    }

    public Vec3d getNormal() {
        return this.normal;
    }

    public QuadBuilder setColor(float r, float g, float b, float a) {
        this.color = new float[4];
        this.color[0] = r;
        this.color[1] = g;
        this.color[2] = b;
        this.color[3] = a;
        return this;
    }

    public float[] getColor() {
        return this.color;
    }

    public QuadBuilder setTransformation(TRSRTransformation transformation) {
        this.transformation = transformation;
        return this;
    }

    public TRSRTransformation getTransformation() {
        return this.transformation;
    }

    public QuadBuilder setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
        return this;
    }

    public TextureAtlasSprite getSprite() {
        return this.sprite;
    }

    public QuadBuilder setSwitchUV(boolean switchUV) {
        this.switchUV = switchUV;
        return this;
    }

    public boolean getSwitchUV() {
        return this.switchUV;
    }

    public QuadBuilder addVertex(double x, double y, double z, float u, float v) {
        return this.addVertex(new Vec3d(x, y, z), u, v);
    }

    public QuadBuilder addVertex(double x, double y, double z) {
        return this.addVertex(new Vec3d(x, y, z));
    }

    public QuadBuilder addVertex(Vec3d pos, float u, float v) {
        this.vertices.add(new Vertex(pos, u, v, this.sprite, this.switchUV, this.transformation, this.color, this.normal, this.blockLight, this.skyLight, this.tintIndex, this.cullFace, this.orientation, this.diffuseLighting));
        return this;
    }

    public QuadBuilder addVertex(Vec3d pos) {
        this.vertices.add(new Vertex(pos, 0.0f, 0.0f, this.sprite, this.switchUV, this.transformation, this.color, this.normal, this.blockLight, this.skyLight, this.tintIndex, this.cullFace, this.orientation, this.diffuseLighting));
        return this;
    }

    public QuadBuilder addVertexInferUV(double x, double y, double z) {
        return this.addVertexInferUV(new Vec3d(x, y, z));
    }

    public QuadBuilder addVertexInferUV(Vec3d pos) {
        int relIndex = this.vertices.size() % 4;
        float u = 0.0f;
        float v = 0.0f;
        switch (relIndex) {
            default: {
                break;
            }
            case 1: {
                v = 16.0f;
                break;
            }
            case 2: {
                u = 16.0f;
                v = 16.0f;
                break;
            }
            case 3: {
                u = 16.0f;
            }
        }
        this.vertices.add(new Vertex(pos, u, v, this.sprite, this.switchUV, this.transformation, this.color, this.normal, this.blockLight, this.skyLight, this.tintIndex, this.cullFace, this.orientation, this.diffuseLighting));
        return this;
    }

    public Quads build(@Nullable Consumer<UnpackedBakedQuad.Builder> builderConsumer) {
        if (this.vertices.size() % 4 != 0) {
            throw new RuntimeException("Invalid number of vertices");
        }
        ImmutableList.Builder nonCulledBuilder = ImmutableList.builder();
        EnumMap<EnumFacing, ImmutableList.Builder> builders = new EnumMap<EnumFacing, ImmutableList.Builder>(EnumFacing.class);
        EnumMap<EnumFacing, ImmutableList> quads = new EnumMap<EnumFacing, ImmutableList>(EnumFacing.class);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            builders.put(face, ImmutableList.builder());
        }
        for (int i = 0; i < this.vertices.size(); i += 4) {
            Vertex vert1 = this.vertices.get(i);
            Vertex vert2 = this.vertices.get(i + 1);
            Vertex vert3 = this.vertices.get(i + 2);
            Vertex vert4 = this.vertices.get(i + 3);
            BakedQuad quad = this.createQuad(this.format, vert1, vert2, vert3, vert4, builderConsumer);
            if (vert4.cullFace == null) {
                nonCulledBuilder.add((Object)quad);
                continue;
            }
            ((ImmutableList.Builder)builders.get(quad.func_178210_d())).add((Object)quad);
        }
        this.vertices.clear();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            quads.put(face, ((ImmutableList.Builder)builders.get(face)).build());
        }
        return new Quads(quads, nonCulledBuilder.build());
    }

    public Quads build() {
        return this.build(null);
    }

    private void putVertex(VertexFormat format, UnpackedBakedQuad.Builder builder, Vec3d quadNormal, Vertex vert) {
        boolean hasTransform = vert.transformation != null && !vert.transformation.equals((Object)TRSRTransformation.identity());
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    float[] positionData = new float[]{(float)vert.pos.field_72450_a, (float)vert.pos.field_72448_b, (float)vert.pos.field_72449_c, 1.0f};
                    if (hasTransform) {
                        Vector4f vec = new Vector4f(positionData);
                        vert.transformation.getMatrix().transform((Tuple4f)vec);
                        vec.get(positionData);
                    }
                    builder.put(e, positionData);
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, vert.color);
                    continue block6;
                }
                case NORMAL: {
                    float[] normalData = vert.normal != null ? new float[]{(float)vert.normal.field_72450_a, (float)vert.normal.field_72448_b, (float)vert.normal.field_72449_c, 0.0f} : new float[]{(float)quadNormal.field_72450_a, (float)quadNormal.field_72448_b, (float)quadNormal.field_72449_c, 0.0f};
                    if (hasTransform) {
                        Vector4f vec = new Vector4f(normalData);
                        Matrix4f matrix = vert.transformation.getMatrix();
                        matrix.invert();
                        matrix.transpose();
                        matrix.transform((Tuple4f)vec);
                        vec.get(normalData);
                    }
                    float dx = normalData[0];
                    float dy = normalData[1];
                    float dz = normalData[2];
                    float len = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
                    normalData[0] = dx / len;
                    normalData[1] = dy / len;
                    normalData[2] = dz / len;
                    normalData[3] = 0.0f;
                    builder.put(e, normalData);
                    continue block6;
                }
                case UV: {
                    if (format.func_177348_c(e).func_177369_e() == 0) {
                        float u = vert.u;
                        float v = vert.v;
                        if (vert.sprite != null) {
                            float pu = u;
                            float pv = v;
                            u = vert.sprite.func_94214_a(vert.switchUV ? (double)pv : (double)pu);
                            v = vert.sprite.func_94207_b(vert.switchUV ? (double)pu : (double)pv);
                        }
                        builder.put(e, new float[]{u, v, vert.switchUV ? 1.0f : 0.0f, vert.switchUV ? 0.0f : 1.0f});
                        continue block6;
                    }
                    if (vert.blockLight >= 0 && vert.skyLight >= 0 && format.func_177348_c(e).func_177369_e() == 1) {
                        builder.put(e, new float[]{(float)vert.blockLight * 32.0f / 65535.0f, (float)vert.skyLight * 32.0f / 65535.0f});
                        continue block6;
                    }
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    private BakedQuad createQuad(VertexFormat format, Vertex vert1, Vertex vert2, Vertex vert3, Vertex vert4, @Nullable Consumer<UnpackedBakedQuad.Builder> quadConsumer) {
        Vec3d quadNormal = null;
        if (vert1.normal == null || vert2.normal == null || vert3.normal == null || vert4.normal == null) {
            Vec3d[] verts = new Vec3d[]{vert1.pos, vert2.pos, vert3.pos, vert4.pos};
            for (int i = 0; i < 4; ++i) {
                Vec3d prev = verts[i];
                Vec3d corner = verts[(i + 1) % 4];
                Vec3d next = verts[(i + 2) % 4];
                if (corner.equals((Object)next) || corner.equals((Object)prev)) continue;
                quadNormal = prev.func_178788_d(corner).func_72431_c(next.func_178788_d(corner)).func_186678_a(-1.0).func_72432_b();
                break;
            }
            if (quadNormal == null) {
                quadNormal = new Vec3d(0.0, 0.0, 0.0);
            }
        }
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(vert4.tintIndex);
        if (vert4.orientation != null) {
            builder.setQuadOrientation(vert4.orientation);
        } else {
            builder.setQuadOrientation(EnumFacing.func_176737_a((float)((float)quadNormal.field_72450_a), (float)((float)quadNormal.field_72448_b), (float)((float)quadNormal.field_72449_c)));
        }
        builder.setApplyDiffuseLighting(vert4.diffuse);
        builder.setTexture(vert4.sprite);
        this.putVertex(format, builder, quadNormal, vert1);
        this.putVertex(format, builder, quadNormal, vert2);
        this.putVertex(format, builder, quadNormal, vert3);
        this.putVertex(format, builder, quadNormal, vert4);
        if (quadConsumer != null) {
            quadConsumer.accept(builder);
        }
        return builder.build();
    }

    public static final class Quads {
        public final Map<EnumFacing, ImmutableList<BakedQuad>> culledQuads;
        public final ImmutableList<BakedQuad> nonCulledQuads;

        private Quads(Map<EnumFacing, ImmutableList<BakedQuad>> culledQuads, ImmutableList<BakedQuad> nonCulledQuads) {
            this.culledQuads = culledQuads;
            this.nonCulledQuads = nonCulledQuads;
        }
    }

    static class Vertex {
        public final Vec3d pos;
        public final float u;
        public final float v;
        public final TextureAtlasSprite sprite;
        public final boolean switchUV;
        public final TRSRTransformation transformation;
        public final float[] color;
        public final Vec3d normal;
        public final int blockLight;
        public final int skyLight;
        public final int tintIndex;
        public final EnumFacing cullFace;
        public final EnumFacing orientation;
        public final boolean diffuse;

        private Vertex(Vec3d pos, float u, float v, TextureAtlasSprite sprite, boolean switchUV, TRSRTransformation transformation, float[] color, Vec3d normal, int blockLight, int skyLight, int tintIndex, EnumFacing cullFace, EnumFacing orientation, boolean diffuse) {
            this.pos = pos;
            this.u = u;
            this.v = v;
            this.sprite = sprite;
            this.switchUV = switchUV;
            this.transformation = transformation;
            this.color = color;
            this.normal = normal;
            this.blockLight = blockLight;
            this.skyLight = skyLight;
            this.tintIndex = tintIndex;
            this.cullFace = cullFace;
            this.orientation = orientation;
            this.diffuse = diffuse;
        }
    }
}

