/*
 * Decompiled with CFR 0.152.
 */
package teamfrost.frostrealm.util;

public class TextureAtlasHelper {
    private final float horizontalSegments;
    private final float verticalSegments;
    private final float horizontalPadding;
    private final float verticalPadding;

    public TextureAtlasHelper(int texWidth, int texHeight, int segmentWidth, int segmentHeight, int horizontalPadding, int verticalPadding) {
        this.horizontalSegments = (float)texWidth / (float)segmentWidth;
        this.verticalSegments = (float)texHeight / (float)segmentHeight;
        this.horizontalPadding = (float)horizontalPadding / (float)texWidth;
        this.verticalPadding = (float)verticalPadding / (float)texHeight;
    }

    public TextureAtlasHelper(int texSize, int segmentSize, int padding) {
        this(texSize, texSize, segmentSize, segmentSize, padding, padding);
    }

    public float[][] getUVs(int segment) {
        float[][] ret = new float[2][2];
        float diffU = 1.0f;
        float diffV = 1.0f;
        float segmentX = segment % (int)this.horizontalSegments;
        float segmentY = segment / (int)this.verticalSegments;
        float relU = segmentX / this.horizontalSegments;
        float relV = segmentY / this.verticalSegments;
        float segmentMinU = diffU * (relU + this.horizontalPadding);
        float segmentMinV = diffV * (relV + this.verticalPadding);
        float segmentMaxU = diffU * (relU + 1.0f / this.horizontalSegments - this.horizontalPadding);
        float segmentMaxV = diffV * (relV + 1.0f / this.verticalSegments - this.verticalPadding);
        ret[0][0] = segmentMinU;
        ret[0][1] = segmentMinV;
        ret[1][0] = segmentMaxU;
        ret[1][1] = segmentMaxV;
        return ret;
    }

    public float[][] getInterpolatedUVs(int segment, float umin, float vmin, float umax, float vmax) {
        float[][] ret = new float[2][2];
        float[][] UVs = this.getUVs(segment);
        float uDiff = UVs[1][0] - UVs[0][0];
        float vDiff = UVs[1][1] - UVs[0][1];
        ret[0][0] = UVs[0][0] + uDiff * umin;
        ret[0][1] = UVs[0][1] + vDiff * vmin;
        ret[1][0] = UVs[0][0] + uDiff * umax;
        ret[1][1] = UVs[0][1] + vDiff * vmax;
        return ret;
    }
}

