/*
 * Decompiled with CFR 0.152.
 */
package teamfrost.frostrealm.world.dimension;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import teamfrost.frostrealm.handler.FrostrealmBlocks;
import teamfrost.frostrealm.world.dimension.gen.WorldGenIceIsland;
import teamfrost.frostrealm.world.structure.MapGenSkeltonIgloo;

public class ChunkGeneratorFrostRealm
implements IChunkGenerator {
    private static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    private static final IBlockState Water = FrostrealmBlocks.FROST_WATER.func_176223_P();
    private static final IBlockState IceStone = FrostrealmBlocks.FRIGID_STONE.func_176223_P();
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    private final boolean mapFeaturesEnabled;
    private final Random rand;
    private World world;
    private final NoiseGeneratorOctaves minLimitPerlinNoise;
    private final NoiseGeneratorOctaves maxLimitPerlinNoise;
    private final NoiseGeneratorOctaves mainPerlinNoise;
    private final NoiseGeneratorOctaves noiseGen4;
    protected final NoiseGeneratorPerlin surfaceNoise;
    private final NoiseGeneratorOctaves depthNoise;
    private MapGenSkeltonIgloo mapGenSkeltonIgloo = new MapGenSkeltonIgloo();
    private Biome[] biomesForGeneration;
    private final double[] heightMap;
    private final float[] biomeWeights;
    private double[] mainNoiseRegion;
    private double[] minLimitRegion;
    private double[] maxLimitRegion;
    private double[] depthRegion;
    protected double[] depthBuffer = new double[256];
    private int chunkX = 0;
    private int chunkZ = 0;
    private final WorldGenIceIsland endIslands = new WorldGenIceIsland();
    private final WorldGenerator worldGenFrigid = new WorldGenMinable(FrostrealmBlocks.ASTRIUM_FRIGID_ORE.func_176223_P(), 8, (Predicate)BlockMatcher.func_177642_a((Block)FrostrealmBlocks.FRIGID_STONE));
    private final WorldGenerator worldGenCrystal = new WorldGenMinable(FrostrealmBlocks.FROST_CRYSTAL_ORE.func_176223_P(), 13, (Predicate)BlockMatcher.func_177642_a((Block)FrostrealmBlocks.FRIGID_STONE));

    public ChunkGeneratorFrostRealm(World worldIn, long seed) {
        this.mapFeaturesEnabled = worldIn.func_72912_H().func_76089_r();
        this.world = worldIn;
        this.rand = new Random(seed);
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.heightMap = new double[825];
        this.biomeWeights = new float[25];
        this.surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.biomeWeights[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
    }

    public void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)x, (int)z, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        double d0 = 0.03125;
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomesIn[j + i * 16];
                biome.func_180622_a(this.world, this.rand, primer, x * 16 + i, z * 16 + j, this.depthBuffer[j + i * 16]);
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.chunkX = x;
        this.chunkZ = z;
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.setBlocksInChunk(x, z, chunkprimer);
        this.buildSurfaces(chunkprimer);
        this.setBedRock(chunkprimer);
        if (this.mapFeaturesEnabled) {
            // empty if block
        }
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void setBedRock(ChunkPrimer primer) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                boolean k = true;
                int l = -1;
                Biome biome = this.biomesForGeneration[j + i * 16];
                IBlockState iblockstate2 = primer.func_177856_a(i, 1, j);
                if (iblockstate2.func_177230_c() != FrostrealmBlocks.FRIGID_STONE) continue;
                primer.func_177855_a(i, 0, j, BEDROCK);
                primer.func_177855_a(i, 1, j, BEDROCK);
            }
        }
    }

    private void buildSurfaces(ChunkPrimer primer) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                boolean k = true;
                int l = -1;
                Biome biome = this.biomesForGeneration[j + i * 16];
                IBlockState iblockstate = biome.field_76752_A;
                IBlockState iblockstate1 = biome.field_76753_B;
                IBlockState desertstone = FrostrealmBlocks.FRIGID_STONE.func_176223_P();
                for (int i1 = 127; i1 >= 0; --i1) {
                    IBlockState iblockstate2 = primer.func_177856_a(i, i1, j);
                    if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                        l = -3;
                        continue;
                    }
                    if (iblockstate2.func_177230_c() != FrostrealmBlocks.FRIGID_STONE) continue;
                    if (l <= -1) {
                        if (l == -3) {
                            primer.func_177855_a(i, i1, j, iblockstate);
                        } else {
                            primer.func_177855_a(i, i1, j, iblockstate1);
                        }
                        ++l;
                        continue;
                    }
                    if (l <= 0) continue;
                    --l;
                    primer.func_177855_a(i, i1, j, desertstone);
                }
            }
        }
    }

    public void setBlocksInChunk(int x, int z, ChunkPrimer primer) {
        int seaLevel = 63;
        this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, 10, 10);
        this.generateHeightmap(x * 4, 0, z * 4);
        for (int k = 0; k < 4; ++k) {
            int l = k * 5;
            int i1 = (k + 1) * 5;
            for (int j1 = 0; j1 < 4; ++j1) {
                int k1 = (l + j1) * 33;
                int l1 = (l + j1 + 1) * 33;
                int i2 = (i1 + j1) * 33;
                int j2 = (i1 + j1 + 1) * 33;
                for (int k2 = 0; k2 < 32; ++k2) {
                    double d0 = 0.125;
                    double d1 = this.heightMap[k1 + k2];
                    double d2 = this.heightMap[l1 + k2];
                    double d3 = this.heightMap[i2 + k2];
                    double d4 = this.heightMap[j2 + k2];
                    double d5 = (this.heightMap[k1 + k2 + 1] - d1) * d0;
                    double d6 = (this.heightMap[l1 + k2 + 1] - d2) * d0;
                    double d7 = (this.heightMap[i2 + k2 + 1] - d3) * d0;
                    double d8 = (this.heightMap[j2 + k2 + 1] - d4) * d0;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double d15 = d10 - d16;
                            for (int k3 = 0; k3 < 4; ++k3) {
                                double d;
                                d15 += d16;
                                if (d > 0.0) {
                                    primer.func_177855_a(k * 4 + i3, k2 * 8 + l2, j1 * 4 + k3, FrostrealmBlocks.FRIGID_STONE.func_176223_P());
                                    continue;
                                }
                                if (k2 * 8 + l2 >= seaLevel) continue;
                                primer.func_177855_a(k * 4 + i3, k2 * 8 + l2, j1 * 4 + k3, FrostrealmBlocks.FROST_WATER.func_176223_P());
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private void generateHeightmap(int x, int zero, int z) {
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, x, z, 5, 5, 200.0, 200.0, 0.5);
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, x, zero, z, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        int terrainIndex = 0;
        int noiseIndex = 0;
        for (int ax = 0; ax < 5; ++ax) {
            for (int az = 0; az < 5; ++az) {
                float totalVariation = 0.0f;
                float totalHeight = 0.0f;
                float totalFactor = 0.0f;
                int two = 2;
                Biome biome = this.biomesForGeneration[ax + 2 + (az + 2) * 10];
                for (int ox = -two; ox <= two; ++ox) {
                    for (int oz = -two; oz <= two; ++oz) {
                        Biome biome1 = this.biomesForGeneration[ax + ox + 2 + (az + oz + 2) * 10];
                        float rootHeight = biome1.func_185355_j();
                        float heightVariation = biome1.func_185360_m();
                        float heightFactor = this.biomeWeights[ox + 2 + (oz + 2) * 5] / (rootHeight + 2.0f);
                        if (biome1.func_185355_j() > biome.func_185355_j()) {
                            heightFactor /= 2.0f;
                        }
                        totalVariation += heightVariation * heightFactor;
                        totalHeight += rootHeight * heightFactor;
                        totalFactor += heightFactor;
                    }
                }
                totalVariation /= totalFactor;
                totalHeight /= totalFactor;
                totalVariation = totalVariation * 0.9f + 0.1f;
                totalHeight = (totalHeight * 4.0f - 1.0f) / 8.0f;
                double terrainNoise = this.depthRegion[noiseIndex] / 8000.0;
                if (terrainNoise < 0.0) {
                    terrainNoise = -terrainNoise * 0.3;
                }
                if ((terrainNoise = terrainNoise * 3.0 - 2.0) < 0.0) {
                    if ((terrainNoise /= 2.0) < -1.0) {
                        terrainNoise = -1.0;
                    }
                    terrainNoise /= 1.4;
                    terrainNoise /= 2.0;
                } else {
                    if (terrainNoise > 1.0) {
                        terrainNoise = 1.0;
                    }
                    terrainNoise /= 8.0;
                }
                ++noiseIndex;
                double heightCalc = totalHeight;
                double variationCalc = totalVariation;
                heightCalc += terrainNoise * 0.2;
                heightCalc = heightCalc * 8.5 / 8.0;
                double d5 = 8.5 + heightCalc * 4.0;
                for (int ay = 0; ay < 33; ++ay) {
                    double d6 = ((double)ay - d5) * 12.0 * 128.0 / 256.0 / variationCalc;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.minLimitRegion[terrainIndex] / 512.0;
                    double d8 = this.maxLimitRegion[terrainIndex] / 512.0;
                    double d9 = (this.mainNoiseRegion[terrainIndex] / 10.0 + 1.0) / 2.0;
                    double terrainCalc = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (ay > 29) {
                        double d11 = (float)(ay - 29) / 3.0f;
                        terrainCalc = terrainCalc * (1.0 - d11) + -10.0 * d11;
                    }
                    this.heightMap[terrainIndex] = terrainCalc;
                    ++terrainIndex;
                }
            }
        }
    }

    public void func_185931_b(int x, int z) {
        int genZ;
        int genY;
        int genX;
        int i2;
        ChunkPrimer chunkprimer = new ChunkPrimer();
        BlockFalling.field_149832_M = true;
        BlockPos blockpos = new BlockPos(x * 16, 0, z * 16);
        ChunkPos chunkPos = new ChunkPos(this.chunkX, this.chunkZ);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long xSeed = this.rand.nextLong() / 2L * 2L + 1L;
        long zSeed = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)this.chunkX * xSeed + (long)this.chunkZ * zSeed ^ this.world.func_72905_C());
        int i = x * 16;
        int j = z * 16;
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)this.chunkX, (int)this.chunkZ, (boolean)false);
        if (this.mapFeaturesEnabled) {
            // empty if block
        }
        biome.func_180624_a(this.world, this.rand, blockpos);
        boolean doGen = TerrainGen.generateOre((World)this.world, (Random)this.rand, (WorldGenerator)this.worldGenCrystal, (BlockPos)blockpos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM);
        for (i2 = 0; doGen && i2 < 20; ++i2) {
            genX = this.rand.nextInt(16);
            genY = this.rand.nextInt(66) + 10;
            genZ = this.rand.nextInt(16);
            this.worldGenCrystal.func_180709_b(this.world, this.rand, blockpos.func_177982_a(genX, genY, genZ));
        }
        doGen = TerrainGen.generateOre((World)this.world, (Random)this.rand, (WorldGenerator)this.worldGenFrigid, (BlockPos)blockpos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM);
        for (i2 = 0; doGen && i2 < 18; ++i2) {
            genX = this.rand.nextInt(16);
            genY = this.rand.nextInt(50) + 10;
            genZ = this.rand.nextInt(16);
            this.worldGenFrigid.func_180709_b(this.world, this.rand, blockpos.func_177982_a(genX, genY, genZ));
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.rand);
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunk, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        if (!this.mapFeaturesEnabled) {
            return false;
        }
        return false;
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        if (!this.mapFeaturesEnabled) {
            return null;
        }
        return null;
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
        if (this.mapFeaturesEnabled) {
            // empty if block
        }
    }
}

