/*
 * Decompiled with CFR 0.152.
 */
package teamfrost.frostrealm.world.dimension;

import net.minecraft.client.audio.MusicTicker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamfrost.frostrealm.FrostRealmCore;
import teamfrost.frostrealm.client.FrostMusic;
import teamfrost.frostrealm.client.render.EmptyRenderer;
import teamfrost.frostrealm.client.sky.FrostSkyRenderer;
import teamfrost.frostrealm.world.biome.FrostRealmBiomeProvider;
import teamfrost.frostrealm.world.dimension.ChunkGeneratorFrostRealm;

public class FrostRealmWorldProvider
extends WorldProvider {
    private final Vec3d fogColor = new Vec3d(0.0, 0.0, 0.3);
    private IChunkGenerator chunkGenerator;
    @SideOnly(value=Side.CLIENT)
    private static FrostSkyRenderer skyRenderer;

    public double getBrightness() {
        return 0.06;
    }

    protected void func_76556_a() {
        float f = (float)this.getBrightness();
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.field_76573_f[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
    }

    protected void func_76572_b() {
        this.chunkGenerator = new ChunkGeneratorFrostRealm(this.field_76579_a, this.getSeed());
        this.field_76578_c = new FrostRealmBiomeProvider(this.field_76579_a);
    }

    public IChunkGenerator func_186060_c() {
        return this.chunkGenerator;
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        return 0.625f;
    }

    public Vec3d func_76562_b(float p_76562_1_, float p_76562_2_) {
        return this.fogColor;
    }

    @SideOnly(value=Side.CLIENT)
    public MusicTicker.MusicType getMusicType() {
        return FrostMusic.FrostCalm;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        if (super.getCloudRenderer() == null) {
            this.setCloudRenderer(EmptyRenderer.INSTANCE);
        }
        return super.getCloudRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public static FrostSkyRenderer getFrostSkyRenderer() {
        if (skyRenderer == null) {
            skyRenderer = new FrostSkyRenderer();
        }
        return skyRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        return FrostRealmWorldProvider.getFrostSkyRenderer();
    }

    public boolean func_76567_e() {
        return true;
    }

    public BiomeProvider func_177499_m() {
        return this.field_76578_c;
    }

    public double getMovementFactor() {
        return 1.0;
    }

    public boolean shouldMapSpin(String entity, double x, double z, double rotation) {
        return true;
    }

    public WorldProvider.WorldSleepResult canSleepAt(EntityPlayer player, BlockPos pos) {
        return WorldProvider.WorldSleepResult.ALLOW;
    }

    public boolean canDoLightning(Chunk chunk) {
        return false;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return true;
    }

    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        return this.fogColor;
    }

    public DimensionType func_186058_p() {
        return FrostRealmCore.FrostRealm_WORLD;
    }
}

