/*
 * Decompiled with CFR 0.152.
 */
package teamfrost.frostrealm.world.dimension.gen;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import teamfrost.frostrealm.handler.FrostrealmBlocks;

public class GenFrozenTree
extends WorldGenAbstractTree {
    private static final IBlockState DEFAULT_TRUNK = FrostrealmBlocks.FROZEN_LOG.func_176223_P();
    private static final IBlockState DEFAULT_LEAF = FrostrealmBlocks.FROZEN_LEAVES.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.FALSE);
    private final int minTreeHeight;
    private final IBlockState metaWood;
    private final IBlockState metaLeaves;

    public GenFrozenTree(boolean p_i2027_1_) {
        this(p_i2027_1_, 6, DEFAULT_TRUNK, DEFAULT_LEAF);
    }

    public GenFrozenTree(boolean notify, int minTreeHeightIn, IBlockState woodMeta, IBlockState p_i46446_4_) {
        super(notify);
        this.minTreeHeight = minTreeHeightIn;
        this.metaWood = woodMeta;
        this.metaLeaves = p_i46446_4_;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(4) + this.minTreeHeight;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.func_72800_K()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            IBlockState state = worldIn.func_180495_p(position.func_177977_b());
            if (state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, position.func_177977_b(), EnumFacing.UP, (IPlantable)FrostrealmBlocks.FROZEN_SAPLING) && position.func_177956_o() < worldIn.func_72800_K() - i - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, position.func_177977_b(), position);
                int k2 = 3;
                boolean l2 = false;
                for (int i3 = position.func_177956_o() - 3 + i; i3 <= position.func_177956_o() + i; ++i3) {
                    int i4 = i3 - (position.func_177956_o() + i);
                    int j1 = 1 - i4 / 2;
                    for (int k1 = position.func_177958_n() - j1; k1 <= position.func_177958_n() + j1; ++k1) {
                        int l1 = k1 - position.func_177958_n();
                        for (int i2 = position.func_177952_p() - j1; i2 <= position.func_177952_p() + j1; ++i2) {
                            BlockPos blockpos;
                            int j2 = i2 - position.func_177952_p();
                            if (Math.abs(l1) == j1 && Math.abs(j2) == j1 && (rand.nextInt(2) == 0 || i4 == 0) || !(state = worldIn.func_180495_p(blockpos = new BlockPos(k1, i3, i2))).func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, blockpos) && state.func_185904_a() != Material.field_151582_l) continue;
                            this.func_175903_a(worldIn, blockpos, this.metaLeaves);
                        }
                    }
                }
                for (int j3 = 0; j3 < i; ++j3) {
                    BlockPos upN = position.func_177981_b(j3);
                    state = worldIn.func_180495_p(upN);
                    if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, upN) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, upN) && state.func_185904_a() != Material.field_151582_l) continue;
                    this.func_175903_a(worldIn, position.func_177981_b(j3), this.metaWood);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

