/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.config;

import eu.pb4.graves.config.data.ConfigData;
import eu.pb4.graves.grave.GravesLookType;
import eu.pb4.placeholders.TextParser;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;

public final class Config {
    public final ConfigData configData;
    public final GravesLookType style;
    public final List<class_2561> hologramProtectedText;
    public final List<class_2561> hologramText;
    public final class_2561 graveTitle;
    public final class_2561 guiTitle;
    public final List<class_2561> guiProtectedText;
    public final List<class_2561> guiText;
    public final class_2561 noLongerProtectedMessage;
    public final class_2561 graveExpiredMessage;
    public final class_2561 graveBrokenMessage;
    public final class_2561 createdGraveMessage;
    public final class_2561 creationFailedGraveMessage;
    public final class_2561 creationFailedPvPGraveMessage;

    public Config(ConfigData data) {
        this.configData = data;
        this.style = GravesLookType.byName(this.configData.graveType);
        this.hologramProtectedText = Config.parse(data.hologramProtectedText);
        this.hologramText = Config.parse(data.hologramText);
        this.graveTitle = TextParser.parse((String)data.graveTitle);
        this.guiTitle = TextParser.parse((String)data.guiTitle);
        this.guiProtectedText = Config.parse(data.guiProtectedText);
        this.guiText = Config.parse(data.guiText);
        this.noLongerProtectedMessage = TextParser.parse((String)data.noLongerProtectedMessage);
        this.graveExpiredMessage = TextParser.parse((String)data.graveExpiredMessage);
        this.graveBrokenMessage = TextParser.parse((String)data.graveBrokenMessage);
        this.createdGraveMessage = TextParser.parse((String)data.createdGraveMessage);
        this.creationFailedGraveMessage = TextParser.parse((String)data.creationFailedGraveMessage);
        this.creationFailedPvPGraveMessage = TextParser.parse((String)data.creationFailedPvPGraveMessage);
    }

    public String getFormattedTime(long time) {
        if (time != Long.MAX_VALUE) {
            long seconds = time % 60L;
            long minutes = time / 60L % 60L;
            long hours = time / 3600L % 24L;
            long days = time / 86400L % 365L;
            long years = time / 31536000L;
            StringBuilder builder = new StringBuilder();
            if (years > 0L) {
                builder.append(years + this.configData.yearsText);
            }
            if (days > 0L) {
                builder.append(days + this.configData.daysText);
            }
            if (hours > 0L) {
                builder.append(hours + this.configData.hoursText);
            }
            if (minutes > 0L) {
                builder.append(minutes + this.configData.minutesText);
            }
            if (seconds >= 0L) {
                builder.append(seconds + this.configData.secondsText);
            } else {
                builder.append(time + this.configData.secondsText);
            }
            return builder.toString();
        }
        return this.configData.neverExpires;
    }

    public static List<class_2561> parse(List<String> strings) {
        ArrayList<class_2561> texts = new ArrayList<class_2561>();
        for (String line : strings) {
            texts.add(TextParser.parse((String)line));
        }
        return texts;
    }
}

