/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.pb4.graves.GravesMod;
import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.data.ConfigData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.IOUtils;

public class ConfigManager {
    public static final int VERSION = 1;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Config CONFIG = new Config(new ConfigData());
    private static boolean ENABLED = false;

    public static Config getConfig() {
        return CONFIG;
    }

    public static boolean isEnabled() {
        return ENABLED;
    }

    public static boolean loadConfig() {
        ENABLED = false;
        CONFIG = null;
        try {
            ConfigData config;
            File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "universal-graves.json");
            if (configFile.exists()) {
                String json = IOUtils.toString((Reader)new InputStreamReader((InputStream)new FileInputStream(configFile), "UTF-8"));
                config = (ConfigData)GSON.fromJson(json, ConfigData.class);
            } else {
                config = new ConfigData();
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), "UTF-8"));
            writer.write(GSON.toJson((Object)config));
            writer.close();
            CONFIG = new Config(config);
            ENABLED = true;
        }
        catch (IOException exception) {
            ENABLED = false;
            GravesMod.LOGGER.error("Something went wrong while reading config!");
            exception.printStackTrace();
        }
        return ENABLED;
    }
}

