/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.grave;

import com.mojang.authlib.GameProfile;
import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.grave.GraveBlock;
import eu.pb4.graves.grave.GraveInfo;
import eu.pb4.graves.grave.GraveManager;
import eu.pb4.graves.other.ImplementedInventory;
import eu.pb4.holograms.api.holograms.WorldHologram;
import eu.pb4.placeholders.PlaceholderAPI;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1278;
import net.minecraft.class_1303;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class GraveBlockEntity
extends class_2586
implements ImplementedInventory,
class_1278 {
    public static class_2591<GraveBlockEntity> BLOCK_ENTITY_TYPE;
    public WorldHologram hologram = null;
    public class_2371<class_1799> stacks = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    public GraveInfo info = new GraveInfo();
    public class_2680 replacedBlockState = class_2246.field_10124.method_9564();

    public GraveBlockEntity(class_2338 pos, class_2680 state) {
        super(BLOCK_ENTITY_TYPE, pos, state);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.stacks;
    }

    public void setGrave(GameProfile profile, Collection<class_1799> itemStacks, int experience, class_2561 deathCause, class_2680 blockState) {
        GraveManager.INSTANCE.remove(this.info);
        this.stacks = class_2371.method_10213((int)itemStacks.size(), (Object)class_1799.field_8037);
        for (class_1799 stack : itemStacks) {
            this.addStack(stack);
        }
        this.replacedBlockState = blockState;
        this.info = new GraveInfo(profile, this.field_11867, Objects.requireNonNull(this.method_10997()).method_27983().method_29177(), System.currentTimeMillis() / 1000L, experience, itemStacks.size(), deathCause);
        GraveManager.INSTANCE.add(this.info);
        this.method_5431();
    }

    public class_2487 method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.stacks);
        nbt.method_10566("GraveInfo", (class_2520)this.info.writeNbt(new class_2487()));
        nbt.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)this.replacedBlockState));
        return nbt;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        try {
            class_1262.method_5429((class_2487)nbt, this.stacks);
            this.info.readNbt(nbt.method_10562("GraveInfo"));
            this.replacedBlockState = class_2512.method_10681((class_2487)((class_2487)Objects.requireNonNull(nbt.method_10580("BlockState"))));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onBroken() {
        if (this.hologram != null) {
            this.hologram.hide();
        }
        this.hologram = null;
        Config config = ConfigManager.getConfig();
        class_2561 text = null;
        boolean shouldBreak = this.info.shouldBreak();
        if (!shouldBreak) {
            if (config.configData.displayGraveBrokenMessage) {
                text = config.graveBrokenMessage;
            }
        } else if (config.configData.displayGraveExpiredMessage) {
            text = config.graveExpiredMessage;
        }
        if (text != null) {
            assert (this.field_11863 != null);
            class_3222 player = Objects.requireNonNull(this.field_11863.method_8503()).method_3760().method_14602(this.info.gameProfile.getId());
            if (player != null) {
                player.method_14254(PlaceholderAPI.parsePredefinedText((class_2561)text, (Pattern)PlaceholderAPI.PREDEFINED_PLACEHOLDER_PATTERN, this.info.getPlaceholders()), class_2556.field_11735, class_156.field_25140);
            }
        }
        GraveManager.INSTANCE.remove(this.info);
        if (config.configData.dropItemsAfterExpiring || !shouldBreak) {
            class_1264.method_5451((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1263)this);
            class_1303.method_31493((class_3218)((class_3218)this.field_11863), (class_243)class_243.method_24953((class_2382)this.method_11016()), (int)this.info.xp);
        }
    }

    public void method_11012() {
        if (this.hologram != null) {
            this.hologram.hide();
        }
        this.hologram = null;
        super.method_11012();
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
        GraveBlockEntity self;
        block16: {
            block15: {
                T t2 = t;
                if (!(t2 instanceof GraveBlockEntity)) break block15;
                self = (GraveBlockEntity)t2;
                if (!world.method_8608() && world.method_8510() % 5L == 0L) break block16;
            }
            return;
        }
        Config config = ConfigManager.getConfig();
        Map<String, class_2561> placeholders = self.info.getPlaceholders();
        if (config.configData.shouldBreak && self.info.shouldBreak()) {
            world.method_8652(pos, self.replacedBlockState, 3);
            return;
        }
        boolean isProtected = (Boolean)state.method_11654((class_2769)GraveBlock.IS_LOCKED);
        if (isProtected && !self.info.isProtected()) {
            class_3222 player;
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)GraveBlock.IS_LOCKED, (Comparable)Boolean.valueOf(false)));
            isProtected = false;
            if (config.configData.displayNoLongerProtectedMessage && (player = Objects.requireNonNull(world.method_8503()).method_3760().method_14602(self.info.gameProfile.getId())) != null) {
                player.method_14254(PlaceholderAPI.parsePredefinedText((class_2561)config.noLongerProtectedMessage, (Pattern)PlaceholderAPI.PREDEFINED_PLACEHOLDER_PATTERN, placeholders), class_2556.field_11735, class_156.field_25140);
            }
        }
        if (config.configData.hologram) {
            if (self.hologram == null) {
                self.hologram = new WorldHologram((class_3218)world, new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()).method_1031(0.5, 1.2, 0.5));
                self.hologram.show();
            }
            ArrayList<class_2561> texts = new ArrayList<class_2561>();
            for (class_2561 class_25612 : isProtected ? config.hologramProtectedText : config.hologramText) {
                texts.add(PlaceholderAPI.parsePredefinedText((class_2561)class_25612, (Pattern)PlaceholderAPI.PREDEFINED_PLACEHOLDER_PATTERN, placeholders));
            }
            int x = 0;
            for (class_2561 text : texts) {
                self.hologram.setText(x, text);
                ++x;
            }
            int n = self.hologram.getElements().size();
            if (x < n) {
                while (x < n) {
                    self.hologram.removeElement(x);
                    ++x;
                }
            }
        } else if (self.hologram != null) {
            self.hologram.hide();
            self.hologram = null;
        }
    }

    public int[] method_5494(class_2350 side) {
        return IntArrays.EMPTY_ARRAY;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }
}

