/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.grave;

import com.mojang.authlib.GameProfile;
import eu.pb4.graves.config.ConfigManager;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2350;
import net.minecraft.class_2435;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3708;

public enum GravesLookType {
    CHEST("chest", GravesLookType.getChestLike(class_2246.field_10034.method_9564(), class_2246.field_10380.method_9564())),
    BARREL("barrel", GravesLookType.getChestLike((class_2680)class_2246.field_16328.method_9564().method_11657((class_2769)class_3708.field_18006, (Comparable)Boolean.valueOf(true)), class_2246.field_16328.method_9564())),
    PLAYER_HEAD("player_head", new Converter(){

        @Override
        public class_2248 getBlock(boolean isLocked) {
            return class_2246.field_10432;
        }

        @Override
        public class_2680 getBlockState(int direction, boolean isLocked) {
            return (class_2680)this.getBlock(isLocked).method_9564().method_11657((class_2769)class_2435.field_11505, (Comparable)Integer.valueOf(direction));
        }

        @Override
        public class_2487 getNbtToSend(class_2487 nbt, int direction, boolean isLocked, GameProfile owner) {
            if (owner != null) {
                class_2487 nbtCompound = new class_2487();
                class_2512.method_10684((class_2487)nbtCompound, (GameProfile)owner);
                nbt.method_10566("SkullOwner", (class_2520)nbtCompound);
            }
            return nbt;
        }
    }),
    PRESET_HEAD("preset_head", new Converter(){

        @Override
        public class_2248 getBlock(boolean isLocked) {
            return class_2246.field_10432;
        }

        @Override
        public class_2680 getBlockState(int direction, boolean isLocked) {
            return (class_2680)this.getBlock(isLocked).method_9564().method_11657((class_2769)class_2435.field_11505, (Comparable)Integer.valueOf(direction));
        }

        @Override
        public class_2487 getNbtToSend(class_2487 nbt, int direction, boolean isLocked, GameProfile owner) {
            class_2487 skullOwner = new class_2487();
            class_2487 properties = new class_2487();
            class_2487 valueData = new class_2487();
            class_2499 textures = new class_2499();
            valueData.method_10582("Value", isLocked ? ConfigManager.getConfig().configData.lockedTexture : ConfigManager.getConfig().configData.unlockedTexture);
            textures.add((Object)valueData);
            properties.method_10566("textures", (class_2520)textures);
            skullOwner.method_10566("Id", (class_2520)class_2512.method_25929((UUID)class_156.field_25140));
            skullOwner.method_10566("Properties", (class_2520)properties);
            nbt.method_10566("SkullOwner", (class_2520)skullOwner);
            return nbt;
        }
    });

    public final String name;
    public final Converter converter;

    private GravesLookType(String name, Converter converter) {
        this.name = name;
        this.converter = converter;
    }

    public static GravesLookType byName(String name) {
        for (GravesLookType type : GravesLookType.values()) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return PRESET_HEAD;
    }

    private static Converter getChestLike(final class_2680 unlocked, final class_2680 locked) {
        return new Converter(){

            @Override
            public class_2248 getBlock(boolean isLocked) {
                return isLocked ? locked.method_26204() : unlocked.method_26204();
            }

            @Override
            public class_2680 getBlockState(int rotation, boolean isLocked) {
                boolean chest = this.getBlock(isLocked) instanceof class_2281;
                class_2350 direction = chest ? class_2350.method_10139((int)(rotation / 4)).method_10153() : class_2350.method_10143((int)(rotation / 6));
                return (class_2680)(isLocked ? locked : unlocked).method_11657((class_2769)(chest ? class_2281.field_10768 : class_2741.field_12525), (Comparable)direction);
            }

            @Override
            public class_2487 getNbtToSend(class_2487 compound, int direction, boolean isLocked, GameProfile owner) {
                return null;
            }
        };
    }

    public static interface Converter {
        public class_2248 getBlock(boolean var1);

        public class_2680 getBlockState(int var1, boolean var2);

        public class_2487 getNbtToSend(class_2487 var1, int var2, boolean var3, GameProfile var4);
    }
}

