/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.other;

import com.mojang.authlib.GameProfile;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.grave.GraveInfo;
import eu.pb4.graves.grave.GraveManager;
import eu.pb4.placeholders.PlaceholderAPI;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_5321;

public class GraveListGui
extends SimpleGui {
    private UUID targetUUID;
    private int ticker = 0;

    public GraveListGui(class_3222 player, GameProfile profile) {
        super(class_3917.field_17326, player, false);
        this.targetUUID = player.method_5667();
        if (player.method_5667().equals(profile.getId())) {
            this.setTitle(ConfigManager.getConfig().guiTitle);
        } else {
            this.setTitle(PlaceholderAPI.parsePredefinedText((class_2561)ConfigManager.getConfig().graveTitle, (Pattern)PlaceholderAPI.PREDEFINED_PLACEHOLDER_PATTERN, Map.of("player", new class_2585(profile.getName()))));
        }
        this.updateIcons();
    }

    private void updateIcons() {
        for (int x = 0; x < this.size; ++x) {
            this.clearSlot(x);
        }
        for (GraveInfo graveInfo : GraveManager.INSTANCE.get(this.targetUUID)) {
            if (this.getFirstEmptySlot() == -1) {
                return;
            }
            Map<String, class_2561> placeholders = graveInfo.getPlaceholders();
            ArrayList<class_5250> parsed = new ArrayList<class_5250>();
            for (class_2561 text : graveInfo.isProtected() ? ConfigManager.getConfig().guiProtectedText : ConfigManager.getConfig().guiText) {
                class_5250 out = (class_5250)PlaceholderAPI.parsePredefinedText((class_2561)text, (Pattern)PlaceholderAPI.PREDEFINED_PLACEHOLDER_PATTERN, placeholders);
                if (out.method_10866().method_10973() == null) {
                    out.method_10862(out.method_10866().method_10977(class_124.field_1068));
                }
                parsed.add(out);
            }
            this.addSlot((GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8106).setName((class_5250)parsed.remove(0)).setLore(parsed).setCallback((index, type, action) -> {
                if (Permissions.check((class_1297)this.player, (String)"universal_graves.teleport", (int)3)) {
                    this.close();
                    class_3218 world = this.player.method_5682().method_3847(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)graveInfo.world));
                    if (world != null) {
                        this.player.method_14251(world, (double)graveInfo.position.method_10263() + 0.5, (double)graveInfo.position.method_10264(), (double)graveInfo.position.method_10260() + 0.5, this.player.method_36454(), this.player.method_36455());
                    }
                }
            }));
        }
    }

    public void onTick() {
        ++this.ticker;
        if (this.ticker % 20 == 0) {
            this.updateIcons();
        }
        super.onTick();
    }
}

