/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.herdmentality;

import net.minecraftforge.common.ForgeConfigSpec;

public class Configuration {
    private final ForgeConfigSpec spec;
    private final ForgeConfigSpec.BooleanValue ignoreNeutralMobs;
    private final ForgeConfigSpec.DoubleValue range;

    public Configuration() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("General settings for the mod.");
        builder.push("general");
        builder.comment("Should neutral mobs like pigs not be affected?");
        this.ignoreNeutralMobs = builder.define("ignoreNeutralMobs", false);
        builder.comment("The range to notify other mobs.");
        this.range = builder.defineInRange("range", 8.0, 0.0, 512.0);
        this.spec = builder.build();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public boolean shouldIgnoreNeutralMobs() {
        return (Boolean)this.ignoreNeutralMobs.get();
    }

    public float getRange() {
        return ((Double)this.range.get()).floatValue();
    }
}

