/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.herdmentality;

import net.darkhax.bookshelf.util.EntityUtils;
import net.darkhax.herdmentality.Configuration;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod(value="herdmentality")
public class HerdMentality {
    public static final String MOD_ID = "herdmentality";
    private final Configuration configuration = new Configuration();
    private final ITag.INamedTag<EntityType<?>> IGNORED_MOBS = EntityTypeTags.createOptional((ResourceLocation)new ResourceLocation("herdmentality", "ignored_mobs"));

    public HerdMentality() {
        MinecraftForge.EVENT_BUS.addListener(this::onEntityDamaged);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, this.configuration.getSpec());
    }

    private void onEntityDamaged(LivingDamageEvent event) {
        LivingEntity target = event.getEntityLiving();
        if (target instanceof MobEntity && !this.IGNORED_MOBS.func_230235_a_((Object)target.func_200600_R())) {
            MobEntity entity = (MobEntity)event.getEntityLiving();
            Entity attacker = event.getSource().func_76346_g();
            if (this.configuration.shouldIgnoreNeutralMobs() && !(entity instanceof IMob)) {
                return;
            }
            if (attacker instanceof FakePlayer) {
                return;
            }
            if (attacker instanceof PlayerEntity && ((PlayerEntity)attacker).func_184812_l_()) {
                return;
            }
            if (attacker instanceof LivingEntity) {
                for (MobEntity nearby : EntityUtils.getEntitiesInArea(entity.getClass(), (World)entity.field_70170_p, (BlockPos)entity.func_233580_cy_(), (float)this.configuration.getRange())) {
                    nearby.func_70604_c((LivingEntity)attacker);
                }
            }
        }
    }
}

