/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.gui;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforge;
import com.github.alexthe666.iceandfire.inventory.ContainerDragonForge;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiDragonForge
extends ContainerScreen<ContainerDragonForge> {
    private static final ResourceLocation TEXTURE_FIRE = new ResourceLocation("iceandfire:textures/gui/dragonforge_fire.png");
    private static final ResourceLocation TEXTURE_ICE = new ResourceLocation("iceandfire:textures/gui/dragonforge_ice.png");
    private static final ResourceLocation TEXTURE_LIGHTNING = new ResourceLocation("iceandfire:textures/gui/dragonforge_lightning.png");
    private final PlayerInventory playerInventory;
    private ContainerDragonForge tileFurnace;
    private int dragonType;

    public GuiDragonForge(ContainerDragonForge container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.playerInventory = inv;
        this.tileFurnace = container;
        if (this.tileFurnace instanceof ContainerDragonForge) {
            this.dragonType = this.tileFurnace.isFire;
        }
    }

    protected void func_230451_b_(MatrixStack stack, int mouseX, int mouseY) {
        FontRenderer font = this.getMinecraft().field_71466_p;
        if (this.tileFurnace != null) {
            String s = I18n.func_135052_a((String)("block.iceandfire.dragonforge_" + DragonType.getNameFromInt(this.dragonType) + "_core"), (Object[])new Object[0]);
            font.func_238421_b_(stack, s, (float)(this.field_146999_f / 2 - font.func_78256_a(s) / 2), 6.0f, 0x404040);
        }
        font.func_238421_b_(stack, this.playerInventory.func_145748_c_().getString(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.dragonType == 0) {
            this.getMinecraft().func_110434_K().func_110577_a(TEXTURE_FIRE);
        } else if (this.dragonType == 1) {
            this.getMinecraft().func_110434_K().func_110577_a(TEXTURE_ICE);
        } else {
            this.getMinecraft().func_110434_K().func_110577_a(TEXTURE_LIGHTNING);
        }
        int k = (this.field_230708_k_ - this.field_146999_f) / 2;
        int l = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        int i1 = this.func_175381_h(126);
        this.func_238474_b_(matrixStack, k + 12, l + 23, 0, 166, i1, 38);
    }

    private int func_175381_h(int p_175381_1_) {
        TileEntity te = IceAndFire.PROXY.getRefrencedTE();
        int j = 0;
        int maxCookTime = 1000;
        if (te instanceof TileEntityDragonforge) {
            maxCookTime = ((TileEntityDragonforge)te).getMaxCookTime(this.tileFurnace.func_75139_a(0).func_75211_c(), this.tileFurnace.func_75139_a(1).func_75211_c());
            j = Math.min(((TileEntityDragonforge)te).cookTime, maxCookTime);
        }
        return j != 0 ? j * p_175381_1_ / maxCookTime : 0;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }
}

