/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model.animator;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ITabulaModelAnimator;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.iceandfire.client.model.animator.IceAndFireTabulaModelAnimator;
import com.github.alexthe666.iceandfire.client.model.util.EnumDragonPoses;
import com.github.alexthe666.iceandfire.client.model.util.LegArticulator;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public abstract class DragonTabulaModelAnimator<T extends EntityDragonBase>
extends IceAndFireTabulaModelAnimator
implements ITabulaModelAnimator<T> {
    protected TabulaModel[] walkPoses;
    protected TabulaModel[] flyPoses;
    protected TabulaModel[] swimPoses;
    protected AdvancedModelBox[] neckParts;
    protected AdvancedModelBox[] tailParts;
    protected AdvancedModelBox[] tailPartsWBody;
    protected AdvancedModelBox[] toesPartsL;
    protected AdvancedModelBox[] toesPartsR;
    protected AdvancedModelBox[] clawL;
    protected AdvancedModelBox[] clawR;
    protected ModelAnimator bakedAnimation;

    public DragonTabulaModelAnimator(TabulaModel baseModel) {
        super(baseModel);
    }

    public void init(TabulaModel model) {
        this.neckParts = new AdvancedModelBox[]{model.getCube("Neck1"), model.getCube("Neck2"), model.getCube("Neck3"), model.getCube("Neck3"), model.getCube("Head")};
        this.tailParts = new AdvancedModelBox[]{model.getCube("Tail1"), model.getCube("Tail2"), model.getCube("Tail3"), model.getCube("Tail4")};
        this.tailPartsWBody = new AdvancedModelBox[]{model.getCube("BodyLower"), model.getCube("Tail1"), model.getCube("Tail2"), model.getCube("Tail3"), model.getCube("Tail4")};
        this.toesPartsL = new AdvancedModelBox[]{model.getCube("ToeL1"), model.getCube("ToeL2"), model.getCube("ToeL3")};
        this.toesPartsR = new AdvancedModelBox[]{model.getCube("ToeR1"), model.getCube("ToeR2"), model.getCube("ToeR3")};
        this.clawL = new AdvancedModelBox[]{model.getCube("ClawL")};
        this.clawR = new AdvancedModelBox[]{model.getCube("ClawR")};
    }

    public void setRotationAngles(TabulaModel model, T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        TabulaModel currentPosition;
        int prevIndex;
        int currentIndex;
        model.resetToDefaultPose();
        if (this.neckParts == null) {
            this.init(model);
        }
        this.animate(model, entity, limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch, scale);
        boolean walking = !((EntityDragonBase)entity).isHovering() && !((EntityDragonBase)entity).isFlying() && ((EntityDragonBase)entity).hoverProgress <= 0.0f && ((EntityDragonBase)entity).flyProgress <= 0.0f;
        boolean swimming = entity.func_70090_H() && ((EntityDragonBase)entity).swimProgress > 0.0f;
        int n = currentIndex = walking ? ((EntityDragonBase)entity).walkCycle / 10 : ((EntityDragonBase)entity).flightCycle / 10;
        if (swimming) {
            currentIndex = ((EntityDragonBase)entity).swimCycle / 10;
        }
        if ((prevIndex = currentIndex - 1) < 0) {
            int n2 = swimming ? 4 : (prevIndex = walking ? 3 : 5);
        }
        TabulaModel tabulaModel = swimming ? this.swimPoses[currentIndex] : (currentPosition = walking ? this.walkPoses[currentIndex] : this.flyPoses[currentIndex]);
        TabulaModel prevPosition = swimming ? this.swimPoses[prevIndex] : (walking ? this.walkPoses[prevIndex] : this.flyPoses[prevIndex]);
        float delta = (float)(walking ? ((EntityDragonBase)entity).walkCycle : ((EntityDragonBase)entity).flightCycle) / 10.0f % 1.0f;
        if (swimming) {
            delta = (float)((EntityDragonBase)entity).swimCycle / 10.0f % 1.0f;
        }
        float partialTick = Minecraft.func_71410_x().func_184121_ak();
        float deltaTicks = delta + partialTick / 10.0f;
        if (delta == 0.0f) {
            deltaTicks = 0.0f;
        }
        for (AdvancedModelBox cube : model.getCubes().values()) {
            this.setRotationsLoop(model, entity, limbSwingAmount, walking, currentPosition, prevPosition, partialTick, deltaTicks, cube);
        }
        float speed_walk = 0.2f;
        float speed_idle = ((EntityDragonBase)entity).func_70608_bn() ? 0.025f : 0.05f;
        float speed_fly = 0.2f;
        float degree_walk = 0.5f;
        float degree_idle = ((EntityDragonBase)entity).func_70608_bn() ? 0.25f : 0.5f;
        float degree_fly = 0.5f;
        if (!((EntityDragonBase)entity).func_175446_cd()) {
            if (!walking) {
                model.bob(model.getCube("BodyUpper"), -speed_fly, degree_fly * 5.0f, false, ageInTicks, 1.0f);
                model.walk(model.getCube("BodyUpper"), -speed_fly, degree_fly * 0.1f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
                model.chainWave(this.tailPartsWBody, speed_fly, degree_fly * -0.1f, 0.0, ageInTicks, 1.0f);
                model.chainWave(this.neckParts, speed_fly, degree_fly * 0.2f, -4.0, ageInTicks, 1.0f);
                model.chainWave(this.toesPartsL, speed_fly, degree_fly * 0.2f, -2.0, ageInTicks, 1.0f);
                model.chainWave(this.toesPartsR, speed_fly, degree_fly * 0.2f, -2.0, ageInTicks, 1.0f);
                model.walk(model.getCube("ThighR"), -speed_fly, degree_fly * 0.1f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
                model.walk(model.getCube("ThighL"), -speed_fly, degree_fly * 0.1f, true, 0.0f, 0.0f, ageInTicks, 1.0f);
            } else {
                model.bob(model.getCube("BodyUpper"), speed_walk * 2.0f, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
                model.bob(model.getCube("ThighR"), speed_walk, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
                model.bob(model.getCube("ThighL"), speed_walk, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
                model.chainSwing(this.tailParts, speed_walk, degree_walk * 0.25f, -2.0, limbSwing, limbSwingAmount);
                model.chainWave(this.tailParts, speed_walk, degree_walk * 0.15f, 2.0, limbSwing, limbSwingAmount);
                model.chainSwing(this.neckParts, speed_walk, degree_walk * 0.15f, 2.0, limbSwing, limbSwingAmount);
                model.chainWave(this.neckParts, speed_walk, degree_walk * 0.05f, -2.0, limbSwing, limbSwingAmount);
                model.chainSwing(this.tailParts, speed_idle, degree_idle * 0.25f, -2.0, ageInTicks, 1.0f);
                model.chainWave(this.tailParts, speed_idle, degree_idle * 0.15f, -2.0, ageInTicks, 1.0f);
                model.chainWave(this.neckParts, speed_idle, degree_idle * -0.15f, -3.0, ageInTicks, 1.0f);
                model.walk(model.getCube("Neck1"), speed_idle, degree_idle * 0.05f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
            }
            model.bob(model.getCube("BodyUpper"), speed_idle, degree_idle * 1.3f, false, ageInTicks, 1.0f);
            model.bob(model.getCube("ThighR"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
            model.bob(model.getCube("ThighL"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
            model.bob(model.getCube("armR1"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
            model.bob(model.getCube("armL1"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
            if (((EntityDragonBase)entity).getAnimation() != EntityDragonBase.ANIMATION_SHAKEPREY || ((EntityDragonBase)entity).getAnimation() != EntityDragonBase.ANIMATION_ROAR) {
                model.faceTarget(rotationYaw, rotationPitch, 4.0f, this.neckParts);
            }
            if (((EntityDragonBase)entity).isActuallyBreathingFire()) {
                float speed_shake = 0.7f;
                float degree_shake = 0.1f;
                model.chainFlap(this.neckParts, speed_shake, degree_shake, 2.0, ageInTicks, 1.0f);
                model.chainSwing(this.neckParts, speed_shake * 0.65f, degree_shake * 0.1f, 1.0, ageInTicks, 1.0f);
            }
        }
        if (!((EntityDragonBase)entity).isModelDead()) {
            if (!(((EntityDragonBase)entity).turn_buffer == null || entity.func_184207_aI() && !entity.func_184218_aH() && ((EntityDragonBase)entity).isBreathingFire())) {
                ((EntityDragonBase)entity).turn_buffer.applyChainSwingBuffer((ModelRenderer[])this.neckParts);
            }
            if (((EntityDragonBase)entity).tail_buffer != null && !entity.func_184218_aH()) {
                ((EntityDragonBase)entity).tail_buffer.applyChainSwingBuffer((ModelRenderer[])this.tailPartsWBody);
            }
            if (((EntityDragonBase)entity).roll_buffer != null && ((EntityDragonBase)entity).pitch_buffer_body != null && ((EntityDragonBase)entity).pitch_buffer != null && (((EntityDragonBase)entity).flyProgress > 0.0f || ((EntityDragonBase)entity).hoverProgress > 0.0f)) {
                ((EntityDragonBase)entity).roll_buffer.applyChainFlapBuffer(new ModelRenderer[]{model.getCube("BodyUpper")});
                ((EntityDragonBase)entity).pitch_buffer_body.applyChainWaveBuffer(new ModelRenderer[]{model.getCube("BodyUpper")});
                ((EntityDragonBase)entity).pitch_buffer.applyChainWaveBufferReverse((ModelRenderer[])this.tailPartsWBody);
            }
        }
        if (entity.func_213311_cf() >= 2.0f && ((EntityDragonBase)entity).flyProgress == 0.0f && ((EntityDragonBase)entity).hoverProgress == 0.0f) {
            LegArticulator.articulateQuadruped(entity, ((EntityDragonBase)entity).legSolver, model.getCube("BodyUpper"), model.getCube("BodyLower"), model.getCube("Neck1"), model.getCube("ThighL"), model.getCube("LegL"), this.toesPartsL, model.getCube("ThighR"), model.getCube("LegR"), this.toesPartsR, model.getCube("armL1"), model.getCube("armL2"), this.clawL, model.getCube("armR1"), model.getCube("armR2"), this.clawR, 1.0f, 0.5f, 0.5f, -0.15f, -0.15f, 0.0f, Minecraft.func_71410_x().func_184121_ak());
        }
    }

    private void setRotationsLoop(TabulaModel model, T entity, float limbSwingAmount, boolean walking, TabulaModel currentPosition, TabulaModel prevPosition, float partialTick, float deltaTicks, AdvancedModelBox cube) {
        float z;
        float y;
        float x;
        float prevZ;
        float prevY;
        float prevX;
        AdvancedModelBox currPositionCube;
        AdvancedModelBox prevPositionCube;
        this.genderMob(entity, cube);
        if (walking && ((EntityDragonBase)entity).flyProgress <= 0.0f && ((EntityDragonBase)entity).hoverProgress <= 0.0f && ((EntityDragonBase)entity).modelDeadProgress <= 0.0f) {
            AdvancedModelBox walkPart = this.getModel(EnumDragonPoses.GROUND_POSE).getCube(cube.boxName);
            prevPositionCube = prevPosition.getCube(cube.boxName);
            if (prevPositionCube == null | (currPositionCube = currentPosition.getCube(cube.boxName)) == null) {
                return;
            }
            prevX = prevPositionCube.field_78795_f;
            prevY = prevPositionCube.field_78796_g;
            prevZ = prevPositionCube.field_78808_h;
            x = currPositionCube.field_78795_f;
            y = currPositionCube.field_78796_g;
            z = currPositionCube.field_78808_h;
            if (this.isWing(model, cube) && (((EntityDragonBase)entity).getAnimation() == EntityDragonBase.ANIMATION_WINGBLAST || ((EntityDragonBase)entity).getAnimation() == EntityDragonBase.ANIMATION_EPIC_ROAR)) {
                this.addToRotateAngle(cube, limbSwingAmount, walkPart.field_78795_f, walkPart.field_78796_g, walkPart.field_78808_h);
            } else {
                this.addToRotateAngle(cube, limbSwingAmount, prevX + deltaTicks * this.distance(prevX, x), prevY + deltaTicks * this.distance(prevY, y), prevZ + deltaTicks * this.distance(prevZ, z));
            }
        }
        if (((EntityDragonBase)entity).modelDeadProgress > 0.0f) {
            TabulaModel pose;
            TabulaModel customPose = this.customPose(entity);
            TabulaModel tabulaModel = pose = customPose == null ? this.getModel(EnumDragonPoses.DEAD) : customPose;
            if (!this.isRotationEqual(cube, pose.getCube(cube.boxName))) {
                this.transitionTo(cube, pose.getCube(cube.boxName), ((EntityDragonBase)entity).prevModelDeadProgress + (((EntityDragonBase)entity).modelDeadProgress - ((EntityDragonBase)entity).prevModelDeadProgress) * Minecraft.func_71410_x().func_184121_ak(), 20.0f, cube.boxName.equals("ThighR") || cube.boxName.equals("ThighL"));
            }
        }
        if (((EntityDragonBase)entity).sleepProgress > 0.0f && !this.isRotationEqual(cube, this.getModel(EnumDragonPoses.SLEEPING_POSE).getCube(cube.boxName))) {
            this.transitionTo(cube, this.getModel(EnumDragonPoses.SLEEPING_POSE).getCube(cube.boxName), MathHelper.func_219799_g((float)partialTick, (float)((EntityDragonBase)entity).prevAnimationProgresses[1], (float)((EntityDragonBase)entity).sleepProgress), 20.0f, false);
        }
        if (((EntityDragonBase)entity).hoverProgress > 0.0f && !this.isRotationEqual(cube, this.getModel(EnumDragonPoses.HOVERING_POSE).getCube(cube.boxName)) && !this.isWing(model, cube) && !cube.boxName.contains("Tail")) {
            this.transitionTo(cube, this.getModel(EnumDragonPoses.HOVERING_POSE).getCube(cube.boxName), MathHelper.func_219799_g((float)partialTick, (float)((EntityDragonBase)entity).prevAnimationProgresses[2], (float)((EntityDragonBase)entity).hoverProgress), 20.0f, false);
        }
        if (((EntityDragonBase)entity).flyProgress > 0.0f && !this.isRotationEqual(cube, this.getModel(EnumDragonPoses.FLYING_POSE).getCube(cube.boxName))) {
            this.transitionTo(cube, this.getModel(EnumDragonPoses.FLYING_POSE).getCube(cube.boxName), MathHelper.func_219799_g((float)partialTick, (float)((EntityDragonBase)entity).prevAnimationProgresses[3], (float)((EntityDragonBase)entity).flyProgress) - MathHelper.func_219799_g((float)partialTick, (float)((EntityDragonBase)entity).prevDiveProgress, (float)((EntityDragonBase)entity).diveProgress) * 2.0f, 20.0f, false);
        }
        if (((EntityDragonBase)entity).sitProgress > 0.0f && !entity.func_184218_aH() && !this.isRotationEqual(cube, this.getModel(EnumDragonPoses.SITTING_POSE).getCube(cube.boxName))) {
            this.transitionTo(cube, this.getModel(EnumDragonPoses.SITTING_POSE).getCube(cube.boxName), MathHelper.func_219799_g((float)partialTick, (float)((EntityDragonBase)entity).prevAnimationProgresses[0], (float)((EntityDragonBase)entity).sitProgress), 20.0f, false);
        }
        if (((EntityDragonBase)entity).ridingProgress > 0.0f && !this.isRotationEqual(cube, this.getModel(EnumDragonPoses.SIT_ON_PLAYER_POSE).getCube(cube.boxName))) {
            this.transitionTo(cube, this.getModel(EnumDragonPoses.SIT_ON_PLAYER_POSE).getCube(cube.boxName), MathHelper.func_219799_g((float)partialTick, (float)((EntityDragonBase)entity).prevAnimationProgresses[5], (float)((EntityDragonBase)entity).ridingProgress), 20.0f, false);
            if (cube.boxName.equals("BodyUpper")) {
                cube.field_78798_e += (-12.0f - cube.field_78798_e) / 20.0f * MathHelper.func_219799_g((float)partialTick, (float)((EntityDragonBase)entity).prevAnimationProgresses[5], (float)((EntityDragonBase)entity).ridingProgress);
            }
        }
        if (((EntityDragonBase)entity).tackleProgress > 0.0f && !this.isRotationEqual(this.getModel(EnumDragonPoses.TACKLE).getCube(cube.boxName), this.getModel(EnumDragonPoses.FLYING_POSE).getCube(cube.boxName)) && !this.isWing(model, cube)) {
            this.transitionTo(cube, this.getModel(EnumDragonPoses.TACKLE).getCube(cube.boxName), MathHelper.func_219799_g((float)partialTick, (float)((EntityDragonBase)entity).prevAnimationProgresses[6], (float)((EntityDragonBase)entity).tackleProgress), 5.0f, false);
        }
        if (((EntityDragonBase)entity).diveProgress > 0.0f && !this.isRotationEqual(cube, this.getModel(EnumDragonPoses.DIVING_POSE).getCube(cube.boxName))) {
            this.transitionTo(cube, this.getModel(EnumDragonPoses.DIVING_POSE).getCube(cube.boxName), MathHelper.func_219799_g((float)partialTick, (float)((EntityDragonBase)entity).prevDiveProgress, (float)((EntityDragonBase)entity).diveProgress), 10.0f, false);
        }
        if (((EntityDragonBase)entity).fireBreathProgress > 0.0f && !this.isRotationEqual(cube, this.getModel(EnumDragonPoses.STREAM_BREATH).getCube(cube.boxName)) && !this.isWing(model, cube) && !cube.boxName.contains("Finger")) {
            if (((EntityDragonBase)entity).prevFireBreathProgress <= ((EntityDragonBase)entity).fireBreathProgress) {
                this.transitionTo(cube, this.getModel(EnumDragonPoses.BLAST_CHARGE3).getCube(cube.boxName), MathHelper.func_76131_a((float)MathHelper.func_219799_g((float)partialTick, (float)((EntityDragonBase)entity).prevFireBreathProgress, (float)((EntityDragonBase)entity).fireBreathProgress), (float)0.0f, (float)5.0f), 5.0f, false);
            }
            this.transitionTo(cube, this.getModel(EnumDragonPoses.STREAM_BREATH).getCube(cube.boxName), MathHelper.func_76131_a((float)(MathHelper.func_219799_g((float)partialTick, (float)((EntityDragonBase)entity).prevFireBreathProgress, (float)((EntityDragonBase)entity).fireBreathProgress) - 5.0f), (float)0.0f, (float)5.0f), 5.0f, false);
        }
        if (!walking) {
            AdvancedModelBox flightPart = this.getModel(EnumDragonPoses.FLYING_POSE).getCube(cube.boxName);
            prevPositionCube = prevPosition.getCube(cube.boxName);
            currPositionCube = currentPosition.getCube(cube.boxName);
            prevX = prevPositionCube.field_78795_f;
            prevY = prevPositionCube.field_78796_g;
            prevZ = prevPositionCube.field_78808_h;
            x = currPositionCube.field_78795_f;
            y = currPositionCube.field_78796_g;
            z = currPositionCube.field_78808_h;
            if (x != flightPart.field_78795_f || y != flightPart.field_78796_g || z != flightPart.field_78808_h) {
                this.setRotateAngle(cube, 1.0f, prevX + deltaTicks * this.distance(prevX, x), prevY + deltaTicks * this.distance(prevY, y), prevZ + deltaTicks * this.distance(prevZ, z));
            }
        }
    }

    protected boolean isWing(TabulaModel model, AdvancedModelBox modelRenderer) {
        return model.getCube("armL1") == modelRenderer || model.getCube("armR1") == modelRenderer || model.getCube((String)"armL1").field_78805_m.contains((Object)modelRenderer) || model.getCube((String)"armR1").field_78805_m.contains((Object)modelRenderer);
    }

    protected TabulaModel customPose(T entity) {
        try {
            return this.getModel(EnumDragonPoses.valueOf(((EntityDragonBase)entity).getCustomPose()));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    protected boolean isHorn(AdvancedModelBox modelRenderer) {
        return modelRenderer.boxName.contains("Horn");
    }

    public void animate(TabulaModel model, T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        if (this.bakedAnimation == null) {
            this.bakeAnimation(model, entity, limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch, scale);
        } else {
            model.llibAnimator = this.bakedAnimation;
        }
    }

    protected void genderMob(T entity, AdvancedModelBox cube) {
        if (!((EntityDragonBase)entity).isMale()) {
            TabulaModel maleModel = this.getModel(EnumDragonPoses.MALE);
            TabulaModel femaleModel = this.getModel(EnumDragonPoses.FEMALE);
            AdvancedModelBox femaleModelCube = femaleModel.getCube(cube.boxName);
            AdvancedModelBox maleModelCube = maleModel.getCube(cube.boxName);
            if (maleModelCube == null || femaleModelCube == null) {
                return;
            }
            float x = femaleModelCube.field_78795_f;
            float y = femaleModelCube.field_78796_g;
            float z = femaleModelCube.field_78808_h;
            if (x != maleModelCube.field_78795_f || y != maleModelCube.field_78796_g || z != maleModelCube.field_78808_h) {
                this.setRotateAngle(cube, 1.0f, x, y, z);
            }
        }
    }

    protected abstract TabulaModel getModel(EnumDragonPoses var1);

    protected void bakeAnimation(TabulaModel model, T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        AdvancedModelBox modelCubeJaw = model.getCube("Jaw");
        AdvancedModelBox modelCubeBodyUpper = model.getCube("BodyUpper");
        model.llibAnimator.update(entity);
        model.llibAnimator.setAnimation(EntityDragonBase.ANIMATION_FIRECHARGE);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, this.getModel(EnumDragonPoses.BLAST_CHARGE1));
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, this.getModel(EnumDragonPoses.BLAST_CHARGE2));
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, this.getModel(EnumDragonPoses.BLAST_CHARGE3));
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(5);
        model.llibAnimator.setAnimation(EntityDragonBase.ANIMATION_SPEAK);
        model.llibAnimator.startKeyframe(5);
        this.rotate(model.llibAnimator, modelCubeJaw, 18.0f, 0.0f, 0.0f);
        model.llibAnimator.move(modelCubeJaw, 0.0f, 0.0f, 0.2f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.setStaticKeyframe(5);
        model.llibAnimator.startKeyframe(5);
        this.rotate(model.llibAnimator, modelCubeJaw, 18.0f, 0.0f, 0.0f);
        model.llibAnimator.move(modelCubeJaw, 0.0f, 0.0f, 0.2f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(5);
        model.llibAnimator.setAnimation(EntityDragonBase.ANIMATION_BITE);
        model.llibAnimator.startKeyframe(10);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.BITE1));
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.BITE2));
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.BITE3));
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityDragonBase.ANIMATION_SHAKEPREY);
        model.llibAnimator.startKeyframe(15);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.GRAB1));
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.GRAB2));
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.GRAB_SHAKE1));
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.GRAB_SHAKE2));
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.GRAB_SHAKE3));
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityDragonBase.ANIMATION_TAILWHACK);
        model.llibAnimator.startKeyframe(10);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.TAIL_WHIP1));
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.TAIL_WHIP2));
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.TAIL_WHIP3));
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityDragonBase.ANIMATION_WINGBLAST);
        model.llibAnimator.startKeyframe(5);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.WING_BLAST3), true);
        model.llibAnimator.move(modelCubeBodyUpper, 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.WING_BLAST4), true);
        model.llibAnimator.move(modelCubeBodyUpper, 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.WING_BLAST3), true);
        model.llibAnimator.move(modelCubeBodyUpper, 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.WING_BLAST4), true);
        model.llibAnimator.move(modelCubeBodyUpper, 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.WING_BLAST5), true);
        model.llibAnimator.move(modelCubeBodyUpper, 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.WING_BLAST6), true);
        model.llibAnimator.move(modelCubeBodyUpper, 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.WING_BLAST7), true);
        model.llibAnimator.move(modelCubeBodyUpper, 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityDragonBase.ANIMATION_ROAR);
        model.llibAnimator.startKeyframe(10);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.ROAR1));
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.ROAR2));
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.ROAR3));
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityDragonBase.ANIMATION_EPIC_ROAR);
        model.llibAnimator.startKeyframe(10);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.EPIC_ROAR1));
        model.llibAnimator.move(modelCubeBodyUpper, 0.0f, -6.8f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.EPIC_ROAR2));
        model.llibAnimator.move(modelCubeBodyUpper, 0.0f, -6.8f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.EPIC_ROAR3));
        model.llibAnimator.move(modelCubeBodyUpper, 0.0f, -6.8f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.EPIC_ROAR2));
        model.llibAnimator.move(modelCubeBodyUpper, 0.0f, -6.8f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPoseSameModel(model, this.getModel(EnumDragonPoses.EPIC_ROAR3));
        model.llibAnimator.move(modelCubeBodyUpper, 0.0f, -6.8f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
    }
}

