/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus;

import com.litewolf101.illagers_plus.client.render.RenderRegistry;
import com.litewolf101.illagers_plus.commands.RegisterCommandEvent;
import com.litewolf101.illagers_plus.config.ModConfig;
import com.litewolf101.illagers_plus.event.MakeIllagersPlusActuallyEvilEvent;
import com.litewolf101.illagers_plus.init.EntityInit;
import com.litewolf101.illagers_plus.init.IllagersPlusItemGroup;
import com.litewolf101.illagers_plus.world.ModConfiguredStructures;
import com.litewolf101.illagers_plus.world.ModStructures;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.world.World;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="illagers_plus")
public class IllagersPlus {
    public static final ItemGroup ILLAGERS_PLUS = new IllagersPlusItemGroup();
    public static final String MOD_ID = "illagers_plus";
    private static final Logger LOGGER = LogManager.getLogger();

    public IllagersPlus() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModStructures.DEFERRED_REGISTRY_STRUCTURE.register(modBus);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        forgeBus.addListener(EventPriority.HIGH, this::biomeModification);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientRegistries);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ModConfig.COMMON_SPEC);
        modBus.register(ModConfig.class);
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new MakeIllagersPlusActuallyEvilEvent());
        event.enqueueWork(() -> {
            ModStructures.setupStructures();
            ModConfiguredStructures.registerConfiguredStructures();
            LOGGER.info("Made the world slightly more miserable");
        });
        this.translateToWaves(EntityInit.ARCHER, ModConfig.getArcherWaveCounts());
        this.translateToWaves(EntityInit.BERSERKER, ModConfig.getBerserkerWaveCounts());
        this.translateToWaves(EntityInit.BLACK_IRON_GOLEM, ModConfig.getBlackIronGolemWaveCounts());
        this.translateToWaves(EntityInit.ENCHANTER, ModConfig.getEnchanterWaveCounts());
        this.translateToWaves(EntityInit.FURANTUR, ModConfig.getFuranturWaveCounts());
        this.translateToWaves(EntityInit.HOARDER, ModConfig.getHoarderWaveCounts());
        this.translateToWaves(EntityInit.ILLAGER_KING, ModConfig.getIllagerKingWaveCounts());
        this.translateToWaves(EntityInit.MINER, ModConfig.getMinerWaveCounts());
        this.translateToWaves(EntityInit.NECROMANCER, ModConfig.getNecromancerWaveCounts());
        this.translateToWaves(EntityInit.FROSTMANCER, ModConfig.getFrostmancerWaveCounts());
        this.translateToWaves(EntityInit.ILLAGER_GENERAL, ModConfig.getIllagerGeneralWaveCounts());
        LOGGER.info("Added Illagers to Raids");
        MinecraftForge.EVENT_BUS.register(RegisterCommandEvent.class);
    }

    public void biomeModification(BiomeLoadingEvent event) {
        event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_ARCHER_TOWER);
        event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_ILLAGER_CENTRE);
        event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_ILLAGER_FORT);
        event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_ILLAGER_MINE);
        event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_ILLAGER_TOWER);
        event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_ICE_CASTLE);
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.put(ModStructures.ILLAGER_ARCHER_TOWER.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ModStructures.ILLAGER_ARCHER_TOWER.get()));
            tempMap.put(ModStructures.ILLAGER_CENTRE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ModStructures.ILLAGER_CENTRE.get()));
            tempMap.put(ModStructures.ILLAGER_MINE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ModStructures.ILLAGER_MINE.get()));
            tempMap.put(ModStructures.ILLAGER_TOWER.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ModStructures.ILLAGER_TOWER.get()));
            tempMap.put(ModStructures.ILLAGER_FORT.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ModStructures.ILLAGER_FORT.get()));
            tempMap.put(ModStructures.ICE_CASTLE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ModStructures.ICE_CASTLE.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }

    private void clientRegistries(FMLClientSetupEvent event) {
        RenderRegistry.registerEntityRenders();
        LOGGER.info("Made things look pretty");
    }

    private void translateToWaves(EntityType<? extends AbstractRaiderEntity> type, List<? extends Integer> list) {
        Raid.WaveMember.create((String)type.getRegistryName().toString(), type, (int[])new int[]{list.get(0), list.get(1), list.get(2), list.get(3), list.get(4), list.get(5), list.get(6), list.get(7)});
    }
}

