/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="illagers_plus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModConfig {
    public static int archerTowerMinDist;
    public static int archerTowerMaxDist;
    public static List<? extends String> archerTowerBlacklistBiomes;
    public static int centreMinDist;
    public static int centreMaxDist;
    public static List<? extends String> centreBlacklistBiomes;
    public static int fortMinDist;
    public static int fortMaxDist;
    public static List<? extends String> fortBlacklistBiomes;
    public static int mineMinDist;
    public static int mineMaxDist;
    public static List<? extends String> mineBlacklistBiomes;
    public static int towerMinDist;
    public static int towerMaxDist;
    public static List<? extends String> towerBlacklistBiomes;
    public static int iceCastleMinDist;
    public static int iceCastleMaxDist;
    public static List<? extends String> iceCastleBlacklistBiomes;
    public static List<? extends String> spawnDimensionBlacklist;
    public static List<? extends Integer> archerWaveCounts;
    public static List<? extends Integer> berserkerWaveCounts;
    public static List<? extends Integer> blackIronGolemWaveCounts;
    public static List<? extends Integer> enchanterWaveCounts;
    public static List<? extends Integer> furanturWaveCounts;
    public static List<? extends Integer> hoarderWaveCounts;
    public static List<? extends Integer> illagerKingWaveCounts;
    public static List<? extends Integer> minerWaveCounts;
    public static List<? extends Integer> necromancerWaveCounts;
    public static List<? extends Integer> frostmancerWaveCounts;
    public static List<? extends Integer> illagerGeneralWaveCounts;
    public static final Config COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            ModConfig.bakeConfig();
        }
    }

    public static void bakeConfig() {
        archerTowerMinDist = (Integer)ModConfig.COMMON.archerTowerMinDist.get();
        archerTowerMaxDist = (Integer)ModConfig.COMMON.archerTowerMaxDist.get();
        centreMinDist = (Integer)ModConfig.COMMON.centreMinDist.get();
        centreMaxDist = (Integer)ModConfig.COMMON.centreMaxDist.get();
        fortMinDist = (Integer)ModConfig.COMMON.fortMinDist.get();
        fortMaxDist = (Integer)ModConfig.COMMON.fortMaxDist.get();
        mineMinDist = (Integer)ModConfig.COMMON.mineMinDist.get();
        mineMaxDist = (Integer)ModConfig.COMMON.mineMaxDist.get();
        towerMinDist = (Integer)ModConfig.COMMON.towerMinDist.get();
        towerMaxDist = (Integer)ModConfig.COMMON.towerMaxDist.get();
        iceCastleMinDist = (Integer)ModConfig.COMMON.iceCastleMinDist.get();
        iceCastleMaxDist = (Integer)ModConfig.COMMON.iceCastleMaxDist.get();
        archerTowerBlacklistBiomes = (List)ModConfig.COMMON.archerTowerBlacklist.get();
        centreBlacklistBiomes = (List)ModConfig.COMMON.centreBlacklist.get();
        fortBlacklistBiomes = (List)ModConfig.COMMON.fortBlacklist.get();
        mineBlacklistBiomes = (List)ModConfig.COMMON.mineBlacklist.get();
        towerBlacklistBiomes = (List)ModConfig.COMMON.towerBlacklist.get();
        iceCastleBlacklistBiomes = (List)ModConfig.COMMON.iceCastleBlacklist.get();
        spawnDimensionBlacklist = (List)ModConfig.COMMON.structureSpawnDimensionBlacklist.get();
        archerWaveCounts = (List)ModConfig.COMMON.archerWaveCounts.get();
        berserkerWaveCounts = (List)ModConfig.COMMON.berserkerWaveCounts.get();
        blackIronGolemWaveCounts = (List)ModConfig.COMMON.blackIronGolemWaveCounts.get();
        enchanterWaveCounts = (List)ModConfig.COMMON.enchanterWaveCounts.get();
        furanturWaveCounts = (List)ModConfig.COMMON.furanturWaveCounts.get();
        hoarderWaveCounts = (List)ModConfig.COMMON.hoarderWaveCounts.get();
        illagerKingWaveCounts = (List)ModConfig.COMMON.illagerKingWaveCounts.get();
        minerWaveCounts = (List)ModConfig.COMMON.minerWaveCounts.get();
        necromancerWaveCounts = (List)ModConfig.COMMON.necromancerWaveCounts.get();
        frostmancerWaveCounts = (List)ModConfig.COMMON.frostmancerWaveCounts.get();
        illagerGeneralWaveCounts = (List)ModConfig.COMMON.illagerGeneralWaveCounts.get();
    }

    public static int getArcherTowerMinDist() {
        return archerTowerMinDist;
    }

    public static int getArcherTowerMaxDist() {
        return archerTowerMaxDist;
    }

    public static int getCentreMinDist() {
        return centreMinDist;
    }

    public static int getCentreMaxDist() {
        return centreMaxDist;
    }

    public static int getFortMinDist() {
        return fortMinDist;
    }

    public static int getFortMaxDist() {
        return fortMaxDist;
    }

    public static int getMineMinDist() {
        return mineMinDist;
    }

    public static int getMineMaxDist() {
        return mineMaxDist;
    }

    public static int getTowerMinDist() {
        return towerMinDist;
    }

    public static int getTowerMaxDist() {
        return towerMaxDist;
    }

    public static int getIceCastleMinDist() {
        return iceCastleMinDist;
    }

    public static int getIceCastleMaxDist() {
        return iceCastleMaxDist;
    }

    public static List<? extends String> getArcherTowerBlacklistedBiomes() {
        return archerTowerBlacklistBiomes;
    }

    public static List<? extends String> getCentreBlacklistedBiomes() {
        return centreBlacklistBiomes;
    }

    public static List<? extends String> getFortBlacklistedBiomes() {
        return fortBlacklistBiomes;
    }

    public static List<? extends String> getMineBlacklistedBiomes() {
        return mineBlacklistBiomes;
    }

    public static List<? extends String> getTowerBlacklistedBiomes() {
        return towerBlacklistBiomes;
    }

    public static List<? extends String> getIceCastleBlacklistedBiomes() {
        return iceCastleBlacklistBiomes;
    }

    public static List<? extends String> getSpawnBlacklistedDimensions() {
        return spawnDimensionBlacklist;
    }

    public static List<? extends Integer> getArcherWaveCounts() {
        return archerWaveCounts;
    }

    public static List<? extends Integer> getBerserkerWaveCounts() {
        return berserkerWaveCounts;
    }

    public static List<? extends Integer> getBlackIronGolemWaveCounts() {
        return blackIronGolemWaveCounts;
    }

    public static List<? extends Integer> getEnchanterWaveCounts() {
        return enchanterWaveCounts;
    }

    public static List<? extends Integer> getFuranturWaveCounts() {
        return furanturWaveCounts;
    }

    public static List<? extends Integer> getHoarderWaveCounts() {
        return hoarderWaveCounts;
    }

    public static List<? extends Integer> getIllagerKingWaveCounts() {
        return illagerKingWaveCounts;
    }

    public static List<? extends Integer> getMinerWaveCounts() {
        return minerWaveCounts;
    }

    public static List<? extends Integer> getNecromancerWaveCounts() {
        return necromancerWaveCounts;
    }

    public static List<? extends Integer> getFrostmancerWaveCounts() {
        return frostmancerWaveCounts;
    }

    public static List<? extends Integer> getIllagerGeneralWaveCounts() {
        return illagerGeneralWaveCounts;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
    }

    public static class Config {
        public final ForgeConfigSpec.IntValue archerTowerMinDist;
        public final ForgeConfigSpec.IntValue archerTowerMaxDist;
        public final ForgeConfigSpec.IntValue centreMinDist;
        public final ForgeConfigSpec.IntValue centreMaxDist;
        public final ForgeConfigSpec.IntValue fortMinDist;
        public final ForgeConfigSpec.IntValue fortMaxDist;
        public final ForgeConfigSpec.IntValue mineMinDist;
        public final ForgeConfigSpec.IntValue mineMaxDist;
        public final ForgeConfigSpec.IntValue towerMinDist;
        public final ForgeConfigSpec.IntValue towerMaxDist;
        public final ForgeConfigSpec.IntValue iceCastleMinDist;
        public final ForgeConfigSpec.IntValue iceCastleMaxDist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> archerTowerBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> centreBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> mineBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> fortBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> towerBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> iceCastleBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> structureSpawnDimensionBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> archerWaveCounts;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> berserkerWaveCounts;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> blackIronGolemWaveCounts;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> enchanterWaveCounts;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> furanturWaveCounts;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> hoarderWaveCounts;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> illagerKingWaveCounts;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> minerWaveCounts;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> necromancerWaveCounts;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> frostmancerWaveCounts;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> illagerGeneralWaveCounts;

        public Config(ForgeConfigSpec.Builder builder) {
            builder.push("Structure Config");
            builder.comment(new String[]{"This is the configuration section for controlling the minimum and maximum feature spread distance for structures (in chunks)", "WARNING: THE MINIMUM SPREAD DISTANCE CANNOT BE GREATER THAN THE MAXIMUM SPREAD DISTANCE!"}).push("Structure Feature Distance Values");
            builder.push("Illager Archer Tower");
            this.archerTowerMinDist = builder.comment("Archer Tower: Minimum spread dist").translation("illagers_plus.config.atMin").worldRestart().defineInRange("archerTowerMinDist", 45, 1, 256);
            this.archerTowerMaxDist = builder.comment("Archer Tower: Maximum spread dist").translation("illagers_plus.config.atMax").worldRestart().defineInRange("archerTowerMaxDist", 70, 1, 256);
            builder.pop();
            builder.push("Illager Centre");
            this.centreMinDist = builder.comment("Centre: Minimum spread dist").translation("illagers_plus.config.cMin").worldRestart().defineInRange("centreMinDist", 60, 1, 256);
            this.centreMaxDist = builder.comment("Centre: Maximum spread dist").translation("illagers_plus.config.cMax").worldRestart().defineInRange("centreMaxDist", 90, 1, 256);
            builder.pop();
            builder.push("Illager Fort");
            this.fortMinDist = builder.comment("Fort: Minimum spread dist").translation("illagers_plus.config.fMin").worldRestart().defineInRange("fortMinDist", 80, 1, 256);
            this.fortMaxDist = builder.comment("Fort: Maximum spread dist").translation("illagers_plus.config.fMax").worldRestart().defineInRange("fortMaxDist", 100, 1, 256);
            builder.pop();
            builder.push("Illager Mine");
            this.mineMinDist = builder.comment("Mine: Minimum spread dist").translation("illagers_plus.config.mMin").worldRestart().defineInRange("mineMinDist", 50, 1, 256);
            this.mineMaxDist = builder.comment("Mine: Maximum spread dist").translation("illagers_plus.config.mMax").worldRestart().defineInRange("mineMaxDist", 75, 1, 256);
            builder.pop();
            builder.push("Illager Tower");
            this.towerMinDist = builder.comment("Tower: Minimum spread dist").translation("illagers_plus.config.tMin").worldRestart().defineInRange("towerMinDist", 65, 1, 256);
            this.towerMaxDist = builder.comment("Tower: Maximum spread dist").translation("illagers_plus.config.tMax").worldRestart().defineInRange("towerMaxDist", 70, 1, 256);
            builder.pop();
            builder.push("Ice Castle");
            this.iceCastleMinDist = builder.comment("Castle: Minimum spread dist").translation("illagers_plus.config.iceMin").worldRestart().defineInRange("iceCastleMinDist", 80, 1, 256);
            this.iceCastleMaxDist = builder.comment("Castle: Maximum spread dist").translation("illagers_plus.config.iceMax").worldRestart().defineInRange("iceCastleMaxDist", 85, 1, 256);
            builder.pop();
            builder.pop();
            builder.comment("This is the configuration section for controlling the biomes structures spawn in.").push("Structure Feature Blacklists");
            builder.push("Illager Archer Tower");
            this.archerTowerBlacklist = builder.comment("Biomes for Illager Archer Tower to not spawn in").translation("illagers_plus.config.iat_blacklist").worldRestart().defineList("blacklist", Arrays.asList("river", "ocean", "the_end", "nether"), s -> s instanceof String);
            builder.pop();
            builder.push("Illager Centre");
            this.centreBlacklist = builder.comment("Biomes for Illager Centre to not spawn in").translation("illagers_plus.config.ic_blacklist").worldRestart().defineList("blacklist", Arrays.asList("river", "ocean", "the_end", "nether"), s -> s instanceof String);
            builder.pop();
            builder.push("Illager Fort");
            this.fortBlacklist = builder.comment("Biomes for Illager Fort to not spawn in").translation("illagers_plus.config.if_blacklist").worldRestart().defineList("blacklist", Arrays.asList("river", "ocean", "extreme_hills", "nether", "the_end", "HILLS", "taiga", "icy", "swamp"), s -> s instanceof String);
            builder.pop();
            builder.push("Illager Mine");
            this.mineBlacklist = builder.comment("Biomes for Illager Mine to not spawn in").translation("illagers_plus.config.im_blacklist").worldRestart().defineList("blacklist", Arrays.asList("river", "ocean", "taiga", "extreme_hills", "jungle", "plains", "icy", "the_end", "nether", "beach", "forest", "swamp"), s -> s instanceof String);
            builder.pop();
            builder.push("Illager Tower");
            this.towerBlacklist = builder.comment("Biomes for Illager Tower to not spawn in").translation("illagers_plus.config.it_blacklist").worldRestart().defineList("blacklist", Arrays.asList("river", "ocean", "the_end", "nether", "taiga", "extreme_hills", "beach", "icy", "desert", "mesa"), s -> s instanceof String);
            builder.pop();
            builder.push("Ice Castle");
            this.iceCastleBlacklist = builder.comment("Biomes for Ice Castle to not spawn in. Ice castles only spawn on top of peaks of mountains anyways").translation("illagers_plus.config.ice_blacklist").worldRestart().defineList("blacklist", Arrays.asList("none", "jungle", "mesa", "plains", "savanna", "the_end", "beach", "forest", "ocean", "desert", "river", "swamp", "mushroom", "nether"), s -> s instanceof String);
            builder.pop();
            builder.push("Dimensional Blacklist");
            this.structureSpawnDimensionBlacklist = builder.comment("Dimensions for all Illagers+ structures to not spawn in").translation("illagers_plus.config.dim_blacklist").worldRestart().defineList("blacklist", Arrays.asList("minecraft:the_nether", "minecraft:the_end"), s -> s instanceof String);
            builder.pop();
            builder.pop();
            builder.comment(new String[]{"This is the configuration section for controlling the amount of entities per wave to spawn.", "WARNING: LISTS MUST BE NO LONGER OR SHORTER THAN 8 ENTRIES!", "NOTE: SETTING THE LIST TO ALL ZEROS WILL PREVENT THAT ENTITY FROM SPAWNING IN ANY WAVES!"}).push("Raid Wave Member Config");
            builder.push("Archer");
            this.archerWaveCounts = builder.comment("Archer Wave Counts").translation("illagers_plus.config.archer_wc").worldRestart().defineList("wave_counts", Arrays.asList(1, 0, 0, 0, 1, 2, 2, 3), s -> s instanceof Integer);
            builder.pop();
            builder.push("Berserker");
            this.berserkerWaveCounts = builder.comment("Berserker Wave Counts").translation("illagers_plus.config.berserker_wc").worldRestart().defineList("wave_counts", Arrays.asList(0, 0, 0, 0, 0, 1, 1, 1), s -> s instanceof Integer);
            builder.pop();
            builder.push("Black Iron Golem");
            this.blackIronGolemWaveCounts = builder.comment("Black Iron Golem Wave Counts").translation("illagers_plus.config.black_iron_golem_wc").worldRestart().defineList("wave_counts", Arrays.asList(0, 0, 1, 0, 0, 1, 0, 1), s -> s instanceof Integer);
            builder.pop();
            builder.push("Enchanter");
            this.enchanterWaveCounts = builder.comment("Enchanter Wave Counts").translation("illagers_plus.config.enchanter_wc").worldRestart().defineList("wave_counts", Arrays.asList(0, 1, 0, 1, 0, 1, 0, 1), s -> s instanceof Integer);
            builder.pop();
            builder.push("Furantur");
            this.furanturWaveCounts = builder.comment("Furantur Wave Counts").translation("illagers_plus.config.furantur_wc").worldRestart().defineList("wave_counts", Arrays.asList(1, 0, 1, 1, 0, 2, 1, 2), s -> s instanceof Integer);
            builder.pop();
            builder.push("Hoarder");
            this.hoarderWaveCounts = builder.comment("Hoarder Wave Counts").translation("illagers_plus.config.hoarder_wc").worldRestart().defineList("wave_counts", Arrays.asList(1, 1, 1, 1, 1, 1, 1, 1), s -> s instanceof Integer);
            builder.pop();
            builder.push("Illager King");
            this.illagerKingWaveCounts = builder.comment("Illager King Wave Counts").translation("illagers_plus.config.illager_king_wc").worldRestart().defineList("wave_counts", Arrays.asList(0, 0, 0, 1, 0, 0, 0, 1), s -> s instanceof Integer);
            builder.pop();
            builder.push("Necromancer");
            this.necromancerWaveCounts = builder.comment("Necromancer Wave Counts").translation("illagers_plus.config.necromancer_wc").worldRestart().defineList("wave_counts", Arrays.asList(0, 0, 1, 0, 1, 1, 1, 1), s -> s instanceof Integer);
            builder.pop();
            builder.push("Miner");
            this.minerWaveCounts = builder.comment("Miner Wave Counts").translation("illagers_plus.config.miner_wc").worldRestart().defineList("wave_counts", Arrays.asList(0, 0, 0, 0, 0, 0, 0, 0), s -> s instanceof Integer);
            builder.pop();
            builder.push("Frostmancer");
            this.frostmancerWaveCounts = builder.comment("Frostmancer Wave Counts").translation("illagers_plus.config.frostmancer_wc").worldRestart().defineList("wave_counts", Arrays.asList(0, 0, 0, 0, 0, 0, 0, 0), s -> s instanceof Integer);
            builder.pop();
            builder.push("Illager_General");
            this.illagerGeneralWaveCounts = builder.comment("Illager General Wave Counts").translation("illagers_plus.config.illager_general_wc").worldRestart().defineList("wave_counts", Arrays.asList(1, 0, 0, 1, 0, 0, 1, 1), s -> s instanceof Integer);
            builder.pop();
            builder.pop();
        }
    }
}

