/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.event;

import com.google.common.collect.ImmutableList;
import com.litewolf101.illagers_plus.objects.enchantments.IllagerBaneEnchantment;
import com.litewolf101.illagers_plus.objects.entity.EntityAbstractIllagerPlus;
import com.litewolf101.illagers_plus.objects.entity.EntityBlackIronGolem;
import com.litewolf101.illagers_plus.objects.entity.EntityIllagerGeneral;
import com.litewolf101.illagers_plus.objects.entity.EntityNecromancer;
import com.litewolf101.illagers_plus.utils.FortRaidManager;
import com.litewolf101.illagers_plus.world.ModStructures;
import java.util.Calendar;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MakeIllagersPlusActuallyEvilEvent {
    private static boolean isInIceCastle;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void OnInventoryTick(ItemTooltipEvent event) {
        if (event.getItemStack() != null && event.getItemStack().func_77948_v()) {
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)event.getItemStack());
            for (Object enchantment : enchants.keySet()) {
                if (!(enchantment instanceof IllagerBaneEnchantment)) continue;
                float damage = (float)((Integer)enchants.get(enchantment)).intValue() * 1.5f;
                event.getToolTip().add(new StringTextComponent(TextFormatting.BLUE + "+" + damage + " Damage to Illager-Type Mobs"));
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof VillagerEntity) {
            VillagerEntity villager = (VillagerEntity)event.getEntity();
            villager.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)villager, EntityAbstractIllagerPlus.class, 16.0f, 0.7, 0.7));
            villager.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)villager, EntityBlackIronGolem.class, 16.0f, 0.7, 0.7));
            villager.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)villager, EntityNecromancer.class, 16.0f, 0.7, 0.7));
        }
    }

    @SubscribeEvent
    public void onGeneralDeath(LivingDeathEvent event) {
        ServerWorld serverWorld;
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        World world = entity.func_130014_f_();
        if (!world.func_201670_d() && entity instanceof EntityIllagerGeneral && source.func_76346_g() != null && (serverWorld = world.func_73046_m().func_71218_a(world.func_234923_W_())).func_241827_a(SectionPos.func_218167_a((BlockPos)entity.func_233580_cy_()), (Structure)ModStructures.ILLAGER_FORT.get()).findAny().isPresent() && source.func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source.func_76346_g();
            FortRaidManager saver = FortRaidManager.forWorld((ServerWorld)world);
            saver.generalDeathTick((ServerPlayerEntity)player);
        }
    }

    @SubscribeEvent
    public void onIceCastleEntered(TickEvent.PlayerTickEvent event) {
        World world = event.player.func_130014_f_();
        if (!(event.player instanceof FakePlayer) && !world.field_72995_K) {
            ServerWorld serverWorld = world.func_73046_m().func_71218_a(world.func_234923_W_());
            if (serverWorld.func_241827_a(SectionPos.func_218167_a((BlockPos)event.player.func_233580_cy_()), (Structure)ModStructures.ICE_CASTLE.get()).findAny().isPresent()) {
                Optional fort = serverWorld.func_241827_a(SectionPos.func_218167_a((BlockPos)event.player.func_233580_cy_()), (Structure)ModStructures.ICE_CASTLE.get()).findAny();
                for (StructurePiece component : ((StructureStart)fort.get()).func_186161_c()) {
                    if (component.func_74874_b().func_175898_b((Vector3i)event.player.func_233580_cy_()) && !event.player.func_175149_v() && !event.player.func_184812_l_()) {
                        event.player.func_195064_c(new EffectInstance(Effects.field_76421_d, 20));
                        event.player.func_195064_c(new EffectInstance(Effects.field_76419_f, 20));
                        isInIceCastle = true;
                        break;
                    }
                    isInIceCastle = false;
                }
            } else {
                isInIceCastle = false;
            }
        }
        if (isInIceCastle) {
            for (int i = 0; i < 10; ++i) {
                world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197628_u, Blocks.field_196604_cC.func_176223_P()), event.player.func_226282_d_(20.0), event.player.func_226278_cu_() + (double)world.func_201674_k().nextInt(40) - 20.0, event.player.func_226287_g_(20.0), 0.0, 0.0, 0.0);
            }
        }
    }

    @SubscribeEvent
    public void tickFortRaids(TickEvent.WorldTickEvent event) {
        FortRaidManager saver = FortRaidManager.forWorld((ServerWorld)event.world);
        saver.tick();
    }

    @SubscribeEvent
    public void birthdayEvent(EntityJoinWorldEvent event) {
        World world = event.getWorld();
        Entity entity = event.getEntity();
        if (!world.func_201670_d() && entity instanceof PlayerEntity && Calendar.getInstance(Calendar.getInstance().getTimeZone()).get(2) == 5 && Calendar.getInstance(Calendar.getInstance().getTimeZone()).get(5) == 30) {
            entity.func_145747_a((ITextComponent)this.convertIntoRainbow("Happy Birthday Illagers+!"), Util.field_240973_b_);
        }
    }

    private TextComponent convertIntoRainbow(String s) {
        StringTextComponent start = new StringTextComponent("");
        ImmutableList styles = ImmutableList.of((Object)Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)0xFF0000)), (Object)Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)16747520)), (Object)Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)16770560)), (Object)Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)917248)), (Object)Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)30719)), (Object)Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)0x6F00FF)), (Object)Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)0xFF00FF)));
        for (int i = 0; i < s.length(); ++i) {
            start.func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(s.charAt(i))).func_230530_a_((Style)styles.get(i % 7)));
        }
        return (TextComponent)start.func_230530_a_(Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/illagers")).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Illagers+ Curseforge Page"))));
    }
}

